/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.shadow.net.minecraftforge.util.download;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class DownloadUtilsImpl {
    private static final int TIMEOUT = 5000;
    private static final int MAX_REDIRECTS = 3;

    private DownloadUtilsImpl() {
    }

    private static URLConnection openConnection(URL url) throws IOException {
        URLConnection con = url.openConnection();
        con.setConnectTimeout(5000);
        con.setReadTimeout(5000);
        if (con instanceof HttpURLConnection) {
            HttpURLConnection hcon = (HttpURLConnection)con;
            hcon.setRequestProperty("User-Agent", "MinecraftForge-Utils");
            hcon.setRequestProperty("Accept", "application/json");
            hcon.setInstanceFollowRedirects(false);
        }
        return con;
    }

    static InputStream connect(String address) throws IOException {
        URL url;
        URLConnection con;
        URI uri;
        try {
            uri = new URI(address);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        ArrayList<String> redirections = new ArrayList<String>();
        int redirects = 0;
        while ((con = DownloadUtilsImpl.openConnection(url = uri.toURL())) instanceof HttpURLConnection) {
            String location;
            HttpURLConnection hcon = (HttpURLConnection)con;
            int res = hcon.getResponseCode();
            if (res == 301 || res == 302) {
                location = hcon.getHeaderField("Location");
                redirections.add(location);
                hcon.disconnect();
                if (redirects == 2) {
                    throw new IOException(String.format("Too many redirects: %s -- redirections: [%s]", address, String.join((CharSequence)", ", redirections)));
                }
            } else {
                if (res != 404) break;
                throw new FileNotFoundException("Returned 404: " + address);
            }
            uri = uri.resolve(location);
            ++redirects;
        }
        URLConnection connection = con;
        return connection.getInputStream();
    }

    static byte[] readInputStream(InputStream stream) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            int n;
            byte[] buf = new byte[1024];
            while ((n = stream.read(buf)) > 0) {
                out.write(buf, 0, n);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }
}

