/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.internal;

import groovy.lang.Closure;
import java.io.File;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import net.minecraftforge.accesstransformers.gradle.ArtifactAccessTransformer;
import net.minecraftforge.gradle.MinecraftExtension;
import net.minecraftforge.gradle.MinecraftExtensionForProjectWithAccessTransformers;
import net.minecraftforge.gradle.MinecraftMappings;
import net.minecraftforge.gradle.internal.ForgeGradleFlowAction;
import net.minecraftforge.gradle.internal.ForgeGradleProblems;
import net.minecraftforge.gradle.internal.MinecraftDependencyInternal;
import net.minecraftforge.gradle.internal.MinecraftExtensionImpl;
import net.minecraftforge.gradle.internal.MinecraftExtensionInternal;
import net.minecraftforge.gradle.internal.MinecraftMappingsImpl;
import net.minecraftforge.gradle.internal.OperatingSystemName;
import net.minecraftforge.gradle.internal.SyncMavenizer;
import net.minecraftforge.gradle.internal.Util;
import net.minecraftforge.gradle.shadow.net.minecraftforge.gradleutils.shared.Closures;
import net.minecraftforge.gradle.shadow.net.minecraftforge.util.os.OS;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Category;
import org.gradle.api.file.Directory;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.flow.FlowProviders;
import org.gradle.api.flow.FlowScope;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.jspecify.annotations.Nullable;

abstract class MinecraftDependencyImpl
implements MinecraftDependencyInternal {
    private transient @Nullable ExternalModuleDependency delegate;
    private transient @Nullable TaskProvider<SyncMavenizer> mavenizer;
    final Property<String> asString = this.getObjects().property(String.class);
    final Property<String> asPath = this.getObjects().property(String.class);
    final Property<ModuleIdentifier> module = this.getObjects().property(ModuleIdentifier.class);
    final Property<String> version = this.getObjects().property(String.class);
    private final Provider<? extends Directory> mavenizerOutput;
    private final Property<MinecraftMappingsImpl> mappings;
    private @Nullable String sourceSetName;
    private final ForgeGradleProblems problems = (ForgeGradleProblems)this.getObjects().newInstance(ForgeGradleProblems.class, new Object[0]);

    @Inject
    protected abstract Project getProject();

    @Inject
    protected abstract FlowScope getFlowScope();

    @Inject
    protected abstract FlowProviders getFlowProviders();

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract ProjectLayout getProjectLayout();

    @Inject
    protected abstract ProviderFactory getProviders();

    @Inject
    public MinecraftDependencyImpl(Provider<? extends Directory> mavenizerOutput) {
        this.mavenizerOutput = mavenizerOutput;
        this.mappings = this.getObjects().property(MinecraftMappingsImpl.class).convention(((MinecraftExtensionImpl)this.getProject().getExtensions().getByType(MinecraftExtension.class)).mappings);
    }

    @Override
    public @Nullable ExternalModuleDependency asDependency() {
        return this.delegate;
    }

    @Override
    public @Nullable TaskProvider<SyncMavenizer> asTask() {
        return this.mavenizer;
    }

    @Override
    public ExternalModuleDependency init(Object dependencyNotation, Closure<?> closure) {
        ExternalModuleDependency dependency = (ExternalModuleDependency)this.getProject().getDependencies().create(dependencyNotation, Closures.function(d -> {
            if (!(d instanceof ExternalModuleDependency)) {
                throw this.problems.invalidMinecraftDependencyType((Dependency)d);
            }
            ExternalModuleDependency module = (ExternalModuleDependency)d;
            if (module.isChanging()) {
                throw this.problems.changingMinecraftDependency((Dependency)module);
            }
            Closures.invoke(this.closure(closure), module);
            ((ExtensionAware)module).getExtensions().getExtraProperties().set("__fg_minecraft_dependency", (Object)this);
            return module;
        }));
        this.mavenizer = SyncMavenizer.register(this.getProject(), dependency, this.mappings, this.mavenizerOutput);
        this.asString.set((Object)dependency.toString());
        this.asPath.set((Object)Util.pathify((Dependency)dependency));
        this.module.set((Object)dependency.getModule());
        this.version.set((Object)dependency.getVersion());
        this.delegate = dependency;
        return this.delegate;
    }

    @Override
    public Action<? super AttributeContainer> addAttributes() {
        return attributes -> {
            attributes.attributeProvider(MinecraftExtensionInternal.AttributesInternal.OS, this.getProviders().of(OperatingSystemName.class, spec -> spec.parameters(parameters -> parameters.getAllowedOperatingSystems().set(Set.of(OS.WINDOWS, OS.MACOS, OS.LINUX)))));
            attributes.attributeProvider(MinecraftExtensionInternal.AttributesInternal.MAPPINGS_CHANNEL, this.mappings.map(MinecraftMappings::getChannel));
            attributes.attributeProvider(MinecraftExtensionInternal.AttributesInternal.MAPPINGS_VERSION, this.mappings.map(MinecraftMappings::getVersion));
        };
    }

    @Override
    public void handle(Configuration configuration) {
        if (!configuration.isCanBeResolved()) {
            return;
        }
        this.mappings.finalizeValue();
        configuration.getResolutionStrategy().dependencySubstitution(s -> {
            String moduleSelector = "%s:%s".formatted(this.module.get(), this.version.get());
            ComponentSelector module = s.module(moduleSelector);
            try {
                s.substitute(module).using(s.variant(module, variant -> variant.attributes(this.addAttributes()))).because("Accounts for mappings used and natives variants");
            }
            catch (InvalidUserCodeException e) {
                throw new IllegalStateException("Resolvable configuration '%s' was resolved too early!".formatted(configuration.getName()), e);
            }
        });
        ExternalModuleDependency asDependency = this.asDependency();
        if (asDependency == null) {
            return;
        }
        Set hierarchy = configuration.getHierarchy();
        SourceSet sourceSet = Util.getSourceSet((NamedDomainObjectSet<Configuration>)this.getProject().getConfigurations().matching(hierarchy::contains), ((JavaPluginExtension)this.getProject().getExtensions().getByType(JavaPluginExtension.class)).getSourceSets(), (Dependency)asDependency);
        if (sourceSet != null) {
            this.handle(sourceSet);
        }
    }

    @Override
    public void handle(SourceSet sourceSet) {
        String asString = (String)this.asString.get();
        File dependencyOutput = ((Directory)((Provider)this.mavenizerOutput.map(dir -> dir.dir(this.asPath)).get()).get()).getAsFile();
        this.getFlowScope().always(ForgeGradleFlowAction.MavenizerSyncCheck.class, spec -> spec.parameters(parameters -> {
            parameters.getFailure().set(this.getFlowProviders().getBuildWorkResult().map(r -> r.getFailure().orElse(null)));
            parameters.dependencyOutput.set(dependencyOutput);
            parameters.dependency.set((Object)asString);
        }));
        if (this.sourceSetName != null) {
            if (!this.sourceSetName.equals(sourceSet.getName())) {
                throw new IllegalStateException("MinecraftDependency '%s' has already been handled!".formatted(this.asDependency()));
            }
            return;
        }
        this.sourceSetName = sourceSet.getName();
    }

    @Override
    public MinecraftMappings getMappings() {
        try {
            return (MinecraftMappings)this.mappings.get();
        }
        catch (IllegalStateException e) {
            throw this.problems.missingMappings(e);
        }
    }

    @Override
    public void mappings(String channel, String version) {
        this.mappings.set((Object)((MinecraftMappingsImpl)this.getObjects().newInstance(MinecraftMappingsImpl.class, new Object[]{channel, version})));
    }

    static abstract class WithAccessTransformersImpl
    extends MinecraftDependencyImpl
    implements MinecraftDependencyInternal.WithAccessTransformers {
        private final RegularFileProperty atFile = this.getObjects().fileProperty();
        private final Property<String> atPath = this.getObjects().property(String.class).convention(((MinecraftExtensionForProjectWithAccessTransformers)this.getProject().getExtensions().getByType(MinecraftExtensionForProjectWithAccessTransformers.class)).getAccessTransformers());
        private final Attribute<Boolean> attribute = this.registerTransform();

        @Inject
        public WithAccessTransformersImpl(Provider<? extends Directory> mavenizerOutput) {
            super(mavenizerOutput);
        }

        @Override
        public Action<? super AttributeContainer> addAttributes() {
            return attributes -> {
                super.addAttributes().execute(attributes);
                attributes.attribute(this.attribute, (Object)true);
            };
        }

        @Override
        public void handle(SourceSet sourceSet) {
            super.handle(sourceSet);
            ExternalModuleDependency asDependency = this.asDependency();
            if (asDependency == null) {
                return;
            }
            if (!Util.contains((NamedDomainObjectSet<Configuration>)this.getProject().getConfigurations(), sourceSet, false, (Dependency)asDependency)) {
                return;
            }
            if (!this.atPath.isPresent()) {
                return;
            }
            Iterator itor = sourceSet.getResources().getSrcDirs().iterator();
            if (itor.hasNext()) {
                this.atFile.convention((RegularFile)this.getProjectLayout().file(this.getProviders().provider(() -> new File((File)itor.next(), (String)this.atPath.get()))).get());
            } else {
                this.atFile.convention((RegularFile)this.getProjectLayout().getProjectDirectory().file(this.getProviders().provider(() -> "src/%s/resources/%s".formatted(sourceSet.getName(), this.atPath.get()))).get());
            }
            ArtifactAccessTransformer.validateConfig((Project)this.getProject(), (Object)asDependency, (RegularFileProperty)this.atFile);
        }

        private Attribute<Boolean> registerTransform() {
            DependencyHandler dependencies = this.getProject().getDependencies();
            Attribute attribute = Attribute.of((String)("net.minecraftforge.gradle.accesstransformers.automatic." + this.getIndex()), Boolean.class);
            dependencies.attributesSchema(attributesSchema -> attributesSchema.attribute(attribute));
            dependencies.getArtifactTypes().named("jar", type -> type.getAttributes().attribute(attribute, (Object)false));
            dependencies.registerTransform(ArtifactAccessTransformer.class, spec -> {
                spec.parameters(ArtifactAccessTransformer.Parameters.defaults((Project)this.getProject(), parameters -> parameters.getConfig().set((Provider)this.atFile)));
                spec.getFrom().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"jar").attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)spec.getFrom().named(Category.class, "library"))).attribute(attribute, (Object)false);
                spec.getTo().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"jar").attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)spec.getTo().named(Category.class, "library"))).attribute(attribute, (Object)true);
            });
            return attribute;
        }

        private int getIndex() {
            ExtraPropertiesExtension ext = this.getProject().getGradle().getExtensions().getExtraProperties();
            int index = ext.has("__fg_minecraft_atcontainers") ? (Integer)Objects.requireNonNull(ext.get("__fg_minecraft_atcontainers"), "Internal extra property can never be null!") + 1 : 0;
            ext.set("__fg_minecraft_atcontainers", (Object)index);
            return index;
        }

        @Override
        public RegularFileProperty getAccessTransformer() {
            return this.atFile;
        }

        @Override
        public void setAccessTransformer(String accessTransformer) {
            this.atPath.set((Object)accessTransformer);
        }

        @Override
        public void setAccessTransformer(boolean accessTransformer) {
            if (accessTransformer) {
                this.setAccessTransformer("META-INF/accesstransformer.cfg");
            } else {
                this.atPath.unsetConvention().unset();
            }
        }
    }
}

