/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.shadow.net.minecraftforge.util.download;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import net.minecraftforge.gradle.shadow.net.minecraftforge.util.download.DownloadUtilsImpl;
import org.jetbrains.annotations.Nullable;

public final class DownloadUtils {
    private DownloadUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] downloadBytes(String url) throws IOException {
        try (InputStream stream = DownloadUtilsImpl.connect(url);){
            byte[] byArray = DownloadUtilsImpl.readInputStream(stream);
            return byArray;
        }
        catch (Exception e) {
            throw new DownloadFailedException(url, e);
        }
    }

    public static byte @Nullable [] tryDownloadBytes(String url) {
        try {
            return DownloadUtils.downloadBytes(url);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String downloadString(String url) throws IOException {
        return new String(DownloadUtils.downloadBytes(url), StandardCharsets.UTF_8);
    }

    @Nullable
    public static String tryDownloadString(String url) {
        try {
            return DownloadUtils.downloadString(url);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static void downloadFile(File target, String url) throws IOException {
        try (InputStream stream = DownloadUtilsImpl.connect(url);){
            Path path = target.toPath();
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.copy(stream, path, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            throw new IOException(url, e);
        }
    }

    public static boolean tryDownloadFile(File target, String url) {
        try {
            DownloadUtils.downloadFile(target, url);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static final class DownloadFailedException
    extends IOException {
        public DownloadFailedException(String url, Throwable cause) {
            super("Failed to download " + url, cause);
        }
    }
}

