/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.internal;

import groovy.lang.GroovyObjectSupport;
import net.minecraftforge.gradle.MinecraftDependency;
import net.minecraftforge.gradle.MinecraftDependencyWithAccessTransformers;
import net.minecraftforge.gradle.internal.ClosureOwnerInternal;
import org.codehaus.groovy.runtime.InvokerHelper;

abstract class ClosureOwnerImpl<D>
extends GroovyObjectSupport
implements ClosureOwnerInternal<D> {
    final Object originalOwner;
    final D ownerDelegate;

    ClosureOwnerImpl(Object originalOwner, D ownerDelegate) {
        this.originalOwner = originalOwner;
        this.ownerDelegate = ownerDelegate;
    }

    @Override
    public D getOwnerDelegate() {
        return this.ownerDelegate;
    }

    public Object invokeMethod(String name, Object args) {
        try {
            return super.invokeMethod(name, args);
        }
        catch (Exception e) {
            try {
                return InvokerHelper.invokeMethod((Object)this.originalOwner, (String)name, (Object)args);
            }
            catch (Exception suppressed) {
                e.addSuppressed(suppressed);
                throw e;
            }
        }
    }

    public Object getProperty(String propertyName) {
        try {
            return super.getProperty(propertyName);
        }
        catch (Exception e) {
            try {
                return InvokerHelper.getProperty((Object)this.originalOwner, (String)propertyName);
            }
            catch (Exception suppressed) {
                e.addSuppressed(suppressed);
                throw e;
            }
        }
    }

    public void setProperty(String propertyName, Object newValue) {
        try {
            super.setProperty(propertyName, newValue);
        }
        catch (Exception e) {
            try {
                InvokerHelper.setProperty((Object)this.originalOwner, (String)propertyName, (Object)newValue);
            }
            catch (Exception suppressed) {
                e.addSuppressed(suppressed);
                throw e;
            }
        }
    }

    static class MinecraftDependencyWithAccessTransformersImpl
    extends ClosureOwnerImpl<MinecraftDependencyWithAccessTransformers>
    implements ClosureOwnerInternal.MinecraftDependencyWithAccessTransformers {
        MinecraftDependencyWithAccessTransformersImpl(Object originalOwner, MinecraftDependencyWithAccessTransformers ownerDelegate) {
            super(originalOwner, ownerDelegate);
        }
    }

    static class MinecraftDependencyImpl
    extends ClosureOwnerImpl<MinecraftDependency>
    implements ClosureOwnerInternal.MinecraftDependency {
        MinecraftDependencyImpl(Object originalOwner, MinecraftDependency ownerDelegate) {
            super(originalOwner, ownerDelegate);
        }
    }
}

