/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import javax.inject.Inject;
import net.minecraftforge.gradle.internal.ForgeGradleTask;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

abstract class SlimeLauncherMetadata
extends DefaultTask
implements ForgeGradleTask {
    @InputFiles
    protected abstract ConfigurableFileCollection getMetadata();

    @OutputFile
    protected abstract RegularFileProperty getRunsJson();

    @Inject
    protected abstract ArchiveOperations getArchiveOperations();

    @Inject
    public SlimeLauncherMetadata() {
        this.getRunsJson().convention(this.getDefaultOutputDirectory().map(d -> d.file("runs.json")));
    }

    @TaskAction
    protected void exec() {
        this.getArchiveOperations().zipTree((Object)this.getMetadata().getSingleFile()).matching(it -> it.include(new String[]{"launcher/**"})).visit(file -> {
            try {
                if (file.getPath().equals("launcher/runs.json")) {
                    Files.copy(file.getFile().toPath(), ((File)this.getRunsJson().getAsFile().get()).toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

