/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.internal;

import java.util.ArrayList;
import java.util.Arrays;
import net.minecraftforge.gradle.internal.ForgeGradleProblems;
import net.minecraftforge.gradle.shadow.net.minecraftforge.gradleutils.shared.SharedUtil;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

final class Util
extends SharedUtil {
    Util() {
    }

    static String checkMappingsParam(ForgeGradleProblems problems, @UnknownNullability Object param, String name) {
        if (param == null) {
            throw problems.nullMappingsParam(name);
        }
        return param.toString();
    }

    static boolean isPresent(String c) {
        return !c.isBlank();
    }

    static String dependencyToCamelCase(Dependency dependency) {
        return Util.dependencyToCamelCase(dependency.getGroup(), dependency.getName());
    }

    static String dependencyToCamelCase(ModuleIdentifier dependency) {
        return Util.dependencyToCamelCase(dependency.getGroup(), dependency.getName());
    }

    static String dependencyToCamelCase(@Nullable String group, String name) {
        ArrayList<String> list = new ArrayList<String>(3);
        if (group != null) {
            list.addAll(Arrays.asList(group.split("\\.")));
        }
        list.add(name);
        StringBuilder builder = new StringBuilder(64);
        for (String s : list) {
            builder.append(StringGroovyMethods.capitalize((CharSequence)s));
        }
        return builder.toString();
    }

    @Nullable
    static SourceSet getSourceSet(NamedDomainObjectSet<Configuration> configurations, SourceSetContainer sourceSets, Dependency dependency) {
        for (SourceSet sourceSet : sourceSets) {
            if (!Util.contains(configurations, sourceSet, false, dependency)) continue;
            return sourceSet;
        }
        return null;
    }
}

