/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Set;
import javax.inject.Inject;
import net.minecraftforge.gradle.internal.ForgeGradleMessage;
import net.minecraftforge.gradle.internal.ForgeGradlePlugin;
import net.minecraftforge.gradle.internal.ForgeGradleProblems;
import net.minecraftforge.gradle.shadow.net.minecraftforge.gradleutils.shared.EnhancedFlowAction;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;

abstract class ForgeGradleFlowAction<P extends Parameters>
extends EnhancedFlowAction<P> {
    ForgeGradleFlowAction() {
    }

    static abstract class AccessTransformersMissing
    extends ForgeGradleFlowAction<Parameters> {
        @Inject
        public AccessTransformersMissing() {
        }

        @Override
        protected void run(Parameters parameters) {
            if (!parameters.getFailure().isPresent() || ((Boolean)parameters.appliedPlugin.getOrElse((Object)false)).booleanValue()) {
                return;
            }
            Throwable e = (Throwable)parameters.getFailure().get();
            if (!AccessTransformersMissing.contains(e, "accesstransformer")) {
                return;
            }
            ((ForgeGradleProblems)parameters.problems()).reportAccessTransformersNotApplied(e);
        }

        static abstract class Parameters
        extends net.minecraftforge.gradle.internal.ForgeGradleFlowAction$Parameters {
            final Property<Boolean> appliedPlugin = this.getObjects().property(Boolean.class).convention((Object)false);

            @Inject
            public Parameters() {
            }
        }
    }

    static abstract class MessageBoard
    extends ForgeGradleFlowAction<Parameters> {
        @Inject
        public MessageBoard() {
        }

        @Override
        protected void run(Parameters parameters) {
            int count;
            if (parameters.getFailure().isPresent()) {
                return;
            }
            Set pending = (Set)parameters.messages.get();
            ArrayList<ForgeGradleMessage.QueuedMessage> messages = new ArrayList<ForgeGradleMessage.QueuedMessage>(pending.size());
            File markerFile = null;
            for (ForgeGradleMessage.QueuedMessage queued : pending) {
                switch (queued.displayOption()) {
                    case NEVER: {
                        break;
                    }
                    case ONCE: {
                        markerFile = ((RegularFile)queued.markerFile().get()).getAsFile();
                        if (markerFile.exists()) break;
                        try {
                            Files.createDirectories(markerFile.toPath().getParent(), new FileAttribute[0]);
                            Files.createFile(markerFile.toPath(), new FileAttribute[0]);
                        }
                        catch (IOException e) {
                            ((ForgeGradleProblems)parameters.problems()).reportMessageBoardCacheBroken(e, markerFile, queued.message().getProperty());
                        }
                    }
                    case ALWAYS: {
                        messages.add(queued);
                    }
                }
            }
            if (messages.isEmpty()) {
                return;
            }
            if (!ForgeGradlePlugin.LOGGER.isLifecycleEnabled()) {
                ForgeGradlePlugin.LOGGER.warn("WARNING: ForgeGradle messages cannot be displayed as the logger is not configured to display lifecycle messages.");
            }
            ForgeGradlePlugin.LOGGER.lifecycle("You have " + count + " new message" + ((count = messages.size()) == 1 ? "" : "s") + " from ForgeGradle.\n");
            for (int i = 0; i < count; ++i) {
                ForgeGradleMessage.QueuedMessage queued = (ForgeGradleMessage.QueuedMessage)messages.get(i);
                ForgeGradlePlugin.LOGGER.lifecycle("---   Message %d/%d   ---".formatted(i + 1, count));
                ForgeGradlePlugin.LOGGER.lifecycle(MessageFormat.format(queued.message().getText(), queued));
                if (markerFile != null && queued.displayOption() == ForgeGradleMessage.DisplayOption.ONCE) {
                    ForgeGradlePlugin.LOGGER.lifecycle("\n" + queued.message().getCondition(), new Object[]{markerFile.getAbsolutePath()});
                }
                ForgeGradlePlugin.LOGGER.lifecycle("--- End of Message ---");
                if (i == count - 1) continue;
                ForgeGradlePlugin.LOGGER.lifecycle("");
            }
        }

        static abstract class Parameters
        extends net.minecraftforge.gradle.internal.ForgeGradleFlowAction$Parameters {
            final SetProperty<ForgeGradleMessage.QueuedMessage> messages = this.getObjects().setProperty(ForgeGradleMessage.QueuedMessage.class);

            @Inject
            public Parameters() {
            }

            void queue(Project project, DirectoryProperty globalCaches, ForgeGradleMessage message) {
                this.messages.add((Object)message.queue(project, globalCaches));
            }
        }
    }

    static abstract class Parameters
    extends EnhancedFlowAction.EnhancedFlowParameters<ForgeGradleProblems> {
        protected Parameters() {
            super(ForgeGradleProblems.class);
        }
    }
}

