/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.minecraftforge.gradle.SlimeLauncherOptions;
import net.minecraftforge.gradle.internal.ForgeGradleProblems;
import net.minecraftforge.gradle.internal.ForgeGradleTask;
import net.minecraftforge.gradle.internal.SlimeLauncherMetadata;
import net.minecraftforge.gradle.internal.SlimeLauncherOptionsImpl;
import net.minecraftforge.gradle.internal.SlimeLauncherOptionsInternal;
import net.minecraftforge.gradle.internal.Tools;
import net.minecraftforge.gradle.internal.Util;
import net.minecraftforge.gradle.shadow.com.google.gson.JsonIOException;
import net.minecraftforge.gradle.shadow.com.google.gson.reflect.TypeToken;
import net.minecraftforge.gradle.shadow.net.minecraftforge.gradleutils.shared.Tool;
import net.minecraftforge.gradle.shadow.net.minecraftforge.util.data.json.JsonData;
import net.minecraftforge.gradle.shadow.net.minecraftforge.util.data.json.RunConfig;
import org.gradle.api.Project;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.reflect.HasPublicType;
import org.gradle.api.reflect.TypeOf;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;

abstract class SlimeLauncherExec
extends JavaExec
implements ForgeGradleTask,
HasPublicType {
    private final ForgeGradleProblems problems = (ForgeGradleProblems)this.getObjectFactory().newInstance(ForgeGradleProblems.class, new Object[0]);

    static void register(Project project, SourceSet sourceSet, SlimeLauncherOptionsImpl options, ModuleIdentifier module, String version, String asPath, String asString, boolean single) {
        TaskProvider t;
        String taskName = "slimeLauncherMetadata" + (String)(single ? "" : "for" + Util.dependencyToCamelCase(module));
        try {
            t = project.getTasks().named(taskName, SlimeLauncherMetadata.class);
        }
        catch (UnknownDomainObjectException e) {
            ExternalModuleDependency metadataDep = project.getDependencyFactory().create(module.getGroup(), module.getName(), version, "metadata", "zip");
            Usage metadataAttr = (Usage)project.getObjects().named(Usage.class, "metadata");
            RegularFileProperty metadataZip = project.getObjects().fileProperty().fileProvider(project.getProviders().provider(() -> {
                Configuration configuration = project.getConfigurations().detachedConfiguration(new Dependency[]{metadataDep});
                configuration.setTransitive(false);
                configuration.attributes(a -> a.attribute(Usage.USAGE_ATTRIBUTE, (Object)metadataAttr));
                return configuration.getSingleFile();
            }));
            t = project.getTasks().register(taskName, SlimeLauncherMetadata.class, task -> {
                task.setDescription("Extracts the Slime Launcher metadata%s.".formatted(single ? "" : " for '%s'".formatted(asString)));
                task.getMetadataZip().set((Provider)metadataZip);
            });
        }
        TaskProvider metadata = t;
        String taskName2 = sourceSet.getTaskName("run", options.getName()) + (String)(single ? "" : "for" + Util.dependencyToCamelCase(module));
        project.getTasks().register(taskName2, SlimeLauncherExec.class, task -> {
            task.getRunName().set((Object)options.getName());
            task.setDescription("Runs the '%s' Slime Launcher run configuration.".formatted(options.getName()));
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = new Object[1];
            objectArray2[0] = task.getProviderFactory().provider(() -> ((SourceSet)sourceSet).getRuntimeClasspath());
            objectArray[0] = task.getObjectFactory().fileCollection().from(objectArray2);
            task.classpath(objectArray);
            task.getJavaLauncher().unset();
            DirectoryProperty caches = task.getObjectFactory().directoryProperty().value(task.globalCaches().dir("slime-launcher/cache/%s".formatted(asPath)));
            task.getCacheDir().set(caches.map(task.problems.ensureFileLocation()));
            task.getMetadataZip().set(metadata.flatMap(SlimeLauncherMetadata::getMetadataZip));
            task.getRunsJson().set(metadata.flatMap(SlimeLauncherMetadata::getRunsJson));
            task.getOptions().set((Object)options);
        });
    }

    @Input
    protected abstract Property<String> getRunName();

    @Nested
    protected abstract Property<SlimeLauncherOptions> getOptions();

    @Internal
    protected abstract DirectoryProperty getCacheDir();

    @InputFile
    protected abstract RegularFileProperty getMetadataZip();

    @InputFile
    protected abstract RegularFileProperty getRunsJson();

    @Input
    @Optional
    protected abstract Property<String> getDelegateMainClass();

    @Input
    @Optional
    protected abstract ListProperty<String> getDelegateArgs();

    @Input
    @Optional
    protected abstract Property<Boolean> getClient();

    @Inject
    public SlimeLauncherExec() {
        this.setGroup("Slime Launcher");
        Tool.Resolved tool = this.getTool(Tools.SLIMELAUNCHER);
        this.setClasspath(tool.getClasspath());
        if (tool.hasMainClass()) {
            this.getMainClass().set((Object)tool.getMainClass());
        }
        this.getJavaLauncher().set(tool.getJavaLauncher());
        this.getModularity().getInferModulePath().set((Object)false);
    }

    @Internal
    public TypeOf<?> getPublicType() {
        return TypeOf.typeOf(JavaExec.class);
    }

    public void exec() {
        Map<String, RunConfig> configs = Map.of();
        try {
            configs = JsonData.fromJson((File)this.getRunsJson().getAsFile().get(), new TypeToken<Map<String, RunConfig>>(){});
        }
        catch (JsonIOException jsonIOException) {
            // empty catch block
        }
        SlimeLauncherOptionsInternal options = ((SlimeLauncherOptionsInternal)this.getOptions().get()).inherit(configs);
        Provider mainClass = this.getDelegateMainClass().orElse(options.getMainClass().filter(Util::isPresent));
        ArrayList args = new ArrayList((Collection)options.getArgs().getOrElse(List.of()));
        args.addAll((Collection)this.getDelegateArgs().getOrElse(List.of()));
        this.jvmArgs((Iterable)options.getJvmArgs().get());
        if (!options.getClasspath().isEmpty()) {
            this.setClasspath((FileCollection)options.getClasspath());
        }
        if (options.getMinHeapSize().filter(Util::isPresent).isPresent()) {
            this.setMinHeapSize((String)options.getMinHeapSize().get());
        }
        if (options.getMaxHeapSize().filter(Util::isPresent).isPresent()) {
            this.setMinHeapSize((String)options.getMaxHeapSize().get());
        }
        this.systemProperties((Map)options.getSystemProperties().get());
        this.environment((Map)options.getEnvironment().get());
        this.workingDir(options.getWorkingDir().get());
        if (!((String)this.getMainClass().get()).startsWith("net.minecraftforge.launcher")) {
            this.getLogger().warn("WARNING: Main class is not Slime Launcher! Skipping additional configuration.");
        } else {
            this.args(new Object[]{"--main", mainClass.get(), "--cache", ((Directory)this.getCacheDir().get()).getAsFile().getAbsolutePath(), "--metadata", ((RegularFile)this.getMetadataZip().get()).getAsFile().getAbsolutePath(), "--"});
        }
        this.args(args);
        if (!((Boolean)this.getClient().getOrElse((Object)false)).booleanValue()) {
            this.setStandardInput(System.in);
        }
        try {
            Files.createDirectories(this.getWorkingDir().toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.getLogger().info("{} {}", (Object)this.getClasspath().getAsPath(), (Object)String.join((CharSequence)" ", this.getArgs()));
        try {
            super.exec();
        }
        catch (Exception e) {
            this.getLogger().error("Something went wrong! Here is some debug info.");
            this.getLogger().error("Args: {}", (Object)this.getArgs());
            this.getLogger().error("Options: {}", (Object)options);
            throw e;
        }
    }
}

