/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.internal;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.transform.stc.ClosureParams;
import groovy.transform.stc.FromString;
import groovy.transform.stc.SimpleType;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.minecraftforge.gradle.ClosureOwner;
import net.minecraftforge.gradle.MinecraftDependency;
import net.minecraftforge.gradle.MinecraftExtensionForProject;
import net.minecraftforge.gradle.MinecraftMappings;
import net.minecraftforge.gradle.SlimeLauncherOptions;
import net.minecraftforge.gradle.internal.ForgeGradleFlowAction;
import net.minecraftforge.gradle.internal.ForgeGradlePlugin;
import net.minecraftforge.gradle.internal.ForgeGradleProblems;
import net.minecraftforge.gradle.internal.MinecraftDependencyImpl;
import net.minecraftforge.gradle.internal.MinecraftDependencyInternal;
import net.minecraftforge.gradle.internal.MinecraftExtensionInternal;
import net.minecraftforge.gradle.internal.MinecraftMappingsImpl;
import net.minecraftforge.gradle.internal.SlimeLauncherExec;
import net.minecraftforge.gradle.internal.SlimeLauncherOptionsImpl;
import net.minecraftforge.gradle.internal.SyncMavenizer;
import net.minecraftforge.gradle.internal.Util;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectList;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ExternalModuleDependencyBundle;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.flow.FlowProviders;
import org.gradle.api.flow.FlowScope;
import org.gradle.api.initialization.Settings;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.reflect.TypeOf;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;

abstract class MinecraftExtensionImpl
implements MinecraftExtensionInternal {
    private static final String EXT_MAVEN_REPOS = "fg_mc_maven_repos";
    private static final String EXT_MAPPINGS = "fg_mc_mappings";
    final ForgeGradleProblems problems = (ForgeGradleProblems)this.getObjects().newInstance(ForgeGradleProblems.class, new Object[0]);
    final DirectoryProperty mavenizerOutput;
    final Property<MinecraftMappingsImpl> mappings;

    @Inject
    protected abstract ObjectFactory getObjects();

    static void register(ForgeGradlePlugin plugin, ExtensionAware target) {
        ExtensionContainer extensions = target.getExtensions();
        if (target instanceof Project) {
            Project project = (Project)target;
            if (project.getPluginManager().hasPlugin("net.minecraftforge.accesstransformers")) {
                try {
                    extensions.create("minecraft", ForProjectImpl.WithAccessTransformersImpl.class, new Object[]{plugin});
                }
                catch (Exception e) {
                    ForgeGradleProblems problems = (ForgeGradleProblems)project.getObjects().newInstance(ForgeGradleProblems.class, new Object[0]);
                    throw problems.accessTransformersNotOnClasspath(e);
                }
            } else {
                extensions.create("minecraft", ForProjectImpl.class, new Object[]{plugin});
            }
        } else if (target instanceof Settings) {
            extensions.create("minecraft", ForSettingsImpl.class, new Object[]{plugin, target});
        } else {
            extensions.create("minecraft", MinecraftExtensionImpl.class, new Object[]{plugin});
        }
    }

    @Inject
    public MinecraftExtensionImpl(ForgeGradlePlugin plugin) {
        this.mavenizerOutput = this.getObjects().directoryProperty().convention(plugin.localCaches().dir("mavenizer/output").map(this.problems.ensureFileLocation()));
        this.mappings = this.getObjects().property(MinecraftMappingsImpl.class);
    }

    @Override
    public TypeOf<?> getPublicType() {
        return MinecraftExtensionInternal.super.getPublicType();
    }

    @Override
    public Action<MavenArtifactRepository> getMavenizer() {
        return maven -> {
            maven.setName("MinecraftMavenizer");
            maven.setUrl((Object)this.mavenizerOutput.getAsFile());
        };
    }

    @Override
    public MinecraftMappings getMappings() {
        try {
            return (MinecraftMappings)this.mappings.get();
        }
        catch (IllegalStateException e) {
            throw this.problems.missingMappings(e);
        }
    }

    @Override
    public void mappings(String channel, String version) {
        MinecraftMappingsImpl replacement = (MinecraftMappingsImpl)this.getObjects().newInstance(MinecraftMappingsImpl.class, new Object[]{channel, version});
        if (this.mappings.isPresent()) {
            this.problems.reportOverriddenMappings((MinecraftMappings)this.mappings.get(), replacement);
        }
        this.mappings.set((Object)replacement);
    }

    static abstract class ForProjectImpl<T extends ClosureOwner<?> & MinecraftDependency>
    extends MinecraftExtensionImpl
    implements MinecraftExtensionInternal.ForProject<T> {
        private final NamedDomainObjectContainer<SlimeLauncherOptionsImpl> runs;
        final List<MinecraftDependencyInternal> minecraftDependencies = new ArrayList<MinecraftDependencyInternal>();

        @Inject
        protected abstract Project getProject();

        @Inject
        protected abstract FlowScope getFlowScope();

        @Inject
        protected abstract FlowProviders getFlowProviders();

        @Inject
        protected abstract ProjectLayout getProjectLayout();

        @Inject
        protected abstract ProviderFactory getProviders();

        @Inject
        public ForProjectImpl(ForgeGradlePlugin plugin) {
            super(plugin);
            Project project = this.getProject();
            this.runs = this.getObjects().domainObjectContainer(SlimeLauncherOptionsImpl.class);
            ExtraPropertiesExtension ext = project.getExtensions().getExtraProperties();
            if (ext.has(MinecraftExtensionImpl.EXT_MAPPINGS)) {
                this.mappings.set((Object)((MinecraftMappingsImpl)ext.get(MinecraftExtensionImpl.EXT_MAPPINGS)));
            }
            FlowScope flowScope = this.getFlowScope();
            flowScope.always(ForgeGradleFlowAction.WelcomeMessage.class, spec -> spec.parameters(parameters -> {
                parameters.getFailure().set(this.getFlowProviders().getBuildWorkResult().map(p -> p.getFailure().orElse(null)));
                parameters.messagesDir.set(plugin.globalCaches().dir("messages"));
                parameters.displayOption.set(this.getProviders().gradleProperty("net.minecraftforge.gradle.messages.welcome").orElse(this.getProviders().systemProperty("net.minecraftforge.gradle.messages.welcome")).map(it -> ForgeGradleFlowAction.WelcomeMessage.DisplayOption.valueOf(it.toUpperCase(Locale.ROOT))));
            }));
            flowScope.always(ForgeGradleFlowAction.MagicMessage.class, spec -> spec.parameters(parameters -> {
                parameters.getFailure().set(this.getFlowProviders().getBuildWorkResult().map(p -> p.getFailure().orElse(null)));
                parameters.messagesDir.set(plugin.globalCaches().dir("messages"));
                parameters.displayOption.set(this.getProviders().gradleProperty("net.minecraftforge.gradle.messages.magic").orElse(this.getProviders().systemProperty("net.minecraftforge.gradle.messages.magic")).map(it -> ForgeGradleFlowAction.MagicMessage.DisplayOption.valueOf(it.toUpperCase(Locale.ROOT))));
            }));
            flowScope.always(ForgeGradleFlowAction.AccessTransformersMissing.class, spec -> spec.parameters(parameters -> {
                parameters.getFailure().set(this.getFlowProviders().getBuildWorkResult().map(p -> p.getFailure().orElse(null)));
                parameters.appliedPlugin.set((Object)project.getPluginManager().hasPlugin("net.minecraftforge.accesstransformers"));
            }));
            project.getConfigurations().matching(Configuration::isCanBeResolved).configureEach(c -> c.withDependencies(d -> this.apply((Configuration)c)));
            project.afterEvaluate(this::finish);
        }

        @Override
        public TypeOf<?> getPublicType() {
            return new TypeOf<MinecraftExtensionForProject<ClosureOwner.MinecraftDependency>>(){};
        }

        @Override
        public List<? extends MavenArtifactRepository> getRepositories() {
            ExtraPropertiesExtension ext = this.getProject().getGradle().getExtensions().getExtraProperties();
            return ext.has(MinecraftExtensionImpl.EXT_MAVEN_REPOS) ? Objects.requireNonNull((List)ext.get(MinecraftExtensionImpl.EXT_MAVEN_REPOS)) : this.getProject().getRepositories().withType(MavenArtifactRepository.class);
        }

        private void apply(Configuration configuration) {
            Set hierarchy = configuration.getHierarchy();
            Set minecraftDependencies = hierarchy.stream().flatMap(c -> c.getDependencies().matching(MinecraftDependencyInternal::is).stream()).map(MinecraftDependencyInternal::get).collect(Collectors.toSet());
            for (MinecraftDependencyInternal minecraftDependency : minecraftDependencies) {
                assert (minecraftDependency != null);
                minecraftDependency.handle(configuration);
            }
        }

        private void finish(Project project) {
            this.checkRepos(this.getRepositories());
            DirectoryProperty sourceSetsDir = this.getObjects().directoryProperty().value(this.getProjectLayout().getBuildDirectory().dir("sourceSets"));
            ((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets().configureEach(sourceSet -> {
                if (this.problems.test("net.minecraftforge.gradle.merge-source-sets")) {
                    Provider unifiedDir = sourceSetsDir.dir(sourceSet.getName());
                    sourceSet.getOutput().setResourcesDir((Object)unifiedDir);
                    sourceSet.getJava().getDestinationDirectory().set(unifiedDir);
                }
            });
            if (!this.minecraftDependencies.isEmpty()) {
                TaskProvider syncMavenizer = project.getTasks().register("syncMavenizer", task -> task.setGroup("Build Setup"));
                for (MinecraftDependencyInternal minecraftDependency : this.minecraftDependencies) {
                    TaskProvider<SyncMavenizer> mavenizer = minecraftDependency.asTask();
                    if (mavenizer == null) continue;
                    syncMavenizer.configure(task -> task.dependsOn(new Object[]{mavenizer}));
                }
                project.getPluginManager().withPlugin("eclipse", eclipsePlugin -> {
                    EclipseModel eclipse = (EclipseModel)project.getExtensions().getByType(EclipseModel.class);
                    eclipse.synchronizationTasks(new Object[]{syncMavenizer});
                });
                List taskNames = project.getGradle().getStartParameter().getTaskNames();
                taskNames.add(0, ((Task)syncMavenizer.get()).getPath());
                project.getGradle().getStartParameter().setTaskNames((Iterable)taskNames);
            }
            if (!this.runs.isEmpty() && !this.minecraftDependencies.isEmpty()) {
                ConfigurationContainer configurations = project.getConfigurations();
                SourceSetContainer sourceSets = ((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets();
                sourceSets.configureEach(sourceSet -> {
                    Set minecraftDependencies = configurations.getByName(sourceSet.getRuntimeClasspathConfigurationName()).getAllDependencies().matching(MinecraftDependencyInternal::is).stream().map(MinecraftDependencyInternal::get).collect(Collectors.toSet());
                    boolean single = minecraftDependencies.size() == 1;
                    for (MinecraftDependencyInternal minecraftDependency : minecraftDependencies) {
                        assert (minecraftDependency != null);
                        MinecraftDependencyImpl impl = (MinecraftDependencyImpl)minecraftDependency;
                        this.runs.forEach(options -> SlimeLauncherExec.register(project, sourceSet, options, (ModuleIdentifier)impl.module.get(), (String)impl.version.get(), (String)impl.asPath.get(), (String)impl.asString.get(), single));
                    }
                });
            }
        }

        @Override
        public NamedDomainObjectContainer<? extends SlimeLauncherOptions> getRuns() {
            return this.runs;
        }

        @Override
        public void runs(@DelegatesTo(value=NamedDomainObjectContainer.class) @ClosureParams(value=FromString.class, options={"org.gradle.api.NamedDomainObjectContainer<net.minecraftforge.gradle.SlimeLauncherOptions>"}) Closure<?> closure) {
            this.runs.configure(closure);
        }

        Class<? extends MinecraftDependencyInternal> getMinecraftDependencyClass() {
            return MinecraftDependencyImpl.class;
        }

        @Override
        public ExternalModuleDependency dependency(Object value, @DelegatesTo(value=ExternalModuleDependency.class) @ClosureParams(value=SimpleType.class, options={"net.minecraftforge.gradle.MinecraftDependency.ClosureOwner"}) Closure<?> closure) {
            if ((value = Util.unpack(value)) instanceof ExternalModuleDependencyBundle) {
                throw new IllegalArgumentException("Minecraft dependency cannot be a bundle");
            }
            MinecraftDependencyInternal minecraftDependency = (MinecraftDependencyInternal)this.getObjects().newInstance(this.getMinecraftDependencyClass(), new Object[]{this.mavenizerOutput});
            this.minecraftDependencies.add(minecraftDependency);
            return minecraftDependency.init(value, closure);
        }

        private void checkRepos(List<? extends MavenArtifactRepository> repos) {
            Predicate<String> contains = s -> {
                for (MavenArtifactRepository repo : repos) {
                    if (!repo.getUrl().toString().contains((CharSequence)s)) continue;
                    return true;
                }
                return false;
            };
            Predicate<Object> containsExactly = object -> {
                for (MavenArtifactRepository repo : repos) {
                    if (!repo.getUrl().equals(this.getProject().uri(object))) continue;
                    return true;
                }
                return false;
            };
            if (!containsExactly.test(this.mavenizerOutput.getAsFile())) {
                this.problems.reportMcMavenNotDeclared();
            }
            if (!contains.test("maven.minecraftforge.net")) {
                this.problems.reportForgeMavenNotDeclared();
            }
            if (!contains.test("libraries.minecraft.net")) {
                this.problems.reportMcLibsMavenNotDeclared();
            }
        }

        static abstract class WithAccessTransformersImpl
        extends ForProjectImpl<ClosureOwner.MinecraftDependencyWithAccessTransformers>
        implements MinecraftExtensionInternal.ForProject.WithAccessTransformers {
            private final Property<String> accessTransformers = this.getObjects().property(String.class);

            @Inject
            public WithAccessTransformersImpl(ForgeGradlePlugin plugin) {
                super(plugin);
            }

            @Override
            public TypeOf<?> getPublicType() {
                return MinecraftExtensionInternal.ForProject.WithAccessTransformers.super.getPublicType();
            }

            @Override
            public Property<String> getAccessTransformers() {
                return this.accessTransformers;
            }

            @Override
            final Class<? extends MinecraftDependencyImpl> getMinecraftDependencyClass() {
                return MinecraftDependencyImpl.WithAccessTransformersImpl.class;
            }
        }
    }

    static abstract class ForSettingsImpl
    extends MinecraftExtensionImpl {
        @Inject
        public ForSettingsImpl(ForgeGradlePlugin plugin, Settings settings) {
            super(plugin);
            settings.getGradle().settingsEvaluated(this::finish);
        }

        private void finish(Settings settings) {
            if (!this.mappings.isPresent()) {
                return;
            }
            NamedDomainObjectList repositories = settings.getDependencyResolutionManagement().getRepositories().withType(MavenArtifactRepository.class);
            ExtraPropertiesExtension ext = settings.getGradle().getExtensions().getExtraProperties();
            ext.set(MinecraftExtensionImpl.EXT_MAVEN_REPOS, (Object)repositories);
            ext.set(MinecraftExtensionImpl.EXT_MAPPINGS, this.mappings.get());
        }
    }
}

