/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle;

import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import net.minecraftforge.gradle.ForgeGradlePlugin;
import net.minecraftforge.util.download.DownloadUtils;
import net.minecraftforge.util.hash.HashStore;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.provider.ValueSource;
import org.gradle.api.provider.ValueSourceParameters;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.jetbrains.annotations.UnknownNullability;

enum DefaultTools {
    MINECRAFT_MAVEN("minecraft-maven-0.3.1.jar", "https://maven.minecraftforge.net/net/minecraftforge/minecraft-mavenizer/0.3.1/minecraft-mavenizer-0.3.1.jar"),
    SLIME_LAUNCHER("slime-launcher-0.1.0.jar", "https://maven.minecraftforge.net/net/minecraftforge/slime-launcher/0.1.0/slime-launcher-0.1.0.jar");

    private final String fileName;
    private final String downloadUrl;
    private static @UnknownNullability DirectoryProperty caches;

    private DefaultTools(String fileName, String downloadUrl) {
        this.fileName = fileName;
        this.downloadUrl = downloadUrl;
    }

    public Provider<File> get(DirectoryProperty cachesDir, ProviderFactory providers) {
        return providers.of(Source.class, spec -> spec.parameters(parameters -> {
            parameters.getInputFile().set(cachesDir.file("tools/" + this.fileName));
            parameters.getDownloadUrl().set((Object)this.downloadUrl);
        }));
    }

    static abstract class Source
    implements ValueSource<File, Parameters> {
        @Inject
        public Source() {
        }

        public File obtain() {
            Parameters parameters = (Parameters)this.getParameters();
            String downloadUrl = (String)parameters.getDownloadUrl().get();
            File outFile = ((RegularFile)parameters.getInputFile().get()).getAsFile();
            String name = outFile.getName();
            HashStore cache = HashStore.fromFile((File)outFile).add("tool", outFile).add("url", downloadUrl);
            if (outFile.exists() && cache.isSame()) {
                ForgeGradlePlugin.LOGGER.info("Default tool already downloaded: {}", (Object)name);
            } else {
                ForgeGradlePlugin.LOGGER.info("Downloading default tool: {}", (Object)name);
                try {
                    DownloadUtils.downloadFile((File)outFile, (String)downloadUrl);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to download default tool: " + name, e);
                }
                cache.add("tool", outFile).save();
            }
            return outFile;
        }

        static interface Parameters
        extends ValueSourceParameters {
            @InputFile
            @PathSensitive(value=PathSensitivity.ABSOLUTE)
            public RegularFileProperty getInputFile();

            @Input
            public Property<String> getDownloadUrl();
        }
    }
}

