/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle;

import groovy.lang.Closure;
import java.util.function.Supplier;
import net.minecraftforge.gradle.Closures;
import org.gradle.api.Action;
import org.jetbrains.annotations.Nullable;

final class ActionableLazy<T>
implements Supplier<T> {
    private final Closure<T> closure;
    @Nullable
    private T value;
    private boolean present = false;

    static <T> ActionableLazy<T> of(Closure<T> closure) {
        return new ActionableLazy<T>(closure);
    }

    private ActionableLazy(Closure<T> closure) {
        this.closure = closure.compose(Closures.runnable(() -> {
            this.present = true;
        }));
    }

    void map(Action<? super T> action) {
        this.present = true;
        this.closure.andThen(Closures.unaryOperator(value -> {
            action.execute(value);
            return value;
        }));
    }

    void ifPresent(Action<? super T> action) {
        if (!this.isPresent()) {
            return;
        }
        action.execute(this.get());
    }

    boolean isPresent() {
        return this.present;
    }

    @Override
    public T get() {
        return this.value == null ? (this.value = Closures.invoke(this.closure)) : this.value;
    }
}

