/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle;

import java.util.List;
import javax.inject.Inject;
import net.minecraftforge.gradle.MinecraftExtensionForProject;
import net.minecraftforge.gradle.MinecraftExtensionInternal;
import net.minecraftforge.gradle.MinecraftMappings;
import net.minecraftforge.gradle.ToolExec;
import net.minecraftforge.gradle.Tools;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.gradle.api.Project;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.process.ExecResult;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Mavenizer uses its own in-house caching.")
abstract class SyncMavenizer
extends ToolExec {
    static TaskProvider<SyncMavenizer> register(Project project, ExternalModuleDependency dependency, Provider<MinecraftMappings> mappings, Provider<? extends Directory> output) {
        String version = dependency.getVersion();
        String taskName = "syncMavenizerFor" + StringGroovyMethods.capitalize((CharSequence)dependency.getName()) + (version == null ? "" : version.replace(".", "").replace('-', '_'));
        TaskContainer tasks = project.getTasks();
        try {
            return tasks.named(taskName, SyncMavenizer.class);
        }
        catch (UnknownDomainObjectException e) {
            return project.getTasks().register(taskName, SyncMavenizer.class, task -> {
                task.getOutput().set(output);
                task.getModule().set((Object)dependency.getModule());
                task.getVersion().set((Object)dependency.getVersion());
                task.getMappings().set(mappings);
            });
        }
    }

    @Internal
    protected abstract DirectoryProperty getCaches();

    @Internal
    protected abstract DirectoryProperty getOutput();

    @Input
    protected abstract Property<ModuleIdentifier> getModule();

    @Input
    protected abstract Property<String> getVersion();

    @Input
    protected abstract Property<MinecraftMappings> getMappings();

    @Input
    @Optional
    protected abstract ListProperty<String> getRepositories();

    private void addRepositories(Iterable<? extends MavenArtifactRepository> repositories) {
        for (MavenArtifactRepository mavenArtifactRepository : repositories) {
            if (mavenArtifactRepository.getName().equals("MinecraftMavenizer")) continue;
            Object s = mavenArtifactRepository.getUrl().toString();
            if (!((String)s).endsWith("/")) {
                s = (String)s + "/";
            }
            String url = s;
            this.getRepositories().add(this.getProviders().provider(() -> repository.getName() + "," + url));
        }
    }

    @Inject
    public SyncMavenizer() {
        super(Tools.MAVENIZER);
        this.getCaches().convention(this.defaultToolDir.dir("caches"));
        MinecraftExtensionInternal.ForProject minecraft = (MinecraftExtensionInternal.ForProject)this.getProject().getExtensions().getByType(MinecraftExtensionForProject.class);
        this.addRepositories(minecraft.getRepositories());
    }

    @Override
    protected ExecResult exec() {
        return super.exec().rethrowFailure().assertNormalExitValue();
    }

    @Override
    protected void addArguments() {
        super.addArguments();
        this.args("--maven", "--cache", ((Directory)this.getCaches().getLocationOnly().get()).getAsFile().getAbsolutePath(), "--output", ((Directory)this.getOutput().getLocationOnly().get()).getAsFile().getAbsolutePath(), "--jdk-cache", ((Directory)this.getCaches().getLocationOnly().get()).dir("jdks").getAsFile().getAbsolutePath(), "--artifact", this.getModule().get(), "--version", this.getVersion().get(), "--global-auxiliary-variants");
        if ("parchment".equals(((MinecraftMappings)this.getMappings().get()).channel())) {
            this.args("--parchment", ((MinecraftMappings)this.getMappings().get()).version());
        }
        for (String repository : (List)this.getRepositories().getOrElse(List.of())) {
            this.args("--repository", repository);
        }
    }
}

