/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle;

import java.util.List;
import java.util.Map;
import net.minecraftforge.gradle.SlimeLauncherOptions;
import net.minecraftforge.gradle.shadow.net.minecraftforge.util.data.json.RunConfig;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.reflect.HasPublicType;
import org.gradle.api.reflect.TypeOf;

interface SlimeLauncherOptionsInternal
extends SlimeLauncherOptions,
HasPublicType {
    public static final Logger LOGGER = Logging.getLogger(SlimeLauncherOptions.class);

    default public TypeOf<?> getPublicType() {
        return TypeOf.typeOf(SlimeLauncherOptions.class);
    }

    public Property<Boolean> getClient();

    default public void inherit(Map<String, RunConfig> configs) {
        this.inherit(configs, this.getName());
    }

    default public void inherit(Map<String, RunConfig> configs, String name) {
        RunConfig config = configs.get(name);
        if (config == null) {
            return;
        }
        if (config.parents != null && !config.parents.isEmpty()) {
            config.parents.forEach(parent -> this.inherit(configs, (String)parent));
        }
        if (config.main != null) {
            this.getMainClass().convention((Object)config.main);
        }
        if (config.args != null && !config.args.isEmpty()) {
            this.getArgs().convention(List.copyOf(config.args));
        }
        if (config.jvmArgs != null && !config.jvmArgs.isEmpty()) {
            this.jvmArgs(config.jvmArgs);
        }
        this.getClient().set((Object)config.client);
        if (config.buildAllProjects) {
            LOGGER.warn("WARNING: ForgeGradle 7 does not support the buildAllProjects feature.");
        }
        if (config.env != null && !config.env.isEmpty()) {
            this.environment(config.env);
        }
        if (config.props != null && !config.props.isEmpty()) {
            this.systemProperties(config.props);
        }
    }
}

