/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle;

import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import net.minecraftforge.gradle.ForgeGradleTask;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.impldep.com.google.common.io.Files;

abstract class SlimeLauncherMetadata
extends DefaultTask
implements ForgeGradleTask {
    @InputFile
    protected abstract RegularFileProperty getMetadataZip();

    @OutputFile
    protected abstract RegularFileProperty getRunsJson();

    @Inject
    protected abstract ArchiveOperations getArchiveOperations();

    @Inject
    public SlimeLauncherMetadata() {
        this.getRunsJson().convention(this.getDefaultOutputDirectory().map(d -> d.file("runs.json")));
    }

    @TaskAction
    protected void exec() {
        this.getArchiveOperations().zipTree((Object)this.getMetadataZip()).matching(it -> it.include(new String[]{"launcher/**"})).visit(file -> {
            try {
                if (file.getPath().equals("launcher/runs.json")) {
                    Files.copy((File)file.getFile(), (File)((File)this.getRunsJson().getAsFile().get()));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

