/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.minecraftforge.gradle.ForgeGradleProblems;
import net.minecraftforge.gradle.ForgeGradleTask;
import net.minecraftforge.gradle.SlimeLauncherMetadata;
import net.minecraftforge.gradle.SlimeLauncherOptions;
import net.minecraftforge.gradle.SlimeLauncherOptionsImpl;
import net.minecraftforge.gradle.Tools;
import net.minecraftforge.gradle.Util;
import net.minecraftforge.gradle.shadow.com.google.gson.JsonIOException;
import net.minecraftforge.gradle.shadow.com.google.gson.reflect.TypeToken;
import net.minecraftforge.gradle.shadow.net.minecraftforge.gradleutils.shared.Tool;
import net.minecraftforge.gradle.shadow.net.minecraftforge.util.data.json.JsonData;
import net.minecraftforge.gradle.shadow.net.minecraftforge.util.data.json.RunConfig;
import org.gradle.api.Project;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.reflect.HasPublicType;
import org.gradle.api.reflect.TypeOf;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;

abstract class SlimeLauncherExec
extends JavaExec
implements ForgeGradleTask,
HasPublicType {
    private final ForgeGradleProblems problems = (ForgeGradleProblems)this.getObjectFactory().newInstance(ForgeGradleProblems.class, new Object[0]);

    static void register(Project project, SourceSet sourceSet, SlimeLauncherOptionsImpl options, Dependency dependency, boolean single) {
        TaskProvider t;
        String taskName = "slimeLauncherMetadata" + (String)(single ? "" : "for" + Util.dependencyToCamelCase(dependency));
        try {
            t = project.getTasks().named(taskName, SlimeLauncherMetadata.class);
        }
        catch (UnknownDomainObjectException e) {
            RegularFileProperty metadataZip = project.getObjects().fileProperty().fileProvider(project.getProviders().provider(() -> project.getConfigurations().detachedConfiguration(new Dependency[]{project.getDependencyFactory().create(dependency.getGroup(), dependency.getName(), dependency.getVersion(), "metadata", "zip")}).getSingleFile()));
            t = project.getTasks().register(taskName, SlimeLauncherMetadata.class, task -> {
                task.setDescription("Extracts the Slime Launcher metadata%s.".formatted(single ? "" : " for '%s'".formatted(Util.toString(dependency))));
                task.getMetadataZip().set((Provider)metadataZip);
            });
        }
        TaskProvider metadata = t;
        String taskName2 = sourceSet.getTaskName("run", options.getName()) + (String)(single ? "" : "for" + Util.dependencyToCamelCase(dependency));
        project.getTasks().register(taskName2, SlimeLauncherExec.class, task -> {
            task.getRunName().set((Object)options.getName());
            task.setDescription("Runs the '%s' Slime Launcher run configuration.".formatted(options.getName()));
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = new Object[1];
            objectArray2[0] = task.getProviderFactory().provider(() -> ((SourceSet)sourceSet).getRuntimeClasspath());
            objectArray[0] = task.getObjectFactory().fileCollection().from(objectArray2);
            task.classpath(objectArray);
            task.getJavaLauncher().unset();
            DirectoryProperty caches = task.getObjectFactory().directoryProperty().value(task.globalCaches().dir("slime-launcher/cache/%s".formatted(Util.pathify(dependency))));
            task.getCacheDir().set(caches.map(task.problems.ensureFileLocation()));
            task.getRunsJson().set(metadata.flatMap(SlimeLauncherMetadata::getRunsJson));
            task.getOptions().set((Object)options);
        });
    }

    @Input
    protected abstract Property<String> getRunName();

    @Nested
    protected abstract Property<SlimeLauncherOptions> getOptions();

    @Internal
    protected abstract DirectoryProperty getCacheDir();

    @InputFile
    protected abstract RegularFileProperty getRunsJson();

    @Input
    protected abstract Property<String> getDelegateMainClass();

    @Input
    @Optional
    protected abstract ListProperty<String> getDelegateArgs();

    @Input
    @Optional
    protected abstract Property<Boolean> getClient();

    @Inject
    public SlimeLauncherExec() {
        this.setGroup("Slime Launcher");
        Tool.Resolved tool = this.getTool(Tools.SLIMELAUNCHER);
        this.setClasspath(tool.getClasspath());
        if (tool.hasMainClass()) {
            this.getMainClass().set((Object)tool.getMainClass());
        }
        this.getJavaLauncher().set(tool.getJavaLauncher());
        this.getModularity().getInferModulePath().set((Object)false);
    }

    @Internal
    public TypeOf<?> getPublicType() {
        return TypeOf.typeOf(JavaExec.class);
    }

    public void exec() {
        Map<String, RunConfig> configs = Map.of();
        try {
            configs = JsonData.fromJson((File)this.getRunsJson().getAsFile().get(), new TypeToken<Map<String, RunConfig>>(){});
        }
        catch (JsonIOException jsonIOException) {
            // empty catch block
        }
        SlimeLauncherOptionsImpl options = (SlimeLauncherOptionsImpl)this.getOptions().get();
        options.inherit(configs);
        Provider mainClass = this.getDelegateMainClass().orElse(options.getMainClass().filter(Util::isPresent));
        Provider args = this.getDelegateArgs().orElse(options.getArgs());
        this.jvmArgs(new Object[]{options.getJvmArgs()});
        if (!options.getClasspath().isEmpty()) {
            this.setClasspath((FileCollection)options.getClasspath());
        }
        if (options.getMinHeapSize().filter(Util::isPresent).isPresent()) {
            this.setMinHeapSize((String)options.getMinHeapSize().get());
        }
        if (options.getMaxHeapSize().filter(Util::isPresent).isPresent()) {
            this.setMinHeapSize((String)options.getMaxHeapSize().get());
        }
        this.systemProperties((Map)options.getSystemProperties().get());
        this.environment((Map)options.getEnvironment().get());
        this.workingDir(options.getWorkingDir().get());
        if (!((String)this.getMainClass().get()).startsWith("net.minecraftforge.launcher")) {
            this.getLogger().warn("WARNING: Main class is not Slime Launcher! Skipping additional configuration.");
        } else {
            this.args(new Object[]{"--main", mainClass.get(), "--cache", ((Directory)this.getCacheDir().get()).getAsFile().getAbsolutePath(), "--metadata", ((RegularFile)this.getRunsJson().get()).getAsFile().getAbsolutePath(), "--"});
        }
        this.args(((List)args.get()).toArray());
        if (!((Boolean)this.getClient().getOrElse((Object)false)).booleanValue()) {
            this.setStandardInput(System.in);
        }
        try {
            Files.createDirectories(this.getWorkingDir().toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.getLogger().info("{} {}", (Object)this.getClasspath().getAsPath(), (Object)String.join((CharSequence)" ", this.getArgs()));
        super.exec();
    }
}

