/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.transform.NamedParam;
import groovy.transform.NamedParams;
import groovy.transform.stc.ClosureParams;
import groovy.transform.stc.FromString;
import groovy.transform.stc.SimpleType;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import net.minecraftforge.gradle.ClosureOwner;
import net.minecraftforge.gradle.ForgeGradleFlowAction;
import net.minecraftforge.gradle.ForgeGradlePlugin;
import net.minecraftforge.gradle.ForgeGradleProblems;
import net.minecraftforge.gradle.MinecraftDependency;
import net.minecraftforge.gradle.MinecraftDependencyImpl;
import net.minecraftforge.gradle.MinecraftExtensionForProject;
import net.minecraftforge.gradle.MinecraftExtensionInternal;
import net.minecraftforge.gradle.MinecraftMappings;
import net.minecraftforge.gradle.SlimeLauncherExec;
import net.minecraftforge.gradle.SlimeLauncherOptions;
import net.minecraftforge.gradle.SlimeLauncherOptionsImpl;
import net.minecraftforge.gradle.Util;
import net.minecraftforge.gradle.shadow.net.minecraftforge.util.data.json.RunConfig;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectList;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ExternalModuleDependencyBundle;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.flow.FlowProviders;
import org.gradle.api.flow.FlowScope;
import org.gradle.api.initialization.Settings;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.reflect.TypeOf;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;

abstract class MinecraftExtensionImpl
implements MinecraftExtensionInternal {
    private static final String EXT_MAVEN_REPOS = "fg_mc_maven_repos";
    private static final String EXT_MAPPINGS = "fg_mc_mappings";
    final ForgeGradleProblems problems = (ForgeGradleProblems)this.getObjects().newInstance(ForgeGradleProblems.class, new Object[0]);
    final DirectoryProperty mavenizerOutput;
    final Property<MinecraftMappings> mappings;

    @Inject
    protected abstract ObjectFactory getObjects();

    static void register(ForgeGradlePlugin plugin, ExtensionAware target) {
        ExtensionContainer extensions = target.getExtensions();
        if (target instanceof Project) {
            Project project = (Project)target;
            if (project.getPluginManager().hasPlugin("net.minecraftforge.accesstransformers")) {
                try {
                    extensions.create("minecraft", ForProjectImpl.WithAccessTransformersImpl.class, new Object[]{plugin, target});
                }
                catch (Exception e) {
                    ForgeGradleProblems problems = (ForgeGradleProblems)project.getObjects().newInstance(ForgeGradleProblems.class, new Object[0]);
                    throw problems.accessTransformersNotOnClasspath(e);
                }
            } else {
                extensions.create("minecraft", ForProjectImpl.class, new Object[]{plugin, target});
            }
        } else if (target instanceof Settings) {
            extensions.create("minecraft", ForSettingsImpl.class, new Object[]{plugin, target});
        } else {
            extensions.create("minecraft", MinecraftExtensionImpl.class, new Object[]{plugin});
        }
    }

    @Inject
    public MinecraftExtensionImpl(ForgeGradlePlugin plugin) {
        this.mavenizerOutput = this.getObjects().directoryProperty().convention(plugin.localCaches().dir("mavenizer/output").map(this.problems.ensureFileLocation()));
        this.mappings = this.getObjects().property(MinecraftMappings.class);
    }

    @Override
    public TypeOf<?> getPublicType() {
        return MinecraftExtensionInternal.super.getPublicType();
    }

    @Override
    public Action<MavenArtifactRepository> getMavenizer() {
        return maven -> {
            maven.setName("MinecraftMavenizer");
            maven.setUrl((Object)this.mavenizerOutput.getAsFile());
        };
    }

    @Override
    public MinecraftMappings getMappings() {
        try {
            return (MinecraftMappings)this.mappings.get();
        }
        catch (IllegalStateException e) {
            throw this.problems.missingMappings(e);
        }
    }

    @Override
    public void mappings(String channel, String version) {
        MinecraftMappings replacement = new MinecraftMappings(MinecraftMappings.checkParam(this.problems, channel, "channel"), MinecraftMappings.checkParam(this.problems, version, "version"));
        if (this.mappings.isPresent()) {
            this.problems.reportOverriddenMappings((MinecraftMappings)this.mappings.get(), replacement);
        }
        this.mappings.set((Object)replacement);
    }

    @Override
    public void mappings(@NamedParams(value={@NamedParam(type=String.class, value="channel", required=true), @NamedParam(type=String.class, value="version", required=true)}) Map<?, ?> namedArgs) {
        this.mappings(namedArgs.get("channel").toString(), namedArgs.get("version").toString());
    }

    static abstract class ForProjectImpl<T extends ClosureOwner<?> & MinecraftDependency>
    extends MinecraftExtensionImpl
    implements MinecraftExtensionInternal.ForProject<T> {
        private final Project project;
        private final NamedDomainObjectContainer<SlimeLauncherOptionsImpl> runs;
        private final MapProperty<String, RunConfig> configs;
        final List<MinecraftDependencyImpl> minecraftDependencies = new ArrayList<MinecraftDependencyImpl>();

        @Inject
        protected abstract FlowScope getFlowScope();

        @Inject
        protected abstract FlowProviders getFlowProviders();

        @Inject
        protected abstract ProjectLayout getProjectLayout();

        @Inject
        protected abstract ProviderFactory getProviders();

        @Inject
        public ForProjectImpl(ForgeGradlePlugin plugin, Project project) {
            super(plugin);
            this.project = project;
            this.runs = this.getObjects().domainObjectContainer(SlimeLauncherOptionsImpl.class);
            this.configs = this.getObjects().mapProperty(String.class, RunConfig.class);
            ExtraPropertiesExtension ext = project.getExtensions().getExtraProperties();
            if (ext.has(MinecraftExtensionImpl.EXT_MAPPINGS)) {
                this.mappings.set((Object)((MinecraftMappings)ext.get(MinecraftExtensionImpl.EXT_MAPPINGS)));
            }
            FlowScope flowScope = this.getFlowScope();
            flowScope.always(ForgeGradleFlowAction.WelcomeMessage.class, spec -> spec.parameters(parameters -> {
                parameters.getFailure().set(this.getFlowProviders().getBuildWorkResult().map(p -> p.getFailure().orElse(null)));
                parameters.messagesDir.set(plugin.globalCaches().dir("messages"));
                parameters.displayOption.set(this.getProviders().gradleProperty("net.minecraftforge.gradle.messages.welcome").orElse(this.getProviders().systemProperty("net.minecraftforge.gradle.messages.welcome")).map(it -> ForgeGradleFlowAction.WelcomeMessage.DisplayOption.valueOf(it.toUpperCase(Locale.ROOT))));
            }));
            flowScope.always(ForgeGradleFlowAction.AccessTransformersMissing.class, spec -> spec.parameters(parameters -> {
                parameters.getFailure().set(this.getFlowProviders().getBuildWorkResult().map(p -> p.getFailure().orElse(null)));
                parameters.appliedPlugin.set((Object)project.getPluginManager().hasPlugin("net.minecraftforge.accesstransformers"));
            }));
            project.afterEvaluate(this::finish);
            project.getGradle().projectsEvaluated(gradle -> this.finish((Gradle)gradle, project));
        }

        @Override
        public TypeOf<?> getPublicType() {
            return new TypeOf<MinecraftExtensionForProject<ClosureOwner.MinecraftDependency>>(){};
        }

        private void finish(Project project) {
            ExtraPropertiesExtension ext = project.getGradle().getExtensions().getExtraProperties();
            AppliedRepos appliedRepos = new AppliedRepos(ext.has(MinecraftExtensionImpl.EXT_MAVEN_REPOS) ? Objects.requireNonNull((List)ext.get(MinecraftExtensionImpl.EXT_MAVEN_REPOS)) : project.getRepositories().withType(MavenArtifactRepository.class));
            appliedRepos.check();
            DirectoryProperty sourceSetsDir = this.getObjects().directoryProperty().value(this.getProjectLayout().getBuildDirectory().dir("sourceSets"));
            ((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets().configureEach(sourceSet -> {
                if (this.problems.test("net.minecraftforge.gradle.merge-source-sets")) {
                    Provider unifiedDir = sourceSetsDir.dir(sourceSet.getName());
                    sourceSet.getOutput().setResourcesDir((Object)unifiedDir);
                    sourceSet.getJava().getDestinationDirectory().set(unifiedDir);
                }
            });
        }

        private void finish(Gradle gradle, Project project) {
            if (this.minecraftDependencies.isEmpty()) {
                return;
            }
            ConfigurationContainer configurations = project.getConfigurations();
            SourceSetContainer sourceSets = ((JavaPluginExtension)this.project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets();
            sourceSets.configureEach(sourceSet -> {
                for (MinecraftDependencyImpl minecraftDependency : this.minecraftDependencies) {
                    minecraftDependency.resolve();
                    if (!Util.contains(configurations, sourceSet, true, (Dependency)minecraftDependency.getDelegate())) continue;
                    minecraftDependency.handle((SourceSet)sourceSet);
                }
                if (!this.runs.isEmpty()) {
                    List<MinecraftDependencyImpl> minecraftDependencies = configurations.getByName(sourceSet.getRuntimeClasspathConfigurationName()).getAllDependencies().stream().map(it -> {
                        for (MinecraftDependencyImpl minecraftDependency : this.minecraftDependencies) {
                            ExternalModuleDependency dependency = minecraftDependency.getDelegate();
                            if (!dependency.equals(it)) continue;
                            return minecraftDependency;
                        }
                        return null;
                    }).filter(Objects::nonNull).toList();
                    boolean single = minecraftDependencies.size() == 1;
                    for (MinecraftDependencyImpl minecraftDependency : minecraftDependencies) {
                        ExternalModuleDependency dependency = minecraftDependency.getDelegate();
                        RegularFile metadataZip = minecraftDependency.getMetadataZip();
                        this.runs.forEach(options -> SlimeLauncherExec.register(project, sourceSet, options, (Map)this.configs.getOrElse(Map.of()), (Dependency)dependency, metadataZip, single));
                    }
                }
            });
        }

        @Override
        public NamedDomainObjectContainer<? extends SlimeLauncherOptions> getRuns() {
            return this.runs;
        }

        @Override
        public void runs(@DelegatesTo(value=NamedDomainObjectContainer.class) @ClosureParams(value=FromString.class, options={"org.gradle.api.NamedDomainObjectContainer<net.minecraftforge.gradle.SlimeLauncherOptions>"}) Closure<?> closure) {
            this.runs.configure(closure);
        }

        Class<? extends MinecraftDependencyImpl> getMinecraftDependencyClass() {
            return MinecraftDependencyImpl.class;
        }

        @Override
        public ExternalModuleDependency dependency(Object value, @DelegatesTo(value=ExternalModuleDependency.class) @ClosureParams(value=SimpleType.class, options={"net.minecraftforge.gradle.MinecraftDependency.ClosureOwner"}) Closure<?> closure) {
            if (value instanceof ExternalModuleDependencyBundle) {
                throw new IllegalArgumentException("Minecraft dependency cannot be a bundles");
            }
            MinecraftDependencyImpl minecraftDependency = (MinecraftDependencyImpl)this.getObjects().newInstance(this.getMinecraftDependencyClass(), new Object[]{this.project});
            this.minecraftDependencies.add(minecraftDependency);
            return minecraftDependency.setDelegate(value, closure);
        }

        private final class AppliedRepos {
            private final List<? extends MavenArtifactRepository> repos;
            private final boolean mcmaven;
            private final boolean forge;
            private final boolean mclibs;

            private AppliedRepos(List<? extends MavenArtifactRepository> repos) {
                this.repos = repos;
                this.mcmaven = this.containsExactly(ForProjectImpl.this.mavenizerOutput.getAsFile());
                this.forge = this.contains("maven.minecraftforge.net");
                this.mclibs = this.contains("libraries.minecraft.net");
            }

            private boolean contains(String s) {
                for (MavenArtifactRepository mavenArtifactRepository : this.repos) {
                    if (!mavenArtifactRepository.getUrl().toString().contains(s)) continue;
                    return true;
                }
                return false;
            }

            private boolean containsExactly(Object object) {
                for (MavenArtifactRepository mavenArtifactRepository : this.repos) {
                    if (!mavenArtifactRepository.getUrl().equals(ForProjectImpl.this.project.uri(object))) continue;
                    return true;
                }
                return false;
            }

            private void check() {
                if (!this.mcmaven) {
                    ForProjectImpl.this.problems.reportMcMavenNotDeclared();
                }
                if (!this.forge) {
                    ForProjectImpl.this.problems.reportForgeMavenNotDeclared();
                }
                if (!this.mclibs) {
                    ForProjectImpl.this.problems.reportMcLibsMavenNotDeclared();
                }
            }
        }

        static abstract class WithAccessTransformersImpl
        extends ForProjectImpl<ClosureOwner.MinecraftDependencyWithAccessTransformers>
        implements MinecraftExtensionInternal.ForProject.WithAccessTransformers {
            private final Property<String> accessTransformers = this.getObjects().property(String.class);

            @Inject
            public WithAccessTransformersImpl(ForgeGradlePlugin plugin, Project project) {
                super(plugin, project);
            }

            @Override
            public TypeOf<?> getPublicType() {
                return MinecraftExtensionInternal.ForProject.WithAccessTransformers.super.getPublicType();
            }

            @Override
            public Property<String> getAccessTransformers() {
                return this.accessTransformers;
            }

            @Override
            Class<? extends MinecraftDependencyImpl> getMinecraftDependencyClass() {
                return MinecraftDependencyImpl.WithAccessTransformersImpl.class;
            }
        }
    }

    static abstract class ForSettingsImpl
    extends MinecraftExtensionImpl {
        @Inject
        public ForSettingsImpl(ForgeGradlePlugin plugin, Settings settings) {
            super(plugin);
            settings.getGradle().settingsEvaluated(this::finish);
        }

        private void finish(Settings settings) {
            if (!this.mappings.isPresent()) {
                return;
            }
            NamedDomainObjectList repositories = settings.getDependencyResolutionManagement().getRepositories().withType(MavenArtifactRepository.class);
            ExtraPropertiesExtension ext = settings.getGradle().getExtensions().getExtraProperties();
            ext.set(MinecraftExtensionImpl.EXT_MAVEN_REPOS, (Object)repositories);
            ext.set(MinecraftExtensionImpl.EXT_MAPPINGS, this.mappings.get());
        }
    }
}

