/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import net.minecraftforge.gradle.MinecraftMappings;
import net.minecraftforge.gradle.Util;
import org.gradle.api.Action;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.process.ExecOperations;

final class MavenizerAction
implements Future<RegularFile> {
    private static final Logger LOGGER = Logging.getLogger(MavenizerAction.class);
    final ConfigurableFileCollection classpath;
    final Property<JavaLauncher> javaLauncher;
    final Property<String> mainClass;
    final DirectoryProperty caches;
    final DirectoryProperty output;
    final Property<String> module;
    final Property<String> version;
    final Property<MinecraftMappings> mappings;
    private final CapturingLogger capturingLogger;
    private final CapturingLogger capturingError;
    private final CompletableFuture<RegularFile> future;
    private final ExecOperations execOperations;

    MavenizerAction(ObjectFactory objects, ExecOperations execOperations, Action<? super MavenizerAction> action) {
        this.execOperations = execOperations;
        this.classpath = objects.fileCollection();
        this.javaLauncher = objects.property(JavaLauncher.class);
        this.mainClass = objects.property(String.class);
        this.caches = objects.directoryProperty();
        this.output = objects.directoryProperty();
        this.module = objects.property(String.class);
        this.version = objects.property(String.class);
        this.mappings = objects.property(MinecraftMappings.class);
        this.capturingLogger = new CapturingLogger(arg_0 -> ((Logger)LOGGER).lifecycle(arg_0));
        this.capturingError = new CapturingLogger(arg_0 -> ((Logger)LOGGER).error(arg_0));
        action.execute((Object)this);
        this.classpath.finalizeValue();
        this.javaLauncher.finalizeValue();
        this.mainClass.finalizeValue();
        this.caches.finalizeValue();
        this.output.finalizeValue();
        this.module.finalizeValue();
        this.version.finalizeValue();
        this.mappings.finalizeValue();
        this.future = CompletableFuture.supplyAsync(this::invoke);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.future.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public RegularFile get() throws InterruptedException, ExecutionException {
        return this.future.get();
    }

    @Override
    public RegularFile get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.future.get(timeout, unit);
    }

    void releaseLog() {
        this.capturingLogger.release();
        this.capturingError.release();
    }

    private RegularFile invoke() {
        String[] split = ((String)this.module.get()).split(":");
        if (split.length != 2) {
            throw new IllegalArgumentException("Invalid Minecraft dependency module name: " + (String)this.module.get());
        }
        String group = split[0];
        String name = split[1];
        try (PipedOutputStream stdOut = Util.toLog(this.capturingLogger);
             PipedOutputStream stdErr = Util.toLog(this.capturingError);){
            this.execOperations.javaexec(spec -> {
                spec.setStandardOutput((OutputStream)stdOut);
                spec.setErrorOutput((OutputStream)stdErr);
                spec.setClasspath((FileCollection)this.classpath);
                spec.setExecutable((Object)((JavaLauncher)this.javaLauncher.get()).getExecutablePath());
                spec.getMainClass().set(this.mainClass);
                spec.setArgs(this.getArgs());
            }).rethrowFailure();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (RegularFile)this.output.file(Util.artifactPath(group, name, (String)this.version.get(), "metadata", "zip")).get();
    }

    private List<String> getArgs() {
        ArrayList<String> args = new ArrayList<String>(List.of("--maven", "--cache", ((Directory)this.caches.get()).getAsFile().getAbsolutePath(), "--output", ((Directory)this.output.get()).getAsFile().getAbsolutePath(), "--jdk-cache", ((Directory)this.caches.dir("jdks").get()).getAsFile().getAbsolutePath(), "--artifact", (String)this.module.get(), "--version", (String)this.version.get(), "--global-auxiliary-variants"));
        if ("parchment".equals(((MinecraftMappings)this.mappings.get()).channel())) {
            args.add("--parchment");
            args.add(((MinecraftMappings)this.mappings.get()).version());
        }
        return args;
    }

    private static final class CapturingLogger
    implements Consumer<String> {
        private final Queue<String> lines = new ConcurrentLinkedQueue<String>();
        private final Consumer<? super String> logger;
        private boolean capturing = true;

        private CapturingLogger(Consumer<? super String> logger) {
            this.logger = logger;
        }

        @Override
        public void accept(String s) {
            if (this.capturing) {
                this.lines.add(s);
            } else {
                this.logger.accept(s);
            }
        }

        private void release() {
            if (!this.capturing) {
                return;
            }
            this.lines.forEach(this.logger);
            this.capturing = false;
        }
    }
}

