/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle;

import java.util.Arrays;
import java.util.Map;
import org.gradle.api.Named;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface SlimeLauncherOptions
extends Named {
    public Property<String> getMainClass();

    public ListProperty<Object> getArgs();

    public ListProperty<Object> getJvmArgs();

    public ConfigurableFileCollection getClasspath();

    public Property<String> getMinHeapSize();

    public Property<String> getMaxHeapSize();

    public MapProperty<String, Object> getSystemProperties();

    public MapProperty<String, Object> getEnvironment();

    public DirectoryProperty getWorkingDir();

    default public void args(Object args) {
        this.getArgs().add(args);
    }

    default public void args(Object ... args) {
        this.getArgs().addAll(args);
    }

    default public void args(Iterable<?> args) {
        this.getArgs().addAll(args);
    }

    default public void args(Provider<? extends Iterable<?>> args) {
        this.getArgs().addAll(args);
    }

    default public void setArgs(String ... args) {
        this.getArgs().set(Arrays.asList(args));
    }

    default public void jvmArgs(Object jvmArgs) {
        this.getJvmArgs().add(jvmArgs);
    }

    default public void jvmArgs(Object ... jvmArgs) {
        this.getJvmArgs().addAll(jvmArgs);
    }

    default public void jvmArgs(Iterable<?> jvmArgs) {
        this.getJvmArgs().addAll(jvmArgs);
    }

    default public void jvmArgs(Provider<? extends Iterable<?>> jvmArgs) {
        this.getJvmArgs().addAll(jvmArgs);
    }

    default public void setJvmArgs(Object ... jvmArgs) {
        this.getJvmArgs().set(Arrays.asList(jvmArgs));
    }

    default public void classpath(Object ... classpath) {
        this.getClasspath().from(classpath);
    }

    default public void classpath(Iterable<?> classpath) {
        this.getClasspath().from(new Object[]{classpath});
    }

    default public void classpath(FileCollection classpath) {
        this.getClasspath().from(new Object[]{classpath});
    }

    default public void setClasspath(Object ... classpath) {
        this.getClasspath().setFrom(classpath);
    }

    default public void setClasspath(Iterable<?> classpath) {
        this.getClasspath().setFrom(classpath);
    }

    default public void setClasspath(FileCollection classpath) {
        this.getClasspath().setFrom((Iterable)classpath);
    }

    default public void systemProperty(String name, Object value) {
        this.getSystemProperties().put((Object)name, value);
    }

    default public void systemProperties(Map<String, ?> properties) {
        this.getSystemProperties().putAll(properties);
    }

    default public void systemProperties(Provider<? extends Map<String, ?>> properties) {
        this.getSystemProperties().putAll(properties);
    }

    default public void environment(String name, Object value) {
        this.getEnvironment().put((Object)name, value);
    }

    default public void environment(Map<String, ?> properties) {
        this.getEnvironment().putAll(properties);
    }

    default public void environment(Provider<? extends Map<String, ?>> properties) {
        this.getEnvironment().putAll(properties);
    }
}

