/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.minecraftforge.gradle.ForgeGradleProblems;
import net.minecraftforge.gradle.ForgeGradleTask;
import net.minecraftforge.gradle.SlimeLauncherOptionsImpl;
import net.minecraftforge.gradle.Tools;
import net.minecraftforge.gradle.Util;
import net.minecraftforge.gradle.shadow.net.minecraftforge.gradleutils.shared.Tool;
import net.minecraftforge.gradle.shadow.net.minecraftforge.util.data.json.RunConfig;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.reflect.HasPublicType;
import org.gradle.api.reflect.TypeOf;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.SourceSet;

abstract class SlimeLauncherExec
extends JavaExec
implements ForgeGradleTask,
HasPublicType {
    private final ForgeGradleProblems problems = (ForgeGradleProblems)this.getObjectFactory().newInstance(ForgeGradleProblems.class, new Object[0]);
    private boolean buildAllProjects;

    static void register(Project project, SourceSet sourceSet, SlimeLauncherOptionsImpl options, Map<String, RunConfig> configs, Dependency dependency, Provider<RegularFile> metadataZip, boolean single) {
        String taskName = sourceSet.getTaskName("run", options.getName());
        project.getTasks().register((String)(single ? taskName : taskName + Util.dependencyToCamelCase(dependency)), SlimeLauncherExec.class, task -> {
            task.setDescription("Runs the '%s' Slime Launcher run configuration.".formatted(options.getName()));
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = new Object[1];
            objectArray2[0] = task.getProviderFactory().provider(() -> ((SourceSet)sourceSet).getRuntimeClasspath());
            objectArray[0] = task.getObjectFactory().fileCollection().from(objectArray2);
            task.classpath(objectArray);
            task.getJavaLauncher().unset();
            DirectoryProperty caches = task.getObjectFactory().directoryProperty().value(task.globalCaches().dir("slime-launcher/cache/%s/%s/%s".formatted(dependency.getGroup().replace(".", "/"), dependency.getName(), dependency.getVersion())));
            task.getCacheDir().set(caches.map(task.problems.ensureFileLocation()));
            task.getMetadataZip().set(metadataZip);
            task.inherit(configs, options.getName());
            options.apply((SlimeLauncherExec)task);
            if (task.buildAllProjects) {
                task.dependsOn(task.getProject().getAllprojects().stream().map(it -> it.getTasks().named("assemble")).toArray());
            }
        });
    }

    @Inject
    public SlimeLauncherExec() {
        this.setGroup("Slime Launcher");
        Tool.Resolved resolved = this.getTool(Tools.SLIMELAUNCHER);
        this.setClasspath(resolved.getClasspath());
        if (resolved.hasMainClass()) {
            this.getMainClass().set((Object)resolved.getMainClass());
        }
        this.getJavaLauncher().set(resolved.getJavaLauncher());
        this.getModularity().getInferModulePath().set((Object)false);
    }

    @Internal
    public TypeOf<?> getPublicType() {
        return TypeOf.typeOf(JavaExec.class);
    }

    private void inherit(Map<String, RunConfig> configs, String name) {
        RunConfig config = configs.get(name);
        if (config == null) {
            return;
        }
        if (config.parents != null && !config.parents.isEmpty()) {
            config.parents.forEach(parent -> this.inherit(configs, (String)parent));
        }
        if (config.main != null) {
            this.getBootstrapMainClass().set((Object)config.main);
        }
        if (config.args != null && !config.args.isEmpty()) {
            this.getMcBootstrapArgs().set(List.copyOf(config.args));
        }
        if (config.jvmArgs != null && !config.jvmArgs.isEmpty()) {
            this.jvmArgs(config.jvmArgs);
        }
        this.getClient().set((Object)config.client);
        this.buildAllProjects = config.buildAllProjects;
        if (config.env != null && !config.env.isEmpty()) {
            this.environment(config.env);
        }
        if (config.props != null && !config.props.isEmpty()) {
            this.systemProperties(config.props);
        }
    }

    public void exec() {
        if (!((String)this.getMainClass().get()).startsWith("net.minecraftforge.launcher")) {
            this.getLogger().lifecycle("Main class is not Slime Launcher! Skipping additional configuration.");
        } else {
            this.args(new Object[]{"--main", this.getBootstrapMainClass().get(), "--cache", ((Directory)this.getCacheDir().get()).getAsFile().getAbsolutePath(), "--metadata", ((RegularFile)this.getMetadataZip().get()).getAsFile().getAbsolutePath(), "--"});
            this.args(((List)this.getMcBootstrapArgs().getOrElse(List.of())).toArray());
        }
        if (!((Boolean)this.getClient().getOrElse((Object)false)).booleanValue()) {
            this.setStandardInput(System.in);
        }
        try {
            Files.createDirectories(this.getWorkingDir().toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.getLogger().info("{} {}", (Object)this.getClasspath().getAsPath(), (Object)String.join((CharSequence)" ", this.getArgs()));
        super.exec();
    }

    @InputDirectory
    protected abstract DirectoryProperty getCacheDir();

    @InputFile
    protected abstract RegularFileProperty getMetadataZip();

    @Input
    protected abstract Property<String> getBootstrapMainClass();

    @Input
    @Optional
    protected abstract ListProperty<String> getMcBootstrapArgs();

    @Input
    @Optional
    protected abstract Property<Boolean> getClient();
}

