/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle;

import java.util.ArrayList;
import java.util.Map;
import net.minecraftforge.gradle.SlimeLauncherExec;
import net.minecraftforge.gradle.SlimeLauncherOptions;
import net.minecraftforge.gradle.Util;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderConvertible;
import org.gradle.api.reflect.HasPublicType;
import org.gradle.api.reflect.TypeOf;

interface SlimeLauncherOptionsInternal
extends SlimeLauncherOptions,
HasPublicType {
    default public TypeOf<?> getPublicType() {
        return TypeOf.typeOf(SlimeLauncherOptions.class);
    }

    default public void apply(SlimeLauncherExec task) {
        if (this.getMainClass().filter(Util::isPresent).isPresent()) {
            task.getBootstrapMainClass().set(this.getMainClass());
        }
        if (this.getArgs().filter(Util::isPresent).isPresent()) {
            task.getMcBootstrapArgs().set(this.getArgs().map(args -> {
                ArrayList<String> list = new ArrayList<String>(args.size());
                for (Object arg : args) {
                    Object s;
                    if (arg instanceof ProviderConvertible) {
                        s = ((ProviderConvertible)arg).asProvider().get();
                        list.add(s.toString());
                        continue;
                    }
                    if (arg instanceof Provider) {
                        s = ((Provider)arg).get();
                        list.add(s.toString());
                        continue;
                    }
                    list.add(arg.toString());
                }
                return list;
            }));
        }
        if (this.getJvmArgs().filter(Util::isPresent).isPresent()) {
            task.jvmArgs((Iterable)this.getJvmArgs().get());
        }
        if (!this.getClasspath().isEmpty()) {
            task.setClasspath((FileCollection)this.getClasspath());
        }
        if (this.getMinHeapSize().filter(Util::isPresent).isPresent()) {
            task.setMinHeapSize((String)this.getMinHeapSize().get());
        }
        if (this.getMaxHeapSize().filter(Util::isPresent).isPresent()) {
            task.setMinHeapSize((String)this.getMaxHeapSize().get());
        }
        if (this.getSystemProperties().filter(Util::isPresent).isPresent()) {
            task.systemProperties((Map)this.getSystemProperties().get());
        }
        if (this.getEnvironment().filter(Util::isPresent).isPresent()) {
            task.environment((Map)this.getEnvironment().get());
        }
        if (this.getWorkingDir().isPresent()) {
            task.workingDir(this.getWorkingDir());
        }
    }
}

