/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle;

import groovy.lang.Closure;
import groovy.transform.NamedParam;
import groovy.transform.NamedParams;
import java.io.File;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import net.minecraftforge.accesstransformers.gradle.ArtifactAccessTransformer;
import net.minecraftforge.gradle.ForgeGradleProblems;
import net.minecraftforge.gradle.MinecraftDependencyInternal;
import net.minecraftforge.gradle.MinecraftExtension;
import net.minecraftforge.gradle.MinecraftExtensionForProjectWithAccessTransformers;
import net.minecraftforge.gradle.MinecraftExtensionImpl;
import net.minecraftforge.gradle.MinecraftMappings;
import net.minecraftforge.gradle.Util;
import net.minecraftforge.gradle.shadow.net.minecraftforge.gradleutils.shared.Closures;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Category;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.nativeplatform.OperatingSystemFamily;
import org.jetbrains.annotations.UnknownNullability;

abstract class MinecraftDependencyImpl
implements MinecraftDependencyInternal {
    private static final String AT_COUNT_NAME = "__fg_minecraft_atcontainers";
    private @UnknownNullability Provider<ExternalModuleDependency> delegate;
    private final Property<MinecraftMappings> mappings;
    final Project project;
    private final ForgeGradleProblems problems = (ForgeGradleProblems)this.getObjects().newInstance(ForgeGradleProblems.class, new Object[0]);

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract ProjectLayout getProjectLayout();

    @Inject
    protected abstract ProviderFactory getProviders();

    @Inject
    public MinecraftDependencyImpl(Project project) {
        this.project = project;
        this.mappings = this.getObjects().property(MinecraftMappings.class).convention(((MinecraftExtensionImpl)project.getExtensions().getByName((String)"minecraft")).mappings);
    }

    @Override
    public Provider<ExternalModuleDependency> getDelegate() {
        return this.delegate;
    }

    Provider<ExternalModuleDependency> setDelegate(Object dependencyNotation, Closure<?> closure) {
        this.delegate = this.getObjects().property(ExternalModuleDependency.class).value(this.getProviders().provider(() -> (ExternalModuleDependency)this.project.getDependencies().create(dependencyNotation, Closures.function(dependency -> {
            if (!(dependency instanceof ExternalModuleDependency)) {
                throw this.problems.invalidMinecraftDependencyType((Dependency)dependency);
            }
            ExternalModuleDependency module = (ExternalModuleDependency)dependency;
            if (module.isChanging()) {
                throw this.problems.changingMinecraftDependency((Dependency)dependency);
            }
            Closures.invoke(this.closure(closure), module);
            return module;
        }))));
        return this.delegate;
    }

    void resolve() {
        this.getDelegate().get();
    }

    Action<? super AttributeContainer> addAttributes() {
        return attributes -> {
            attributes.attribute(MinecraftExtension.Attributes.os, (Object)((OperatingSystemFamily)this.getObjects().named(OperatingSystemFamily.class, OperatingSystem.current().getFamilyName())));
            attributes.attributeProvider(MinecraftExtension.Attributes.mappingsChannel, this.mappings.map(MinecraftMappings::channel));
            attributes.attributeProvider(MinecraftExtension.Attributes.mappingsVersion, this.mappings.map(MinecraftMappings::version));
        };
    }

    @Override
    public void handle(SourceSet sourceSet) {
        ConfigurationContainer configurations = this.project.getConfigurations();
        ExternalModuleDependency dependency = (ExternalModuleDependency)this.getDelegate().get();
        Util.forEachClasspath(configurations, sourceSet, (Action<? super Configuration>)((Action)configuration -> configuration.getResolutionStrategy().dependencySubstitution(s -> {
            String moduleSelector = "%s:%s".formatted(dependency.getModule(), dependency.getVersion());
            ComponentSelector module = s.module(moduleSelector);
            s.substitute(module).using(s.variant(module, variant -> variant.attributes(this.addAttributes()))).because("Accounts for mappings used and natives variants");
        })));
    }

    @Override
    public MinecraftMappings getMappings() {
        try {
            return (MinecraftMappings)this.mappings.get();
        }
        catch (IllegalStateException e) {
            throw this.problems.missingMappings(e);
        }
    }

    @Override
    public void mappings(String channel, String version) {
        MinecraftMappings.checkParam(this.problems, channel, "channel");
        MinecraftMappings.checkParam(this.problems, version, "version");
        this.mappings.set((Object)new MinecraftMappings(channel, version));
    }

    @Override
    public void mappings(@NamedParams(value={@NamedParam(type=String.class, value="channel", required=true), @NamedParam(type=String.class, value="version", required=true)}) Map<?, ?> namedArgs) {
        this.mappings(namedArgs.get("channel").toString(), namedArgs.get("version").toString());
    }

    static abstract class WithAccessTransformersImpl
    extends MinecraftDependencyImpl
    implements MinecraftDependencyInternal.WithAccessTransformers {
        private final RegularFileProperty atFile = this.getObjects().fileProperty();
        private final Property<String> atPath = this.getObjects().property(String.class);
        private final Attribute<Boolean> attribute = this.registerTransform();

        @Inject
        public WithAccessTransformersImpl(Project project) {
            super(project);
            this.atPath.convention(((MinecraftExtensionForProjectWithAccessTransformers)project.getExtensions().getByType(MinecraftExtensionForProjectWithAccessTransformers.class)).getAccessTransformers());
        }

        @Override
        Action<? super AttributeContainer> addAttributes() {
            return attributes -> {
                super.addAttributes().execute(attributes);
                attributes.attribute(this.attribute, (Object)true);
            };
        }

        @Override
        public void handle(SourceSet sourceSet) {
            super.handle(sourceSet);
            if (!Util.contains(this.project.getConfigurations(), sourceSet, false, (Dependency)this.getDelegate().get())) {
                return;
            }
            if (!this.atPath.isPresent()) {
                return;
            }
            Iterator itor = sourceSet.getResources().getSrcDirs().iterator();
            if (itor.hasNext()) {
                this.atFile.convention((RegularFile)this.getProjectLayout().file(this.getProviders().provider(() -> new File((File)itor.next(), (String)this.atPath.get()))).get());
            } else {
                this.atFile.convention((RegularFile)this.getProjectLayout().getProjectDirectory().file(this.getProviders().provider(() -> "src/%s/resources/%s".formatted(sourceSet.getName(), this.atPath.get()))).get());
            }
        }

        private Attribute<Boolean> registerTransform() {
            DependencyHandler dependencies = this.project.getDependencies();
            Attribute attribute = Attribute.of((String)("net.minecraftforge.gradle.accesstransformers.automatic." + this.getIndex()), Boolean.class);
            dependencies.attributesSchema(attributesSchema -> attributesSchema.attribute(attribute));
            dependencies.getArtifactTypes().named("jar", type -> type.getAttributes().attribute(attribute, (Object)false));
            dependencies.registerTransform(ArtifactAccessTransformer.class, spec -> {
                spec.parameters(ArtifactAccessTransformer.Parameters.defaults((Project)this.project, parameters -> {
                    parameters.getConfig().set((Provider)this.atFile);
                    this.project.afterEvaluate(p -> ArtifactAccessTransformer.validateConfig((Project)this.project, (Object)this.getDelegate().get(), (RegularFileProperty)this.atFile));
                }));
                spec.getFrom().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"jar").attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)this.getObjects().named(Category.class, "library"))).attribute(attribute, (Object)false);
                spec.getTo().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"jar").attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)this.getObjects().named(Category.class, "library"))).attribute(attribute, (Object)true);
            });
            return attribute;
        }

        private int getIndex() {
            ExtraPropertiesExtension ext = this.project.getGradle().getExtensions().getExtraProperties();
            int index = ext.has(MinecraftDependencyImpl.AT_COUNT_NAME) ? (Integer)Objects.requireNonNull(ext.get(MinecraftDependencyImpl.AT_COUNT_NAME), "Internal extra property can never be null!") + 1 : 0;
            ext.set(MinecraftDependencyImpl.AT_COUNT_NAME, (Object)index);
            return index;
        }

        @Override
        public RegularFileProperty getAccessTransformer() {
            return this.atFile;
        }

        @Override
        public void setAccessTransformer(String accessTransformer) {
            this.atPath.set((Object)accessTransformer);
        }

        @Override
        public void setAccessTransformer(boolean accessTransformer) {
            if (accessTransformer) {
                this.setAccessTransformer("META-INF/accesstransformer.cfg");
            } else {
                this.atPath.unsetConvention().unset();
            }
        }
    }
}

