/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle;

import groovy.lang.Closure;
import groovy.transform.NamedParam;
import groovy.transform.NamedParams;
import java.io.File;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import net.minecraftforge.accesstransformers.gradle.AccessTransformersContainer;
import net.minecraftforge.gradle.ForgeGradleProblems;
import net.minecraftforge.gradle.MinecraftDependencyInternal;
import net.minecraftforge.gradle.MinecraftExtension;
import net.minecraftforge.gradle.MinecraftExtensionForProjectWithAccessTransformers;
import net.minecraftforge.gradle.MinecraftExtensionImpl;
import net.minecraftforge.gradle.MinecraftMappings;
import net.minecraftforge.gradle.Util;
import net.minecraftforge.gradle.shadow.net.minecraftforge.gradleutils.shared.Closures;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyScopeConfiguration;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.nativeplatform.OperatingSystemFamily;
import org.jetbrains.annotations.UnknownNullability;

abstract class MinecraftDependencyImpl
implements MinecraftDependencyInternal {
    private static final String AT_COUNT_NAME = "fg_minecraft_atcontainers";
    private @UnknownNullability Provider<ExternalModuleDependency> delegate;
    private final Property<MinecraftMappings> mappings;
    final Project project;
    private final ForgeGradleProblems problems = (ForgeGradleProblems)this.getObjects().newInstance(ForgeGradleProblems.class, new Object[0]);

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract ProjectLayout getProjectLayout();

    @Inject
    protected abstract ProviderFactory getProviders();

    @Inject
    public MinecraftDependencyImpl(Project project) {
        this.project = project;
        this.mappings = this.getObjects().property(MinecraftMappings.class).convention(((MinecraftExtensionImpl)project.getExtensions().getByName((String)"minecraft")).mappings);
    }

    @Override
    public Provider<ExternalModuleDependency> getDelegate() {
        return this.delegate;
    }

    Provider<ExternalModuleDependency> setDelegate(Object dependencyNotation, Closure<?> closure) {
        this.delegate = this.getObjects().property(ExternalModuleDependency.class).value(this.getProviders().provider(() -> (ExternalModuleDependency)this.project.getDependencies().create(dependencyNotation, Closures.function(dependency -> {
            if (!(dependency instanceof ExternalModuleDependency)) {
                throw this.problems.invalidMinecraftDependencyType((Dependency)dependency);
            }
            ExternalModuleDependency module = (ExternalModuleDependency)dependency;
            if (module.isChanging()) {
                throw this.problems.changingMinecraftDependency((Dependency)dependency);
            }
            Closures.invoke(this.closure(closure), module);
            return module;
        }))));
        return this.delegate;
    }

    void resolve() {
        this.getDelegate().get();
    }

    @Override
    public void handle(SourceSet sourceSet) {
        NamedDomainObjectProvider minecraftDependencyConstraints;
        ConfigurationContainer configurations = this.project.getConfigurations();
        ExternalModuleDependency dependency = (ExternalModuleDependency)this.getDelegate().get();
        try {
            minecraftDependencyConstraints = configurations.dependencyScope("minecraftDependencyConstraints", configuration -> configuration.setDescription("Transient dependency constraints for Minecraft dependencies."));
        }
        catch (InvalidUserDataException e) {
            minecraftDependencyConstraints = configurations.named("minecraftDependencyConstraints", DependencyScopeConfiguration.class);
        }
        configurations.getByName(sourceSet.getCompileClasspathConfigurationName()).extendsFrom(new Configuration[]{(Configuration)minecraftDependencyConstraints.get()});
        configurations.getByName(sourceSet.getRuntimeClasspathConfigurationName()).extendsFrom(new Configuration[]{(Configuration)minecraftDependencyConstraints.get()});
        ((DependencyScopeConfiguration)minecraftDependencyConstraints.get()).getDependencyConstraints().add((Object)this.project.getDependencies().getConstraints().create((Object)dependency.getModule().toString(), constraint -> {
            constraint.because("Accounts for mappings used and natives variants");
            constraint.attributes(attributes -> {
                attributes.attribute(MinecraftExtension.Attributes.os, (Object)((OperatingSystemFamily)this.getObjects().named(OperatingSystemFamily.class, OperatingSystem.current().getFamilyName())));
                attributes.attributeProvider(MinecraftExtension.Attributes.mappingsChannel, this.mappings.map(MinecraftMappings::channel));
                attributes.attributeProvider(MinecraftExtension.Attributes.mappingsVersion, this.mappings.map(MinecraftMappings::version));
            });
        }));
    }

    @Override
    public MinecraftMappings getMappings() {
        try {
            return (MinecraftMappings)this.mappings.get();
        }
        catch (IllegalStateException e) {
            throw this.problems.missingMappings(e);
        }
    }

    @Override
    public void mappings(String channel, String version) {
        MinecraftMappings.checkParam(this.problems, channel, "channel");
        MinecraftMappings.checkParam(this.problems, version, "version");
        this.mappings.set((Object)new MinecraftMappings(channel, version));
    }

    @Override
    public void mappings(@NamedParams(value={@NamedParam(type=String.class, value="channel", required=true), @NamedParam(type=String.class, value="version", required=true)}) Map<?, ?> namedArgs) {
        this.mappings(namedArgs.get("channel").toString(), namedArgs.get("version").toString());
    }

    static abstract class WithAccessTransformersImpl
    extends MinecraftDependencyImpl
    implements MinecraftDependencyInternal.WithAccessTransformers {
        private final AccessTransformersContainer atContainer;
        private final Property<String> atPath = this.getObjects().property(String.class);

        @Inject
        public WithAccessTransformersImpl(Project project) {
            super(project);
            this.atContainer = AccessTransformersContainer.register((Project)project, it -> {});
            this.atPath.convention(((MinecraftExtensionForProjectWithAccessTransformers)project.getExtensions().getByType(MinecraftExtensionForProjectWithAccessTransformers.class)).getAccessTransformers());
        }

        @Override
        Provider<ExternalModuleDependency> setDelegate(Object dependencyNotation, Closure<?> closure) {
            return super.setDelegate(dependencyNotation, Closures.consumer(dependency -> {
                Closures.invoke(closure, dependency);
                this.atContainer.configure(dependency);
            }));
        }

        @Override
        public void handle(SourceSet sourceSet) {
            super.handle(sourceSet);
            if (!Util.contains(this.project.getConfigurations(), sourceSet, false, (Dependency)this.getDelegate().get())) {
                return;
            }
            if (!this.atPath.isPresent()) {
                return;
            }
            Iterator itor = sourceSet.getResources().getSrcDirs().iterator();
            if (itor.hasNext()) {
                this.getAccessTransformer().convention((RegularFile)this.getProjectLayout().file(this.getProviders().provider(() -> new File((File)itor.next(), (String)this.atPath.get()))).get());
            } else {
                this.getAccessTransformer().convention((RegularFile)this.getProjectLayout().getProjectDirectory().file(this.getProviders().provider(() -> "src/%s/resources/%s".formatted(sourceSet.getName(), this.atPath.get()))).get());
            }
        }

        private int getAtContainerCount() {
            try {
                return (Integer)this.project.getExtensions().getExtraProperties().get(MinecraftDependencyImpl.AT_COUNT_NAME);
            }
            catch (ExtraPropertiesExtension.UnknownPropertyException ignored) {
                this.setAtContainerCount(0);
                return 0;
            }
        }

        private void setAtContainerCount(int count) {
            this.project.getExtensions().getExtraProperties().set(MinecraftDependencyImpl.AT_COUNT_NAME, (Object)count);
        }

        private int postIncrementContainerCount() {
            int ret = this.getAtContainerCount();
            this.setAtContainerCount(ret + 1);
            return ret;
        }

        @Override
        public RegularFileProperty getAccessTransformer() {
            return this.atContainer.getOptions().getConfig();
        }

        @Override
        public void setAccessTransformer(String accessTransformer) {
            this.atPath.set((Object)accessTransformer);
        }

        @Override
        public void setAccessTransformer(boolean accessTransformer) {
            if (accessTransformer) {
                this.setAccessTransformer("META-INF/accesstransformer.cfg");
            } else {
                this.atPath.unsetConvention().unset();
            }
        }

        @Override
        public void accessTransformer(Action<? super AccessTransformersContainer.Options> options) {
            this.atContainer.options(options);
        }
    }
}

