/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.transform.stc.FirstParam;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.codehaus.groovy.reflection.ReflectionUtils;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.gradle.api.Action;
import org.jetbrains.annotations.UnknownNullability;

final class Closures {
    Closures() {
    }

    static <T> @UnknownNullability T invoke(Object object, @DelegatesTo(value=FirstParam.class, strategy=1) Closure closure) {
        closure.setDelegate(object);
        closure.setResolveStrategy(1);
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(closure.getClass().getClassLoader());
        try {
            Object ret = closure.getMaximumNumberOfParameters() == 0 ? closure.call() : closure.call(object);
            Object object2 = ret != null ? ret : null;
            return (T)object2;
        }
        catch (InvokerInvocationException e) {
            Throwable cause = e.getCause();
            throw cause instanceof RuntimeException ? (RuntimeException)cause : e;
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    static <T> @UnknownNullability T invoke(Closure closure) {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(closure.getClass().getClassLoader());
        try {
            Object ret = closure.call();
            Object object = ret != null ? ret : null;
            return (T)object;
        }
        catch (InvokerInvocationException e) {
            Throwable cause = e.getCause();
            throw cause instanceof RuntimeException ? (RuntimeException)cause : e;
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    static <R> Closure<R> unaryOperator(UnaryOperator<? extends R> function) {
        return Closures.function(function);
    }

    static <R> Closure<R> unaryOperator(Object owner, UnaryOperator<? extends R> function) {
        return Closures.function(owner, function);
    }

    static <T, R> Closure<R> function(Function<? super T, ? extends R> function) {
        return Closures.function(ReflectionUtils.getCallingClass(), function);
    }

    static <T, R> Closure<R> function(Object owner, Function<? super T, ? extends R> function) {
        return new Functional<T, R>(owner, function);
    }

    static <R> Closure<R> supplier(Supplier<? extends R> supplier) {
        return Closures.supplier(ReflectionUtils.getCallingClass(), supplier);
    }

    static <R> Closure<R> supplier(Object owner, Supplier<? extends R> supplier) {
        return new Supplying<R>(owner, supplier);
    }

    static <T> Closure<Void> action(Object owner, Action<? super T> action) {
        return Closures.consumer(owner, arg_0 -> action.execute(arg_0));
    }

    static <T> Closure<Void> consumer(Consumer<? super T> consumer) {
        return Closures.consumer(ReflectionUtils.getCallingClass(), consumer);
    }

    static <T> Closure<Void> consumer(Object owner, Consumer<? super T> consumer) {
        return new Consuming<T>(owner, consumer);
    }

    static Closure<Void> runnable(Runnable runnable) {
        return Closures.runnable(ReflectionUtils.getCallingClass(), runnable);
    }

    static Closure<Void> runnable(Object owner, Runnable runnable) {
        return new Running(owner, runnable);
    }

    static Closure<Void> empty() {
        return Closures.empty(ReflectionUtils.getCallingClass());
    }

    static Closure<Void> empty(Object owner) {
        return new Empty(owner);
    }

    private static final class Functional<T, R>
    extends Closure<R> {
        private final Function<? super T, ? extends R> function;

        private Functional(Object owner, Function<? super T, ? extends R> function) {
            super(owner, owner);
            this.function = function;
        }

        public R doCall(T object) {
            return this.function.apply(object);
        }
    }

    private static final class Supplying<R>
    extends Closure<R> {
        private final Supplier<? extends R> supplier;

        private Supplying(Object owner, Supplier<? extends R> supplier) {
            super(owner, owner);
            this.supplier = supplier;
        }

        public R doCall() {
            return this.supplier.get();
        }
    }

    private static final class Consuming<T>
    extends Closure<Void> {
        private final Consumer<? super T> consumer;

        private Consuming(Object owner, Consumer<? super T> consumer) {
            super(owner, owner);
            this.consumer = consumer;
        }

        public Void doCall(T object) {
            this.consumer.accept(object);
            return null;
        }
    }

    private static final class Running
    extends Empty {
        private final Runnable runnable;

        private Running(Object owner, Runnable runnable) {
            super(owner);
            this.runnable = runnable;
        }

        @Override
        public Void doCall() {
            this.runnable.run();
            return super.doCall();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static class Empty
    extends Closure<Void> {
        public Empty(Object owner) {
            super(owner, owner);
        }

        public Void doCall() {
            return null;
        }
    }
}

