/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraftforge.gradle.shadow.net.minecraftforge.gradleutils.shared.SharedUtil;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.gradle.TaskExecutionRequest;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.Nullable;

final class Util
extends SharedUtil {
    Util() {
    }

    static String artifactPath(@Nullable String group, String name, @Nullable String version, @Nullable String classifier, @Nullable String extension) {
        return MessageFormat.format("{0}{1}/{2}/{1}-{3}{4}.{5}", group == null ? "" : group.replace('.', '/') + "/", name, version == null ? "/" : "/" + version + "/", version == null ? "" : version, classifier == null ? "" : "-" + classifier, extension == null ? "jar" : extension);
    }

    static <T extends Collection<?>> boolean isPresent(T c) {
        return !c.isEmpty();
    }

    static <T extends Map<?, ?>> boolean isPresent(T c) {
        return !c.isEmpty();
    }

    static boolean isPresent(String c) {
        return !c.isBlank();
    }

    static String dependencyToCamelCase(Dependency dependency) {
        ArrayList<String> list = new ArrayList<String>(3);
        String group = dependency.getGroup();
        if (group != null) {
            list.addAll(Arrays.asList(group.split("\\.")));
        }
        list.add(dependency.getName());
        try {
            list.add(InvokerHelper.getProperty((Object)dependency, (String)"classifer").toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        StringBuilder builder = new StringBuilder(64);
        for (String s : list) {
            builder.append(StringGroovyMethods.capitalize((CharSequence)s));
        }
        return builder.toString();
    }

    static boolean contains(ConfigurationContainer configurations, SourceSet sourceSet, Dependency dependency) {
        return Util.contains(configurations, sourceSet.getCompileOnlyConfigurationName(), dependency) || Util.contains(configurations, sourceSet.getCompileOnlyApiConfigurationName(), dependency) || Util.contains(configurations, sourceSet.getCompileClasspathConfigurationName(), dependency) || Util.contains(configurations, sourceSet.getAnnotationProcessorConfigurationName(), dependency) || Util.contains(configurations, sourceSet.getApiConfigurationName(), dependency) || Util.contains(configurations, sourceSet.getImplementationConfigurationName(), dependency) || Util.contains(configurations, sourceSet.getApiElementsConfigurationName(), dependency) || Util.contains(configurations, sourceSet.getRuntimeOnlyConfigurationName(), dependency) || Util.contains(configurations, sourceSet.getRuntimeClasspathConfigurationName(), dependency) || Util.contains(configurations, sourceSet.getRuntimeElementsConfigurationName(), dependency);
    }

    private static boolean contains(ConfigurationContainer configurations, String configurationName, Dependency dependency) {
        Configuration configuration = (Configuration)configurations.findByName(configurationName);
        return configuration != null && configuration.getDependencies().contains((Object)dependency);
    }

    static <T extends TaskProvider<?>> T runFirst(Project project, final T task) {
        ArrayList<1> requests = new ArrayList<1>(project.getGradle().getStartParameter().getTaskRequests());
        requests.add(0, new TaskExecutionRequest(){

            public List<String> getArgs() {
                return List.of(((Task)task.get()).getPath());
            }

            @Nullable
            public String getProjectPath() {
                return null;
            }

            @Nullable
            public File getRootDir() {
                return null;
            }
        });
        project.getLogger().info("Adding task to beginning of task graph! Project: {}, Task: {}", (Object)project.getName(), (Object)task.getName());
        project.getGradle().getStartParameter().setTaskRequests(requests);
        return task;
    }
}

