/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle;

import javax.inject.Inject;
import net.minecraftforge.gradle.ForgeGradlePlugin;
import net.minecraftforge.gradle.MinecraftMappings;
import net.minecraftforge.gradle.Util;
import net.minecraftforge.gradle.shadow.net.minecraftforge.gradleutils.shared.EnhancedProblems;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.problems.Severity;

abstract class ForgeGradleProblems
extends EnhancedProblems {
    @Inject
    public ForgeGradleProblems() {
        super("forgegradle", "ForgeGradle");
    }

    RuntimeException missingMappings(Throwable throwable) {
        return this.getReporter().throwing(throwable, this.id("missing-mappings", "Missing Minecraft mappings"), spec -> spec.details("Attempted to consume Minecraft mappings, but none were declared.\nMinecraft dependencies cannot be resolved without mappings.").severity(Severity.ERROR).stackLocation().solution("Declare mappings in your buildscript in the minecraft {} closure, such as `mappings channel: 'official', version: '1.21.5'`.").solution("Move the minecraft {} closure above the dependencies {} closure in your buildscript.").solution("Consult the documentation or ask for help on the Forge Forums, GitHub, or Discord server."));
    }

    RuntimeException nullMappingsParam(String name) {
        return this.getReporter().throwing((Throwable)new IllegalArgumentException("Mappings %s cannot be null".formatted(name)), this.id("null-mappings-param", "Null mappings parameter"), spec -> spec.details("Attempted to create a Mappings object, but the %s parameter was null.\nThe parameters for the Mappings object are not null.".formatted(name)).severity(Severity.ERROR).stackLocation().solution("Do not pass in any null values to the mappings constructor or MinecraftExtension#mappings.").solution("Consult the documentation or ask for help on the Forge Forums, GitHub, or Discord server."));
    }

    void reportOverriddenMappings(MinecraftMappings original, MinecraftMappings replacement) {
        if (!this.test("net.minecraftforge.gradle.warnings.overriddenMappings")) {
            return;
        }
        String comparison = "Old: (channel: %s, version: %s), New: (channel: %s, version: %s)".formatted(original.channel(), original.version(), replacement.channel(), replacement.version());
        ForgeGradlePlugin.LOGGER.warn("WARNING: Overriding previously declared mappings! {}", (Object)comparison);
        this.getReporter().report(this.id("multiple-mappings", "Multiple mappings declared"), spec -> spec.details("Mappings are being set, even though they have already been declared.\nThis will cause the current mappings to be overridden, which may lead to unexpected behavior.\n" + comparison).severity(Severity.WARNING).stackLocation().solution("Declare mappings only once in your buildscript.").solution("Do not attempt to re-declare mappings in a loop or closure. Instead, evaluate the channel and version you want, then declare mappings using them."));
    }

    void reportMissingMinecraftDependency() {
        if (!this.test("net.minecraftforge.gradle.warnings.missingMinecraftDependency")) {
            return;
        }
        ForgeGradlePlugin.LOGGER.error("ERROR: No Minecraft dependency declared! Disabling ForgeGradle. See Problems report for details.");
        this.getReporter().report(this.id("missing-dependency", "Missing Minecraft dependency"), spec -> spec.details("ForgeGradle was applied, but no Minecraft dependency was declared.\nForgeGradle will now be disabled and stop all further registrations.").severity(Severity.ERROR).stackLocation().solution("Declare a Minecraft dependency in your build.gradle file, such as `implementation minecraft.dep('net.minecraftforge:forge:1.21.5-55.0.3')`").solution("Ensure that your Minecraft dependency is declared using the `minecraft.dep(...)` method.").solution("Ensure that your buildscript with your dependencies is being loaded correctly.").solution("Do not apply ForgeGradle if you are not planning on developing for Minecraft.").solution("Consult the documentation or ask for help on the Forge Forums, GitHub, or Discord server."));
    }

    RuntimeException invalidMinecraftDependencyType(Dependency dependency) {
        return this.getReporter().throwing((Throwable)new IllegalArgumentException("Minecraft dependency is not a module dependency"), this.id("unsupported-minecraft-dependency-type", "Non-module dependency used as Minecraft dependency"), spec -> spec.details("Attempted to use a non-module (or internal module) dependency as a Minecraft dependency.\nThe Minecraft dependency must be an external module dependency, as it is resolved from the Minecraft Maven.\nThis means that it cannot be substituted with file or project dependencies.\nExpected: (implementation of) %s, Actual: '%s\nDependency: '%s'".formatted(ExternalModuleDependency.class.getName(), dependency.getClass().getName(), Util.toString(dependency))).severity(Severity.ERROR).stackLocation().solution("Declare a module dependency instead.").solution("Consult the documentation or ask for help on the Forge Forums, GitHub, or Discord server."));
    }

    @Deprecated(forRemoval=true)
    void reportMissingMetadata(Throwable throwable) {
        this.getReporter().report(this.id("missing-metadata", "Failed to extract metadata"), spec -> spec.details("ForgeGradle failed to locate or extract the metadata generated for the Minecraft dependency.\nThis is expected if the Minecraft Maven has not yet been synced.\nIf you are seeing this after your first project sync, please report this as it might be a ForgeGradle bug.").severity(Severity.WARNING).withException(throwable).stackLocation().solution("Re-run the synchronization for your Gradle project.").solution("Manually run the syncMinecraftMaven task if necessary.").solution("Consult the documentation or ask for help on the Forge Forums, GitHub, or Discord server."));
    }

    RuntimeException changingMinecraftDependency(Dependency dependency) {
        return this.getReporter().throwing((Throwable)new IllegalArgumentException("Minecraft dependency cannot be changing"), this.id("changing-minecraft-dependency", "Minecraft dependency marked as changing"), spec -> spec.details("Attempted to use a Minecraft dependency that was marked as changing.\nThis is currently unsupported.\nDependency: %s".formatted(Util.toString(dependency))).severity(Severity.ERROR).solution("Do not mark the Minecraft dependency as changing.").solution("Consult the documentation or ask for help on the Forge Forums, GitHub, or Discord server."));
    }

    void reportMcMavenNotDeclared() {
        if (!this.test("net.minecraftforge.gradle.warnings.missingRepository.mcmaven")) {
            return;
        }
        this.getReporter().report(this.id("minecraft-maven-not-declared", "Minecraft Maven not declared"), spec -> spec.details("ForgeGradle was configured to sync the Minecraft Maven, but it was not declared as a repository!\nThis will result in a \"cannot resolve dependency\" error.").severity(Severity.ERROR).solution("Declare the Miencraft Maven (`minecraft.maven`) in your project/settings repositories.").solution("Consult the documentation or ask for help on the Forge Forums, GitHub, or Discord server."));
    }

    void reportMcLibsMavenNotDeclared() {
        if (!this.test("net.minecraftforge.gradle.warnings.missingRepository.mclibs")) {
            return;
        }
        this.getReporter().report(this.id("minecraft-libs-maven-not-declared", "Minecraft Libraries maven not declared"), spec -> spec.details("ForgeGradle was configured to sync the Minecraft Maven, but the Minecraft Libraries maven was not declared!\nThe generated Minecraft artifact has dependencies from libraries that may only exist on there.\nThis may result in a \"cannot resolve dependency\" error.").severity(Severity.WARNING).solution("Declare the Minecraft Libs maven (`fg.minecraftLibsMaven`) in your project/settings repositories.").solution("Consult the documentation or ask for help on the Forge Forums, GitHub, or Discord server."));
    }

    void reportForgeMavenNotDeclared() {
        if (!this.test("net.minecraftforge.gradle.warnings.missingRepository.forge")) {
            return;
        }
        this.getReporter().report(this.id("forge-maven-not-declared", "Forge maven not declared"), spec -> spec.details("ForgeGradle was configured to sync the Minecraft Maven, but the Forge maven was not declared!\nThe generated Minecraft artifact has dependencies from libraries that may only exist on there.\nThis may result in a \"cannot resolve dependency\" error.").severity(Severity.WARNING).solution("Declare the Forge maven (`fg.forgeMaven`) in your project/settings repositories.").solution("Consult the documentation or ask for help on the Forge Forums, GitHub, or Discord server."));
    }

    void reportAccessTransformersNotApplied(Throwable e) {
        this.getReporter().report(this.id("access-transformers-not-applied", "AccessTransformers plugin not applied"), spec -> spec.details("The build failed with an exception when trying to access access transformers.\nThe project using ForgeGradle does not have the AccessTransformers Gradle plugin applied, and thus it cannot be used.\nAccessTransformers Gradle must be applied in order to use it with the Minecraft dependency.").severity(Severity.ERROR).withException(e).stackLocation().solution("Apply the 'net.minecraftforge.accesstransformers' plugin before ForgeGradle.").solution("Consult the documentation or ask for help on the Forge Forums, GitHub, or Discord server."));
    }

    RuntimeException accessTransformersNotOnClasspath(Throwable e) {
        return this.getReporter().throwing(e, this.id("access-transformers-not-on-classpath", "AccessTransformers plugin not on classpath"), spec -> spec.details("The AccessTransformers plugin was not loaded in the classpath before ForgeGradle.\nForgeGradle cannot create the 'minecraft' extension without referencing classes from the plugin.\nIt must be added to the classpath, even if it isn't applied (i.e. in settings.gradle)\n```groovy\nplugins {\n    id 'net.minecraftforge.accesstransformers' version '2.0.0' apply false\n    id 'net.minecraftforge.gradle' version '7.0.0'\n}\n```").severity(Severity.ERROR).stackLocation().solution("Declare the 'net.minecraftforge.accesstransformers' plugin before ForgeGradle.").solution("Consult the documentation or ask for help on the Forge Forums, GitHub, or Discord server."));
    }
}

