/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.minecraftforge.gradle.ForgeGradlePlugin;
import net.minecraftforge.gradle.ForgeGradleProblems;
import net.minecraftforge.gradle.MinecraftDependency;
import net.minecraftforge.gradle.MinecraftDependencyInternal;
import net.minecraftforge.gradle.MinecraftExtensionImpl;
import net.minecraftforge.gradle.MinecraftMappings;
import net.minecraftforge.gradle.Tools;
import net.minecraftforge.gradle.Util;
import net.minecraftforge.gradle.shadow.net.minecraftforge.gradleutils.shared.EnhancedPlugin;
import net.minecraftforge.gradle.shadow.net.minecraftforge.gradleutils.shared.EnhancedTask;
import net.minecraftforge.gradle.shadow.net.minecraftforge.gradleutils.shared.Tool;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.reflect.HasPublicType;
import org.gradle.api.reflect.TypeOf;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.process.ExecOperations;

abstract class SyncMinecraftMaven
extends DefaultTask
implements EnhancedTask,
HasPublicType {
    static final String NAME = "syncMinecraftMaven";
    private final ForgeGradleProblems problems = (ForgeGradleProblems)this.getObjects().newInstance(ForgeGradleProblems.class, new Object[0]);

    static TaskProvider<SyncMinecraftMaven> register(Project project, MinecraftExtensionImpl.ForProjectImpl<?> minecraft) {
        return Util.runFirst(project, project.getTasks().register(NAME, SyncMinecraftMaven.class, task -> {
            task.getRequests().addAll(Request.collect(minecraft.minecraftDependencies));
            task.getOutput().set((Provider)minecraft.output);
        }));
    }

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract ExecOperations getExecOperations();

    @Inject
    public SyncMinecraftMaven() {
        this.setGroup("Build Setup");
        this.setDescription("Syncs the Minecraft dependencies using Minecraft Mavenizer.");
        Tool.Resolved tool = this.getTool(Tools.MAVENIZER);
        this.getExecutable().convention((Iterable)tool.getClasspath());
        this.getJavaLauncher().convention(tool.getJavaLauncher());
        this.getMainClass().convention((Object)tool.getMainClass());
        DirectoryProperty defaultDirectory = this.getObjects().directoryProperty().value(this.globalCaches().dir("mavenizer").map(this.problems.ensureFileLocation()));
        this.getCaches().convention(defaultDirectory.dir("cache").map(this.problems.ensureFileLocation()));
        this.getOutput().convention(defaultDirectory.dir("output").map(this.problems.ensureFileLocation()));
        this.onlyIf("Minecraft Mavenizer will not run if no Minecraft dependencies are present.", task -> {
            SetProperty<Request> requests = ((SyncMinecraftMaven)task).getRequests();
            return requests.isPresent() && !((Set)requests.get()).isEmpty();
        });
    }

    @Override
    public Class<? extends EnhancedPlugin<? super Project>> pluginType() {
        return ForgeGradlePlugin.class;
    }

    @Internal
    public TypeOf<?> getPublicType() {
        return TypeOf.typeOf(DefaultTask.class);
    }

    @TaskAction
    public void exec() {
        ((Set)this.getRequests().get()).forEach(this::exec);
    }

    private void exec(Request request) {
        this.getExecOperations().javaexec(spec -> {
            spec.setClasspath((FileCollection)this.getExecutable());
            spec.setExecutable((Object)((JavaLauncher)this.getJavaLauncher().get()).getExecutablePath());
            spec.getMainClass().set(this.getMainClass());
            spec.setArgs(this.argsFor(request));
        }).rethrowFailure();
    }

    private List<String> argsFor(Request request) {
        ArrayList<String> args = new ArrayList<String>(List.of("--maven", "--cache", ((Directory)this.getCaches().get()).getAsFile().getAbsolutePath(), "--output", ((Directory)this.getOutput().get()).getAsFile().getAbsolutePath(), "--jdk-cache", ((Directory)this.getCaches().dir("jdks").get()).getAsFile().getAbsolutePath(), "--artifact", request.module, "--version", request.version, "--global-auxiliary-variants"));
        if ("parchment".equals(request.mappings.channel())) {
            args.add("--parchment");
            args.add(request.mappings.version());
        }
        return args;
    }

    @Classpath
    protected abstract ConfigurableFileCollection getExecutable();

    @Nested
    protected abstract Property<JavaLauncher> getJavaLauncher();

    @Input
    protected abstract Property<String> getMainClass();

    @InputDirectory
    protected abstract DirectoryProperty getCaches();

    @InputDirectory
    protected abstract DirectoryProperty getOutput();

    @Input
    @Optional
    protected abstract SetProperty<Request> getRequests();

    public record Request(String module, String version, MinecraftMappings mappings) implements Serializable
    {
        public Request(MinecraftDependency minecraft, ExternalModuleDependency module) {
            this("%s:%s".formatted(module.getGroup(), module.getName()), Objects.requireNonNull(module.getVersion(), "Minecraft artifact must have a version"), Objects.requireNonNull(minecraft.getMappings(), "Minecraft dependencies are not finished"));
        }

        private static Set<Request> collect(Collection<? extends MinecraftDependencyInternal> requests) {
            return requests.stream().map(d -> new Request((MinecraftDependency)d, (ExternalModuleDependency)d.getDelegate().get())).collect(Collectors.toSet());
        }
    }
}

