/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import javax.inject.Inject;
import net.minecraftforge.gradle.ForgeGradlePlugin;
import net.minecraftforge.gradle.ForgeGradleProblems;
import net.minecraftforge.gradle.shadow.net.minecraftforge.gradleutils.shared.EnhancedFlowAction;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.ProviderFactory;

abstract class ForgeGradleFlowAction<P extends Parameters>
extends EnhancedFlowAction<P> {
    ForgeGradleFlowAction() {
    }

    static abstract class AccessTransformersMissing
    extends ForgeGradleFlowAction<Parameters> {
        @Inject
        public AccessTransformersMissing() {
        }

        @Override
        protected void run(Parameters parameters) {
            if (!parameters.getFailure().isPresent() || ((Boolean)parameters.appliedPlugin.getOrElse((Object)false)).booleanValue()) {
                return;
            }
            Throwable e = (Throwable)parameters.getFailure().get();
            if (!AccessTransformersMissing.contains(e, "accesstransformer")) {
                return;
            }
            ((ForgeGradleProblems)parameters.problems()).reportAccessTransformersNotApplied(e);
        }

        static abstract class Parameters
        extends net.minecraftforge.gradle.ForgeGradleFlowAction$Parameters {
            final Property<Boolean> appliedPlugin = this.getObjects().property(Boolean.class).convention((Object)false);

            @Inject
            public Parameters() {
            }
        }
    }

    static abstract class WelcomeMessage
    extends ForgeGradleFlowAction<Parameters> {
        @Inject
        public WelcomeMessage() {
        }

        @Override
        protected void run(Parameters parameters) throws IOException {
            if (parameters.getFailure().isPresent()) {
                return;
            }
            File markerFile = ((RegularFile)parameters.messagesDir.file("7_0_BETA_WELCOME").get()).getAsFile();
            if (markerFile.exists()) {
                return;
            }
            Files.createDirectories(markerFile.toPath().getParent(), new FileAttribute[0]);
            Files.createFile(markerFile.toPath(), new FileAttribute[0]);
            ForgeGradlePlugin.LOGGER.lifecycle("Welcome to ForgeGradle 7.0!\n\nHere are some release highlights:\n- Complete rewrite of the plugin and underlying code.\n- Complete overhaul of DSL objects and registrations.\n- Slimmed down the plugin, which now delegates many actions to separate tools.\n- Support for declaring defaults in settings.gradle.\n- Support for all Forge versions from Minecraft 1.20.6 (older versions are a\n  work-in-progress).\n\nA couple of important things to note:\n- ForgeGradle 6 and older will no longer be supported, except for critical bug\n  fixes. We will (gently) encourage developers to move away from them and use\n  ForgeGradle 7 instead.\n- Many plugins that worked with ForgeGradle 6, such as Parchment's Librarian,\n  do not work with ForgeGradle 7. For most cases (such as parchment), we have\n  implemented native support. If ForgeGradle 7 is lacking in some aspect,\n  please let us know!\n- Many things that ForgeGradle 6 and older used to do are now decentralized\n  away from the plugin. This means that your project will need to apply\n  'net.minecraftforge.accesstransformers' if you wish to use AccessTransformers.\n  If you are on an older version (1.20.4 and older), you will need the\n  'net.minecraftforge.obfuscation' plugin. Many of these come with our provided\n  MDK, so this should not be an issue for you.\n\nThis message will not display again until ForgeGradle 7.1 or the below file is deleted:\n{}\n\nFor more details on this release, see https://docs.minecraftforge.net/en/fg-7.0/", new Object[]{markerFile.getAbsolutePath()});
        }

        static abstract class Parameters
        extends net.minecraftforge.gradle.ForgeGradleFlowAction$Parameters {
            final DirectoryProperty messagesDir = this.getObjects().directoryProperty();
            final Property<DisplayOption> displayOption = this.getObjects().property(DisplayOption.class).convention((Object)DisplayOption.ONCE).value(this.getProviders().gradleProperty("net.minecraftforge.gradle.messages.welcome").orElse(this.getProviders().systemProperty("net.minecraftforge.gradle.messages.welcome")).map(it -> DisplayOption.valueOf(it.toUpperCase(Locale.ROOT))));

            @Inject
            protected abstract ProviderFactory getProviders();

            @Inject
            public Parameters() {
            }
        }

        static enum DisplayOption {
            ONCE,
            NEVER,
            ALWAYS;

        }
    }

    static abstract class Parameters
    extends EnhancedFlowAction.EnhancedFlowParameters<ForgeGradleProblems> {
        protected Parameters() {
            super(ForgeGradleProblems.class);
        }
    }
}

