/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle;

import groovy.lang.Closure;
import groovy.transform.NamedParam;
import groovy.transform.NamedParams;
import java.io.File;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import net.minecraftforge.accesstransformers.gradle.AccessTransformersContainer;
import net.minecraftforge.gradle.ForgeGradleProblems;
import net.minecraftforge.gradle.MinecraftDependencyInternal;
import net.minecraftforge.gradle.MinecraftExtension;
import net.minecraftforge.gradle.MinecraftExtensionForProjectWithAccessTransformers;
import net.minecraftforge.gradle.MinecraftExtensionImpl;
import net.minecraftforge.gradle.MinecraftMappings;
import net.minecraftforge.gradle.shadow.net.minecraftforge.gradleutils.shared.Closures;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.nativeplatform.OperatingSystemFamily;
import org.jetbrains.annotations.UnknownNullability;

abstract class MinecraftDependencyImpl
implements MinecraftDependencyInternal {
    private static final String AT_COUNT_NAME = "fg_minecraft_atcontainers";
    private @UnknownNullability Provider<ExternalModuleDependency> delegate;
    private final ForgeGradleProblems problems;
    final Project project;
    private final Property<MinecraftMappings> mappings;

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract ProjectLayout getProjectLayout();

    @Inject
    protected abstract ProviderFactory getProviders();

    @Inject
    public MinecraftDependencyImpl(Project project) {
        this.project = project;
        this.problems = (ForgeGradleProblems)this.getObjects().newInstance(ForgeGradleProblems.class, new Object[0]);
        this.mappings = this.getObjects().property(MinecraftMappings.class).convention(((MinecraftExtensionImpl)project.getExtensions().getByName((String)"minecraft")).mappings);
    }

    @Override
    public Provider<ExternalModuleDependency> getDelegate() {
        return this.delegate;
    }

    Provider<ExternalModuleDependency> setDelegate(Object dependencyNotation, Closure<?> closure) {
        this.delegate = this.getObjects().property(ExternalModuleDependency.class).value(this.getProviders().provider(() -> (ExternalModuleDependency)this.project.getDependencies().create(dependencyNotation, Closures.function(dependency -> {
            if (!(dependency instanceof ExternalModuleDependency)) {
                throw this.problems.invalidMinecraftDependencyType((Dependency)dependency);
            }
            ExternalModuleDependency module = (ExternalModuleDependency)dependency;
            if (module.isChanging()) {
                throw this.problems.changingMinecraftDependency((Dependency)dependency);
            }
            Closures.invoke(this.closure(closure), module);
            MinecraftMappings mappings = this.getMappings();
            this.project.getConfigurations().forEach(configuration -> {
                if (!configuration.isCanBeDeclared()) {
                    return;
                }
                configuration.getDependencyConstraints().add((Object)this.project.getDependencies().getConstraints().create((Object)module.getModule().toString(), constraint -> {
                    constraint.because("Accounts for mappings used and natives variants");
                    constraint.attributes(attributes -> {
                        attributes.attribute(MinecraftExtension.Attributes.os, (Object)((OperatingSystemFamily)this.getObjects().named(OperatingSystemFamily.class, OperatingSystem.current().getFamilyName())));
                        attributes.attribute(MinecraftExtension.Attributes.mappingsChannel, (Object)mappings.channel());
                        attributes.attribute(MinecraftExtension.Attributes.mappingsVersion, (Object)mappings.version());
                    });
                }));
            });
            return module;
        }))));
        return this.delegate;
    }

    void resolve() {
        this.getDelegate().get();
    }

    @Override
    public void handle(SourceSet sourceSet) {
    }

    @Override
    public MinecraftMappings getMappings() {
        try {
            return (MinecraftMappings)this.mappings.get();
        }
        catch (IllegalStateException e) {
            throw this.problems.missingMappings(e);
        }
    }

    @Override
    public void mappings(String channel, String version) {
        MinecraftMappings.checkParam(this.problems, channel, "channel");
        MinecraftMappings.checkParam(this.problems, version, "version");
        this.mappings.set((Object)new MinecraftMappings(channel, version));
    }

    @Override
    public void mappings(@NamedParams(value={@NamedParam(type=String.class, value="channel", required=true), @NamedParam(type=String.class, value="version", required=true)}) Map<?, ?> namedArgs) {
        this.mappings(namedArgs.get("channel").toString(), namedArgs.get("version").toString());
    }

    static abstract class WithAccessTransformersImpl
    extends MinecraftDependencyImpl
    implements MinecraftDependencyInternal.WithAccessTransformers {
        private final AccessTransformersContainer atContainer;
        private final Property<String> atPath = this.getObjects().property(String.class);
        private @UnknownNullability Provider<ExternalModuleDependency> delegate;

        @Inject
        public WithAccessTransformersImpl(Project project) {
            super(project);
            this.atContainer = AccessTransformersContainer.register((Project)project, (Attribute)Attribute.of((String)("net.minecraftforge.gradle.accesstransformed." + this.postIncrementContainerCount()), Boolean.class), it -> {});
            this.atPath.convention(((MinecraftExtensionForProjectWithAccessTransformers)project.getExtensions().getByType(MinecraftExtensionForProjectWithAccessTransformers.class)).getAccessTransformers());
        }

        @Override
        public Provider<ExternalModuleDependency> getDelegate() {
            return this.delegate;
        }

        @Override
        Provider<ExternalModuleDependency> setDelegate(Object dependencyNotation, Closure<?> closure) {
            this.delegate = this.getObjects().property(ExternalModuleDependency.class).value(this.getProviders().provider(() -> {
                Provider<ExternalModuleDependency> dependency = super.setDelegate(dependencyNotation, closure);
                return this.atPath.isPresent() || this.getAccessTransformer().isPresent() ? (ExternalModuleDependency)this.atContainer.dep(dependency).get() : (ExternalModuleDependency)dependency.get();
            }));
            return this.delegate;
        }

        @Override
        public void handle(SourceSet sourceSet) {
            super.handle(sourceSet);
            if (!this.atPath.isPresent()) {
                return;
            }
            Iterator itor = sourceSet.getResources().getSrcDirs().iterator();
            if (itor.hasNext()) {
                this.getAccessTransformer().convention((RegularFile)this.getProjectLayout().file(this.getProviders().provider(() -> new File((File)itor.next(), (String)this.atPath.get()))).get());
            } else {
                this.getAccessTransformer().convention((RegularFile)this.getProjectLayout().getProjectDirectory().file(this.getProviders().provider(() -> "src/%s/resources/%s".formatted(sourceSet.getName(), this.atPath.get()))).get());
            }
        }

        private int getAtContainerCount() {
            try {
                return (Integer)this.project.getExtensions().getExtraProperties().get(MinecraftDependencyImpl.AT_COUNT_NAME);
            }
            catch (ExtraPropertiesExtension.UnknownPropertyException ignored) {
                this.setAtContainerCount(0);
                return 0;
            }
        }

        private void setAtContainerCount(int count) {
            this.project.getExtensions().getExtraProperties().set(MinecraftDependencyImpl.AT_COUNT_NAME, (Object)count);
        }

        private int postIncrementContainerCount() {
            int ret = this.getAtContainerCount();
            this.setAtContainerCount(ret + 1);
            return ret;
        }

        @Override
        public RegularFileProperty getAccessTransformer() {
            return this.atContainer.getOptions().getConfig();
        }

        @Override
        public void setAccessTransformer(String accessTransformer) {
            this.atPath.set((Object)accessTransformer);
        }

        @Override
        public void setAccessTransformer(boolean accessTransformer) {
            if (accessTransformer) {
                this.setAccessTransformer("META-INF/accesstransformer.cfg");
            } else {
                this.atPath.unsetConvention().unset();
            }
        }

        @Override
        public void accessTransformer(Action<? super AccessTransformersContainer.Options> options) {
            this.atContainer.options(options);
        }
    }
}

