/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.transform.stc.ClosureParams;
import groovy.transform.stc.SimpleType;
import javax.inject.Inject;
import net.minecraftforge.gradle.ForgeGradlePlugin;
import net.minecraftforge.gradle.ToolDefinition;
import net.minecraftforge.gradle.Tools;
import net.minecraftforge.gradle.ToolsExtensionInternal;
import net.minecraftforge.gradle.Util;
import net.minecraftforge.gradle.shadow.net.minecraftforge.gradleutils.shared.Closures;
import net.minecraftforge.gradle.shadow.net.minecraftforge.gradleutils.shared.Tool;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.jetbrains.annotations.Nullable;

abstract class ToolsExtensionImpl
implements ToolsExtensionInternal {
    private final ForgeGradlePlugin plugin;
    private final Project project;

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract ProviderFactory getProviders();

    static void register(ForgeGradlePlugin plugin, ExtensionAware target) {
        if (!(target instanceof Project)) {
            return;
        }
        ExtensionContainer extensions = target.getExtensions();
        extensions.create("fgtools", ToolsExtensionImpl.class, new Object[]{plugin, target});
    }

    @Inject
    public ToolsExtensionImpl(ForgeGradlePlugin plugin, Project project) {
        this.plugin = plugin;
        this.project = project;
        Tools.forEach(tool -> this.getExtensions().add(tool.getName(), (Object)new DefinitionImpl()));
    }

    Provider<FileCollection> getClasspath(Tool tool) {
        return this.getProviders().provider(() -> ((DefinitionImpl)this.getExtensions().getByName((String)tool.getName())).classpath);
    }

    Provider<String> getMainClass(Tool tool) {
        DefinitionImpl definition = (DefinitionImpl)this.getExtensions().getByName(tool.getName());
        return definition.mainClass;
    }

    Provider<String> getJavaLauncher(Tool tool) {
        DefinitionImpl definition = (DefinitionImpl)this.getExtensions().getByName(tool.getName());
        return definition.javaLauncher;
    }

    class DefinitionImpl
    implements ToolDefinition {
        @Nullable
        private FileCollection classpath;
        private final Property<String> mainClass;
        private final Property<String> javaLauncher;

        DefinitionImpl() {
            this.mainClass = ToolsExtensionImpl.this.getObjects().property(String.class);
            this.javaLauncher = ToolsExtensionImpl.this.getObjects().property(String.class);
        }

        @Override
        public void setClasspath(FileCollection files) {
            this.classpath = files;
        }

        @Override
        public void setClasspath(@DelegatesTo(value=DependencyHandler.class, strategy=1) @ClosureParams(value=SimpleType.class, options={"org.gradle.api.artifacts.dsl.DependencyHandler"}) Closure<? extends Dependency> dependency) {
            this.classpath = ToolsExtensionImpl.this.project.getConfigurations().detachedConfiguration(new Dependency[0]).withDependencies(dependencies -> dependencies.addLater(ToolsExtensionImpl.this.getProviders().provider(() -> (Dependency)Closures.invoke(dependency, ToolsExtensionImpl.this.project.getDependencies()))));
        }

        @Override
        public void setMainClass(Provider<String> mainClass) {
            this.mainClass.set(mainClass);
        }

        @Override
        public void setMainClass(String mainClass) {
            this.mainClass.set((Object)mainClass);
        }

        @Override
        public void setJavaLauncher(Provider<? extends JavaLauncher> javaLauncher) {
            this.javaLauncher.set(javaLauncher.map(Util.LAUNCHER_EXECUTABLE));
        }

        @Override
        public void setJavaLauncher(JavaLauncher javaLauncher) {
            this.setJavaLauncher((Provider<? extends JavaLauncher>)ToolsExtensionImpl.this.getProviders().provider(() -> javaLauncher));
        }
    }
}

