/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.transform.NamedParam;
import groovy.transform.NamedParams;
import groovy.transform.stc.ClosureParams;
import groovy.transform.stc.FromString;
import groovy.transform.stc.SimpleType;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import net.minecraftforge.gradle.ClosureOwner;
import net.minecraftforge.gradle.ForgeGradleFlowAction;
import net.minecraftforge.gradle.ForgeGradlePlugin;
import net.minecraftforge.gradle.ForgeGradleProblems;
import net.minecraftforge.gradle.MinecraftDependency;
import net.minecraftforge.gradle.MinecraftDependencyImpl;
import net.minecraftforge.gradle.MinecraftExtensionForProject;
import net.minecraftforge.gradle.MinecraftExtensionInternal;
import net.minecraftforge.gradle.MinecraftMappings;
import net.minecraftforge.gradle.SlimeLauncherExec;
import net.minecraftforge.gradle.SlimeLauncherOptions;
import net.minecraftforge.gradle.SlimeLauncherOptionsImpl;
import net.minecraftforge.gradle.SyncMinecraftMaven;
import net.minecraftforge.gradle.Util;
import net.minecraftforge.gradle.shadow.com.google.gson.reflect.TypeToken;
import net.minecraftforge.gradle.shadow.net.minecraftforge.util.data.json.JsonData;
import net.minecraftforge.gradle.shadow.net.minecraftforge.util.data.json.RunConfig;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectList;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ExternalModuleDependencyBundle;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.flow.FlowProviders;
import org.gradle.api.flow.FlowScope;
import org.gradle.api.initialization.Settings;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.reflect.TypeOf;

abstract class MinecraftExtensionImpl
implements MinecraftExtensionInternal {
    private static final String EXT_MAVEN_REPOS = "fg_mc_maven_repos";
    private static final String EXT_MAPPINGS = "fg_mc_mappings";
    final ForgeGradlePlugin plugin;
    final ForgeGradleProblems problems;
    final DirectoryProperty output;
    final Property<MinecraftMappings> mappings;

    @Inject
    protected abstract ObjectFactory getObjects();

    static void register(ForgeGradlePlugin plugin, ExtensionAware target) {
        ExtensionContainer extensions = target.getExtensions();
        if (target instanceof Project) {
            Project project = (Project)target;
            if (project.getPluginManager().hasPlugin("net.minecraftforge.accesstransformers")) {
                try {
                    extensions.create("minecraft", ForProjectImpl.WithAccessTransformersImpl.class, new Object[]{plugin, target});
                }
                catch (Exception e) {
                    throw ((ForgeGradleProblems)project.getObjects().newInstance(ForgeGradleProblems.class, new Object[0])).accessTransformersNotOnClasspath(e);
                }
            } else {
                extensions.create("minecraft", ForProjectImpl.class, new Object[]{plugin, target});
            }
        } else if (target instanceof Settings) {
            extensions.create("minecraft", ForSettingsImpl.class, new Object[]{plugin, target});
        } else {
            extensions.create("minecraft", MinecraftExtensionImpl.class, new Object[]{plugin});
        }
    }

    @Inject
    public MinecraftExtensionImpl(ForgeGradlePlugin plugin) {
        this.plugin = plugin;
        this.problems = (ForgeGradleProblems)this.getObjects().newInstance(ForgeGradleProblems.class, new Object[0]);
        this.output = this.getObjects().directoryProperty().convention(plugin.globalCaches().dir("mavenizer/output").map(this.problems.ensureFileLocation()));
        this.mappings = this.getObjects().property(MinecraftMappings.class);
    }

    @Override
    public TypeOf<?> getPublicType() {
        return MinecraftExtensionInternal.super.getPublicType();
    }

    @Override
    public Action<MavenArtifactRepository> getMaven() {
        return maven -> {
            maven.setName("MinecraftMaven");
            maven.setUrl((Object)this.output.getAsFile());
        };
    }

    @Override
    public MinecraftMappings getMappings() {
        try {
            return (MinecraftMappings)this.mappings.get();
        }
        catch (IllegalStateException e) {
            throw this.problems.missingMappings(e);
        }
    }

    @Override
    public void mappings(String channel, String version) {
        MinecraftMappings replacement = new MinecraftMappings(MinecraftMappings.checkParam(this.problems, channel, "channel"), MinecraftMappings.checkParam(this.problems, version, "version"));
        if (this.mappings.isPresent()) {
            this.problems.reportOverriddenMappings((MinecraftMappings)this.mappings.get(), replacement);
        }
        this.mappings.set((Object)replacement);
    }

    @Override
    public void mappings(@NamedParams(value={@NamedParam(type=String.class, value="channel", required=true), @NamedParam(type=String.class, value="version", required=true)}) Map<?, ?> namedArgs) {
        this.mappings(namedArgs.get("channel").toString(), namedArgs.get("version").toString());
    }

    static abstract class ForProjectImpl<T extends ClosureOwner<?> & MinecraftDependency>
    extends MinecraftExtensionImpl
    implements MinecraftExtensionInternal.ForProject<T> {
        private final Project project;
        private final NamedDomainObjectContainer<SlimeLauncherOptionsImpl> runs;
        private final MapProperty<String, RunConfig> configs;
        final List<MinecraftDependencyImpl> minecraftDependencies = new ArrayList<MinecraftDependencyImpl>();

        @Inject
        protected abstract FlowScope getFlowScope();

        @Inject
        protected abstract FlowProviders getFlowProviders();

        @Inject
        protected abstract ProjectLayout getProjectLayout();

        @Inject
        protected abstract ProviderFactory getProviders();

        @Inject
        protected abstract FileSystemOperations getFileSystemOperations();

        @Inject
        protected abstract ArchiveOperations getArchiveOperations();

        @Inject
        public ForProjectImpl(ForgeGradlePlugin plugin, Project project) {
            super(plugin);
            this.project = project;
            this.runs = this.getObjects().domainObjectContainer(SlimeLauncherOptionsImpl.class);
            this.configs = this.getObjects().mapProperty(String.class, RunConfig.class);
            ExtraPropertiesExtension ext = project.getExtensions().getExtraProperties();
            if (ext.has(MinecraftExtensionImpl.EXT_MAPPINGS)) {
                this.mappings.set((Object)((MinecraftMappings)ext.get(MinecraftExtensionImpl.EXT_MAPPINGS)));
            }
            this.getFlowScope().always(ForgeGradleFlowAction.AccessTransformersMissing.class, spec -> spec.parameters(parameters -> {
                parameters.getFailure().set(this.getFlowProviders().getBuildWorkResult().map(p -> p.getFailure().orElse(null)));
                parameters.appliedPlugin.set((Object)project.getPluginManager().hasPlugin("net.minecraftforge.accesstransformers"));
            }));
            project.afterEvaluate(this::finish);
        }

        @Override
        public TypeOf<?> getPublicType() {
            return new TypeOf<MinecraftExtensionForProject<ClosureOwner.MinecraftDependency>>(){};
        }

        void finish(Project project) {
            if (this.minecraftDependencies.isEmpty()) {
                this.problems.reportMissingMinecraftDependency();
                return;
            }
            this.minecraftDependencies.forEach(MinecraftDependencyImpl::resolve);
            SyncMinecraftMaven.register(project, this.minecraftDependencies);
            ExtraPropertiesExtension ext = project.getExtensions().getExtraProperties();
            AppliedRepos appliedRepos = ext.has(MinecraftExtensionImpl.EXT_MAVEN_REPOS) ? new AppliedRepos((List)ext.get(MinecraftExtensionImpl.EXT_MAVEN_REPOS)) : new AppliedRepos((List<? extends MavenArtifactRepository>)project.getRepositories().withType(MavenArtifactRepository.class));
            appliedRepos.check();
            DirectoryProperty sourceSetsDir = this.getObjects().directoryProperty().value(this.getProjectLayout().getBuildDirectory().dir("sourceSets"));
            ((JavaPluginExtension)this.project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets().configureEach(sourceSet -> {
                if (this.problems.test("net.minecraftforge.gradle.mergeSourceSets")) {
                    Provider unifiedDir = sourceSetsDir.dir(sourceSet.getName());
                    sourceSet.getOutput().setResourcesDir((Object)unifiedDir);
                    sourceSet.getJava().getDestinationDirectory().set(unifiedDir);
                }
                if (!this.runs.isEmpty()) {
                    Configuration runtimeClasspath = (Configuration)this.project.getConfigurations().findByName(sourceSet.getRuntimeClasspathConfigurationName());
                    DomainObjectSet allDependencies = runtimeClasspath != null ? runtimeClasspath.getAllDependencies().matching(it -> {
                        for (MinecraftDependencyImpl minecraftDependency : this.minecraftDependencies) {
                            if (!((ExternalModuleDependency)minecraftDependency.getDelegate().get()).equals(it)) continue;
                            return true;
                        }
                        return false;
                    }) : Set.of();
                    if (allDependencies.isEmpty()) {
                        throw new IllegalArgumentException("Cannot create run configurations without any Minecraft dependencies for " + sourceSet.getName());
                    }
                    if (allDependencies.size() > 1) {
                        throw new IllegalArgumentException("Cannot create run configurations for more than one Minecraft dependency");
                    }
                    ExternalModuleDependency dependency = (ExternalModuleDependency)this.minecraftDependencies.get(0).getDelegate().get();
                    Provider cacheDir = this.plugin.globalCaches().dir("slime-launcher/cache/%s/%s".formatted(dependency.getGroup().replace('.', '/'), dependency.getVersion())).map(this.problems.ensureFileLocation());
                    Provider metadataDir = this.getObjects().directoryProperty().value(cacheDir).dir("metadata").map(this.problems.ensureFileLocation());
                    Provider metadataZip = this.output.file(Util.artifactPath(dependency.getGroup(), dependency.getName(), dependency.getVersion(), "metadata", "zip"));
                    try {
                        this.getFileSystemOperations().copy(copy -> copy.from(new Object[]{this.getArchiveOperations().zipTree((Object)metadataZip)}).into((Object)metadataDir));
                        this.configs.set(this.getProviders().provider(() -> JsonData.fromJson(((Directory)metadataDir.get()).file("launcher/runs.json").getAsFile(), new TypeToken<Map<String, RunConfig>>(){})));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    this.runs.forEach(options -> SlimeLauncherExec.register(project, sourceSet, options, (Map)this.configs.getOrElse(Map.of()), (Dependency)dependency, (Provider<RegularFile>)metadataZip));
                }
            });
            this.getFlowScope().always(ForgeGradleFlowAction.WelcomeMessage.class, spec -> spec.parameters(parameters -> {
                parameters.getFailure().set(this.getFlowProviders().getBuildWorkResult().map(p -> p.getFailure().orElse(null)));
                parameters.messagesDir.set(this.plugin.globalCaches().dir("messages"));
                parameters.displayOption.set(this.getProviders().gradleProperty("net.minecraftforge.gradle.messages.welcome").orElse(this.getProviders().systemProperty("net.minecraftforge.gradle.messages.welcome")).map(it -> ForgeGradleFlowAction.WelcomeMessage.DisplayOption.valueOf(it.toUpperCase(Locale.ROOT))));
            }));
        }

        @Override
        public NamedDomainObjectContainer<? extends SlimeLauncherOptions> getRuns() {
            return this.runs;
        }

        @Override
        public void runs(@DelegatesTo(value=NamedDomainObjectContainer.class) @ClosureParams(value=FromString.class, options={"org.gradle.api.NamedDomainObjectContainer<net.minecraftforge.gradle.SlimeLauncherOptions>"}) Closure<?> closure) {
            this.runs.configure(closure);
        }

        Class<? extends MinecraftDependencyImpl> getMinecraftDependencyClass() {
            return MinecraftDependencyImpl.class;
        }

        @Override
        public Provider<ExternalModuleDependency> dep(Object value, @DelegatesTo(value=ExternalModuleDependency.class) @ClosureParams(value=SimpleType.class, options={"net.minecraftforge.gradle.MinecraftDependency.ClosureOwner"}) Closure<?> closure) {
            if (value instanceof ExternalModuleDependencyBundle) {
                throw new IllegalArgumentException("minecraft.dep does not support bundles");
            }
            MinecraftDependencyImpl minecraftDependency = (MinecraftDependencyImpl)this.getObjects().newInstance(this.getMinecraftDependencyClass(), new Object[]{this.project});
            this.minecraftDependencies.add(minecraftDependency);
            return minecraftDependency.setDelegate(value, closure);
        }

        private final class AppliedRepos {
            private final List<? extends MavenArtifactRepository> repos;
            private final boolean mcmaven;
            private final boolean forge;
            private final boolean mclibs;

            private AppliedRepos(List<? extends MavenArtifactRepository> repos) {
                this.repos = repos;
                this.mcmaven = this.containsExactly(ForProjectImpl.this.output.getAsFile());
                this.forge = this.contains("maven.minecraftforge.net");
                this.mclibs = this.contains("libraries.minecraft.net");
            }

            private boolean contains(String s) {
                for (MavenArtifactRepository mavenArtifactRepository : this.repos) {
                    if (!mavenArtifactRepository.getUrl().toString().contains(s)) continue;
                    return true;
                }
                return false;
            }

            private boolean containsExactly(Object object) {
                for (MavenArtifactRepository mavenArtifactRepository : this.repos) {
                    if (!mavenArtifactRepository.getUrl().equals(ForProjectImpl.this.project.uri(object))) continue;
                    return true;
                }
                return false;
            }

            private void check() {
                if (!this.mcmaven) {
                    ForProjectImpl.this.problems.reportMcMavenNotDeclared();
                }
                if (!this.forge) {
                    ForProjectImpl.this.problems.reportForgeMavenNotDeclared();
                }
                if (!this.mclibs) {
                    ForProjectImpl.this.problems.reportMcLibsMavenNotDeclared();
                }
            }
        }

        static abstract class WithAccessTransformersImpl
        extends ForProjectImpl<ClosureOwner.MinecraftDependencyWithAccessTransformers>
        implements MinecraftExtensionInternal.ForProject.WithAccessTransformers {
            @Inject
            public WithAccessTransformersImpl(ForgeGradlePlugin plugin, Project project) {
                super(plugin, project);
            }

            @Override
            public TypeOf<?> getPublicType() {
                return MinecraftExtensionInternal.ForProject.WithAccessTransformers.super.getPublicType();
            }

            @Override
            Class<? extends MinecraftDependencyImpl> getMinecraftDependencyClass() {
                return MinecraftDependencyImpl.WithAccessTransformersImpl.class;
            }
        }
    }

    static abstract class ForSettingsImpl
    extends MinecraftExtensionImpl {
        @Inject
        public ForSettingsImpl(ForgeGradlePlugin plugin, Settings settings) {
            super(plugin);
            settings.getGradle().settingsEvaluated(it -> {
                if (settings == it) {
                    this.finish((Settings)it);
                }
            });
        }

        private void finish(Settings settings) {
            NamedDomainObjectList repositories = settings.getDependencyResolutionManagement().getRepositories().withType(MavenArtifactRepository.class);
            settings.getGradle().beforeProject(project -> {
                if (!this.mappings.isPresent()) {
                    return;
                }
                ExtraPropertiesExtension ext = project.getExtensions().getExtraProperties();
                ext.set(MinecraftExtensionImpl.EXT_MAVEN_REPOS, (Object)repositories);
                ext.set(MinecraftExtensionImpl.EXT_MAPPINGS, this.mappings.get());
            });
        }
    }
}

