/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle;

import groovy.lang.Closure;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraftforge.gradle.Closures;
import org.gradle.TaskExecutionRequest;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.jetbrains.annotations.Nullable;

final class Util {
    Util() {
    }

    static Provider<JavaLauncher> launcherFor(JavaPluginExtension java, JavaToolchainService javaToolchains, int version) {
        return Util.launcherFor(java, javaToolchains, JavaLanguageVersion.of((int)version));
    }

    static Provider<JavaLauncher> launcherFor(JavaPluginExtension java, JavaToolchainService javaToolchains, JavaLanguageVersion version) {
        JavaToolchainSpec currentToolchain = java.getToolchain();
        return ((JavaLanguageVersion)currentToolchain.getLanguageVersion().getOrElse((Object)JavaLanguageVersion.current())).canCompileOrRun(version) ? javaToolchains.launcherFor(currentToolchain) : Util.launcherForStrictly(javaToolchains, version);
    }

    static Provider<JavaLauncher> launcherForStrictly(JavaToolchainService javaToolchains, int version) {
        return Util.launcherForStrictly(javaToolchains, JavaLanguageVersion.of((int)version));
    }

    static Provider<JavaLauncher> launcherForStrictly(JavaToolchainService javaToolchains, JavaLanguageVersion version) {
        return javaToolchains.launcherFor(spec -> spec.getLanguageVersion().set((Object)version));
    }

    static String artifactPath(String group, String name, String version, @Nullable String classifier, String extension) {
        return MessageFormat.format("{0}/{1}/{2}/{1}-{2}{3}.{4}", group.replace('.', '/'), name, version, classifier == null ? "" : "-" + classifier, extension);
    }

    @Nullable
    static <T extends Collection<?>> T nullIfEmpty(@Nullable T c) {
        return c == null || c.isEmpty() ? null : (T)c;
    }

    @Nullable
    static <T extends Map<?, ?>> T nullIfEmpty(@Nullable T m) {
        return m == null || m.isEmpty() ? null : (T)m;
    }

    @Nullable
    static String nullIfEmpty(@Nullable String s) {
        return s == null || s.isBlank() ? null : s;
    }

    @Nullable
    static String getProperty(ProviderFactory providers, String property) {
        return (String)providers.gradleProperty(property).orElse(providers.systemProperty(property)).getOrNull();
    }

    @Nullable
    static Boolean getBoolean(ProviderFactory providers, String property) {
        Boolean gradleBoolean = Util.getBoolean((Provider<? extends String>)providers.gradleProperty(property));
        return gradleBoolean != null ? gradleBoolean : Util.getBoolean((Provider<? extends String>)providers.systemProperty(property));
    }

    @Nullable
    private static Boolean getBoolean(Provider<? extends String> provider) {
        if (Boolean.TRUE.equals(provider.map("true"::equalsIgnoreCase).getOrNull())) {
            return true;
        }
        if (Boolean.FALSE.equals(provider.map("false"::equalsIgnoreCase).getOrNull())) {
            return false;
        }
        return null;
    }

    static boolean isTrue(ProviderFactory providers, String property) {
        return Util.isTrue((Provider<? extends String>)providers.gradleProperty(property)) || Util.isTrue((Provider<? extends String>)providers.systemProperty(property));
    }

    private static boolean isTrue(Provider<? extends String> provider) {
        return Boolean.TRUE.equals(Util.getBoolean(provider));
    }

    static boolean isFalse(ProviderFactory providers, String property) {
        return Util.isFalse((Provider<? extends String>)providers.gradleProperty(property)) || Util.isFalse((Provider<? extends String>)providers.systemProperty(property));
    }

    private static boolean isFalse(Provider<? extends String> provider) {
        return Boolean.FALSE.equals(Util.getBoolean(provider));
    }

    static <T> T tryElse(Callable<? extends T> value, T orElse) {
        try {
            return Objects.requireNonNull(value.call());
        }
        catch (Throwable e) {
            return orElse;
        }
    }

    static <T extends TaskProvider<?>> T runFirst(Project project, final T task) {
        ArrayList<1> requests = new ArrayList<1>(project.getGradle().getStartParameter().getTaskRequests());
        requests.add(0, new TaskExecutionRequest(){

            public List<String> getArgs() {
                return List.of(((Task)task.get()).getPath());
            }

            @Nullable
            public String getProjectPath() {
                return null;
            }

            @Nullable
            public File getRootDir() {
                return null;
            }
        });
        project.getLogger().info("Adding task to beginning of task graph! Project: {}, Task: {}", (Object)project.getName(), (Object)task.getName());
        project.getGradle().getStartParameter().setTaskRequests(requests);
        return task;
    }

    static <T> ActionableLazy<T> lazy(Callable<T> callable) {
        return Util.lazy(Closures.callable(callable));
    }

    static <T> ActionableLazy<T> lazy(Closure<T> closure) {
        return new ActionableLazy.Simple<T>(closure);
    }

    static String toString(ModuleVersionSelector module) {
        String version = module.getVersion();
        return "%s:%s%s".formatted(module.getGroup(), module.getName(), version != null ? ":" + version : "");
    }

    static String toString(Dependency dependency) {
        String string;
        String group = dependency.getGroup();
        String version = dependency.getVersion();
        String reason = dependency.getReason();
        Object[] objectArray = new Object[6];
        objectArray[0] = dependency.getClass().getName();
        objectArray[1] = group != null ? group + ":" : "";
        objectArray[2] = dependency.getName();
        objectArray[3] = version != null ? ":" + version : "";
        Object object = objectArray[4] = reason != null ? " (" + reason + ")" : "";
        if (dependency instanceof FileCollectionDependency) {
            FileCollectionDependency files = (FileCollectionDependency)dependency;
            Object[] objectArray2 = new Object[1];
            objectArray2[0] = String.join((CharSequence)", ", files.getFiles().getFiles().stream().map(File::getAbsolutePath).map(CharSequence.class::cast)::iterator);
            string = " [%s]".formatted(objectArray2);
        } else {
            string = "";
        }
        objectArray[5] = string;
        return "(%s) %s%s%s%s%s".formatted(objectArray);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static interface ActionableLazy<T>
    extends Supplier<T>,
    Callable<T> {
        default public ActionableLazy<T> orElse(ActionableLazy<T> ifAbsent) {
            return this.isPresent() ? this : ifAbsent;
        }

        public boolean isPresent();

        default public void ifPresent(Action<? super T> action) {
            if (this.isPresent()) {
                action.execute(this.get());
            }
        }

        public void map(Action<? super T> var1);

        public ActionableLazy<T> copy();

        @Override
        default public T call() {
            return this.get();
        }

        public static final class Simple<T>
        implements ActionableLazy<T> {
            private final Closure<T> closure;
            @Nullable
            private T value;
            private boolean present = false;
            private Closure<T> modifications = Closures.unaryOperator(UnaryOperator.identity());

            private Simple(Closure<T> closure) {
                this.closure = closure.compose(Closures.runnable(() -> {
                    this.present = true;
                }));
            }

            @Override
            public void map(Action<? super T> action) {
                this.present = true;
                this.modifications = this.modifications.andThen(Closures.unaryOperator(value -> {
                    action.execute(value);
                    return value;
                }));
            }

            @Override
            public boolean isPresent() {
                return this.present;
            }

            @Override
            public ActionableLazy<T> copy() {
                Simple<T> ret = new Simple<T>(this.closure);
                ret.value = this.value;
                ret.present = this.present;
                ret.modifications = this.modifications;
                return ret;
            }

            @Override
            public T get() {
                return this.value == null ? (this.value = Closures.invoke(this.closure.andThen(this.modifications))) : this.value;
            }
        }
    }
}

