/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.minecraftforge.gradle.ForgeGradleProblems;
import net.minecraftforge.gradle.ForgeGradleTask;
import net.minecraftforge.gradle.MinecraftDependency;
import net.minecraftforge.gradle.MinecraftExtension;
import net.minecraftforge.gradle.Tools;
import net.minecraftforge.gradle.Util;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.problems.Problems;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.process.ExecOperations;

abstract class SyncMinecraftMaven
extends DefaultTask
implements ForgeGradleTask {
    static final String NAME = "syncMinecraftMaven";
    private final ForgeGradleProblems problems;
    private final ExecOperations execOperations;

    static TaskProvider<SyncMinecraftMaven> register(Project project, Collection<? extends MinecraftDependency> requests) {
        return Util.runFirst(project, project.getTasks().register(NAME, SyncMinecraftMaven.class, task -> task.getRequests().addAll(Request.collect(requests))));
    }

    @Inject
    public SyncMinecraftMaven(Problems problems, ObjectFactory objects, ProviderFactory providers, ExecOperations execOperations) {
        this.problems = new ForgeGradleProblems(problems, providers);
        this.execOperations = execOperations;
        this.setGroup("Build Setup");
        this.setDescription("Syncs the Minecraft dependencies using Minecraft Mavenizer.");
        this.getExecutable().convention(new Object[]{this.getTool(Tools.MINECRAFT_MAVEN)});
        this.getJavaLauncher().convention(Util.launcherForStrictly((JavaToolchainService)this.getProject().getExtensions().getByType(JavaToolchainService.class), 21).map(j -> j.getExecutablePath().toString()));
        this.getMainClass().convention((Object)"net.minecraftforge.mcmaven.cli.Main");
        DirectoryProperty defaultDirectory = objects.directoryProperty().value(this.getGlobalCaches().dir("mavenizer").map(this.problems.ensureDirectory()));
        this.getCaches().convention(defaultDirectory.dir("cache").map(this.problems.ensureDirectory()));
        this.getOutput().convention(defaultDirectory.dir("output").map(this.problems.ensureDirectory()));
        this.onlyIf("Minecraft Mavenizer will not run if no Minecraft dependencies are present.", task -> {
            SetProperty<Request> requests = ((SyncMinecraftMaven)task).getRequests();
            return requests.isPresent() && !((Set)requests.get()).isEmpty();
        });
    }

    @TaskAction
    public void exec() {
        ((Set)this.getRequests().get()).forEach(this::exec);
    }

    private void exec(Request request) {
        this.execOperations.javaexec(spec -> {
            spec.setClasspath((FileCollection)this.getExecutable());
            spec.setExecutable((String)this.getJavaLauncher().get());
            spec.getMainClass().set(this.getMainClass());
            spec.setArgs(this.argsFor(request));
        }).rethrowFailure();
    }

    private List<String> argsFor(Request request) {
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(List.of("--maven", "--cache", ((Directory)this.getCaches().get()).getAsFile().getAbsolutePath(), "--output", ((Directory)this.getOutput().get()).getAsFile().getAbsolutePath(), "--jdk-cache", ((Directory)this.getCaches().dir("jdks").get()).getAsFile().getAbsolutePath(), "--artifact", request.module, "--version", request.version));
        if ("parchment".equals(request.mappings.channel())) {
            args.add("--parchment");
            args.add(request.mappings.version());
        }
        return args;
    }

    @Classpath
    protected abstract ConfigurableFileCollection getExecutable();

    @Input
    protected abstract Property<String> getJavaLauncher();

    @Input
    protected abstract Property<String> getMainClass();

    @InputDirectory
    protected abstract DirectoryProperty getCaches();

    @InputDirectory
    protected abstract DirectoryProperty getOutput();

    @Input
    @Optional
    protected abstract SetProperty<Request> getRequests();

    public record Request(String module, String version, MinecraftExtension.Mappings mappings) implements Serializable
    {
        public Request(MinecraftDependency module) {
            this("%s:%s".formatted(module.getGroup(), module.getName()), Objects.requireNonNull(module.getVersion(), "Minecraft artifact must have a version"), Objects.requireNonNull(module.getMappings(), "Minecraft dependencies are not finished"));
        }

        private static Set<Request> collect(Collection<? extends MinecraftDependency> requests) {
            return requests.stream().map(Request::new).collect(Collectors.toSet());
        }
    }
}

