/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle;

import java.io.File;
import java.util.Arrays;
import java.util.Map;
import javax.inject.Inject;
import net.minecraftforge.gradle.SlimeLauncherExec;
import net.minecraftforge.gradle.Util;
import org.gradle.api.Named;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class SlimeLauncherOptions
implements Named {
    private final String name;
    @Input
    @Optional
    private final Property<String> mainClass;
    @Input
    @Optional
    private final ListProperty<String> args;
    @Input
    @Optional
    private final ListProperty<String> jvmArgs;
    @InputFiles
    @Optional
    @Classpath
    @Nullable
    private FileCollection classpath;
    @Input
    @Optional
    private final Property<String> minHeapSize;
    @Input
    @Optional
    private final Property<String> maxHeapSize;
    @Input
    @Optional
    private final MapProperty<String, Object> systemProperties;
    @Input
    @Optional
    private final MapProperty<String, Object> environment;
    @InputDirectory
    private final DirectoryProperty workingDir;

    public final String getName() {
        return this.name;
    }

    @Input
    @Optional
    public final Property<String> getMainClass() {
        return this.mainClass;
    }

    @Input
    @Optional
    public final ListProperty<String> getArgs() {
        return this.args;
    }

    @Input
    @Optional
    public final ListProperty<String> getJvmArgs() {
        return this.jvmArgs;
    }

    @InputFiles
    @Optional
    @Classpath
    public final FileCollection getClasspath() {
        return this.classpath == null ? (this.classpath = this.getObjects().fileCollection()) : this.classpath;
    }

    @Input
    @Optional
    public final Property<String> getMinHeapSize() {
        return this.minHeapSize;
    }

    @Input
    @Optional
    public final Property<String> getMaxHeapSize() {
        return this.maxHeapSize;
    }

    @Input
    @Optional
    public final MapProperty<String, Object> getSystemProperties() {
        return this.systemProperties;
    }

    @Input
    @Optional
    public final MapProperty<String, Object> getEnvironment() {
        return this.environment;
    }

    @InputDirectory
    public final DirectoryProperty getWorkingDir() {
        return this.workingDir;
    }

    public final void setMainClass(String mainClass) {
        this.getMainClass().set((Object)mainClass);
    }

    public final void setMainClass(Provider<String> mainClass) {
        this.getMainClass().set(mainClass);
    }

    public final void args(String args) {
        this.getArgs().add((Object)args);
    }

    public final void args(String ... args) {
        this.getArgs().addAll((Object[])args);
    }

    public final void args(Iterable<String> args) {
        this.getArgs().addAll(args);
    }

    public final void args(Provider<? extends Iterable<String>> args) {
        this.getArgs().addAll(args);
    }

    public final void setArgs(String ... args) {
        this.getArgs().set(Arrays.asList(args));
    }

    public final void setArgs(Iterable<String> args) {
        this.getArgs().set(args);
    }

    public final void setArgs(Provider<? extends Iterable<String>> args) {
        this.getArgs().set(args);
    }

    public final void jvmArgs(String jvmArgs) {
        this.getJvmArgs().add((Object)jvmArgs);
    }

    public final void jvmArgs(String ... jvmArgs) {
        this.getJvmArgs().addAll((Object[])jvmArgs);
    }

    public final void jvmArgs(Iterable<String> jvmArgs) {
        this.getJvmArgs().addAll(jvmArgs);
    }

    public final void jvmArgs(Provider<? extends Iterable<String>> jvmArgs) {
        this.getJvmArgs().addAll(jvmArgs);
    }

    public final void setJvmArgs(String ... jvmArgs) {
        this.getJvmArgs().set(Arrays.asList(jvmArgs));
    }

    public final void setJvmArgs(Iterable<String> jvmArgs) {
        this.getJvmArgs().set(jvmArgs);
    }

    public final void setJvmArgs(Provider<? extends Iterable<String>> jvmArgs) {
        this.getJvmArgs().set(jvmArgs);
    }

    public final void classpath(Object ... classpath) {
        this.classpath((FileCollection)this.getObjects().fileCollection().from(classpath));
    }

    public final void classpath(Iterable<?> classpath) {
        this.classpath((FileCollection)this.getObjects().fileCollection().from(new Object[]{classpath}));
    }

    public final void classpath(Provider<? extends Iterable<?>> classpath) {
        this.classpath((FileCollection)this.getObjects().fileCollection().from(new Object[]{classpath}));
    }

    public final void classpath(FileCollection classpath) {
        this.getClasspath().plus(classpath);
    }

    public final void setClasspath(Object ... classpath) {
        this.setClasspath((FileCollection)this.getObjects().fileCollection().from(classpath));
    }

    public final void setClasspath(Iterable<?> classpath) {
        this.setClasspath((FileCollection)this.getObjects().fileCollection().from(new Object[]{classpath}));
    }

    public final void setClasspath(Provider<? extends Iterable<?>> classpath) {
        this.setClasspath((FileCollection)this.getObjects().fileCollection().from(new Object[]{classpath.get()}));
    }

    public final void setClasspath(FileCollection classpath) {
        this.classpath = classpath;
    }

    public final void setMinHeapSize(String minHeapSize) {
        this.getMinHeapSize().set((Object)minHeapSize);
    }

    public final void setMinHeapSize(Property<String> minHeapSize) {
        this.getMinHeapSize().set(minHeapSize);
    }

    public final void setMaxHeapSize(String maxHeapSize) {
        this.getMaxHeapSize().set((Object)maxHeapSize);
    }

    public final void setMaxHeapSize(Property<String> maxHeapSize) {
        this.getMaxHeapSize().set(maxHeapSize);
    }

    public final void systemProperty(String name, Object value) {
        this.getSystemProperties().put((Object)name, value);
    }

    public final void systemProperties(Map<String, ?> properties) {
        this.getSystemProperties().putAll(properties);
    }

    public final void systemProperties(Provider<? extends Map<String, ?>> properties) {
        this.getSystemProperties().putAll(properties);
    }

    public final void setSystemProperties(Map<String, ?> properties) {
        this.getSystemProperties().set(properties);
    }

    public final void setSystemProperties(Provider<? extends Map<String, ?>> properties) {
        this.getSystemProperties().set(properties);
    }

    public final void environment(String name, Object value) {
        this.getEnvironment().put((Object)name, value);
    }

    public final void environment(Map<String, ?> properties) {
        this.getEnvironment().putAll(properties);
    }

    public final void environment(Provider<? extends Map<String, ?>> properties) {
        this.getEnvironment().putAll(properties);
    }

    public final void setEnvironment(Map<String, ?> environment) {
        this.getEnvironment().set(environment);
    }

    public final void setEnvironment(Provider<? extends Map<String, ?>> environment) {
        this.getEnvironment().set(environment);
    }

    public final void setWorkingDir(File workingDir) {
        if (!workingDir.isDirectory()) {
            throw new IllegalStateException("The working directory must be a directory: " + String.valueOf(workingDir));
        }
        this.getWorkingDir().fileValue(workingDir);
    }

    public final void setWorkingDir(Directory workingDir) {
        this.getWorkingDir().set((Object)workingDir);
    }

    public final void setWorkingDir(Provider<? extends Directory> workingDir) {
        this.getWorkingDir().set(workingDir);
    }

    private SlimeLauncherOptions(String name) {
        this.name = name;
        this.mainClass = this.getObjects().property(String.class);
        this.args = this.getObjects().listProperty(String.class);
        this.jvmArgs = this.getObjects().listProperty(String.class);
        this.minHeapSize = this.getObjects().property(String.class);
        this.maxHeapSize = this.getObjects().property(String.class);
        this.systemProperties = this.getObjects().mapProperty(String.class, Object.class);
        this.environment = this.getObjects().mapProperty(String.class, Object.class);
        this.workingDir = this.getObjects().directoryProperty().convention(this.getLayout().getProjectDirectory().dir("run").dir(name));
    }

    abstract ObjectFactory getObjects();

    abstract ProjectLayout getLayout();

    static NamedDomainObjectContainer<SlimeLauncherOptions> container(ObjectFactory objects, ProjectLayout layout) {
        return objects.domainObjectContainer(SlimeLauncherOptions.class, name -> (SlimeLauncherOptions)objects.newInstance(Impl.class, new Object[]{name}));
    }

    final void apply(SlimeLauncherExec task) {
        if (this.mainClass.map(Util::nullIfEmpty).isPresent()) {
            task.getBootstrapMainClass().set(this.mainClass);
        }
        if (this.args.map(Util::nullIfEmpty).isPresent()) {
            task.getMcBootstrapArgs().set(this.args);
        }
        if (this.jvmArgs.map(Util::nullIfEmpty).isPresent()) {
            task.jvmArgs((Iterable)this.jvmArgs.get());
        }
        if (this.classpath != null && !this.classpath.isEmpty()) {
            task.setClasspath(this.classpath);
        }
        if (this.minHeapSize.map(Util::nullIfEmpty).isPresent()) {
            task.setMinHeapSize((String)this.minHeapSize.get());
        }
        if (this.maxHeapSize.map(Util::nullIfEmpty).isPresent()) {
            task.setMinHeapSize((String)this.maxHeapSize.get());
        }
        if (this.systemProperties.map(Util::nullIfEmpty).isPresent()) {
            task.systemProperties((Map)this.systemProperties.get());
        }
        if (this.environment.map(Util::nullIfEmpty).isPresent()) {
            task.environment((Map)this.environment.get());
        }
        if (this.workingDir.isPresent()) {
            task.workingDir(this.workingDir);
        }
    }

    static abstract class Impl
    extends SlimeLauncherOptions {
        @Inject
        public Impl(String name) {
            super(name);
        }

        @Override
        @Inject
        protected abstract ObjectFactory getObjects();

        @Override
        @Inject
        protected abstract ProjectLayout getLayout();
    }
}

