/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.transform.Generated;
import groovy.transform.NamedParam;
import groovy.transform.NamedParams;
import groovy.transform.stc.ClosureParams;
import groovy.transform.stc.SimpleType;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import net.minecraftforge.accesstransformers.gradle.AccessTransformersContainer;
import net.minecraftforge.gradle.Closures;
import net.minecraftforge.gradle.ForgeGradleProblems;
import net.minecraftforge.gradle.MinecraftDependency;
import net.minecraftforge.gradle.MinecraftExtensionImpl;
import net.minecraftforge.gradle.SlimeLauncherOptions;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderConvertible;
import org.gradle.nativeplatform.OperatingSystemFamily;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.UnknownNullability;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface MinecraftExtension {
    public static final String NAME = "minecraft";
    public static final Attributes attributes = new MinecraftExtensionImpl.AttributesImpl();

    public Closure getMaven();

    default public MavenArtifactRepository maven(RepositoryHandler repositories) {
        return repositories.maven(this.getMaven());
    }

    public Mappings getMappings();

    public void mappings(String var1, String var2);

    @Generated
    @Contract
    default public void mappings(@NamedParams(value={@NamedParam(type=String.class, value="channel", required=true), @NamedParam(type=String.class, value="version", required=true)}) Map namedArgs) {
        throw new IllegalStateException("Groovy did not generate MinecraftExtension.mappings(Map)");
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Attributes {
        public static final Attribute<OperatingSystemFamily> os = Attribute.of((String)"net.minecraftforge.native.operatingSystem", OperatingSystemFamily.class);
        public static final Attribute<String> mappingsChannel = Attribute.of((String)"net.minecraftforge.mappings.channel", String.class);
        public static final Attribute<String> mappingsVersion = Attribute.of((String)"net.minecraftforge.mappings.version", String.class);
    }

    public record Mappings(String channel, String version) implements Serializable
    {
        public Mappings(String channel, String version) {
            this.channel = Objects.requireNonNull(channel, "Mappings channel cannot be null");
            this.version = Objects.requireNonNull(version, "Mappings version cannot be null");
        }

        static void checkParam(ForgeGradleProblems problems, @UnknownNullability Object param, String name) {
            if (param == null) {
                throw problems.nullMappingsParam(name);
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ForProject
    extends MinecraftExtension {
        public void setAccessTransformer(RegularFile var1);

        public void setAccessTransformer(File var1);

        public void setAccessTransformer(Object var1);

        public void setAccessTransformer(Provider<?> var1);

        default public void accessTransformer(Action<? super AccessTransformersContainer.Options> options) {
            this.accessTransformer(Closures.action(this, options));
        }

        public void accessTransformer(@DelegatesTo(value=AccessTransformersContainer.Options.class, strategy=1) @ClosureParams(value=SimpleType.class, options={"net.minecraftforge.accesstransformers.gradle.AccessTransformersContainer.Options"}) Closure var1);

        public NamedDomainObjectContainer<SlimeLauncherOptions> getRuns();

        public void runs(@DelegatesTo(value=NamedDomainObjectContainer.class) @ClosureParams(value=SimpleType.class, options={"org.gradle.api.NamedDomainObjectContainer<net.minecraftforge.gradle.SlimeLauncherOptions>"}) Closure<Void> var1);

        default public void runs(Action<? super NamedDomainObjectContainer<SlimeLauncherOptions>> action) {
            this.runs(Closures.action(this, action));
        }

        public MinecraftDependency dep(Object var1, @DelegatesTo(value=MinecraftDependency.class, strategy=1) @ClosureParams(value=SimpleType.class, options={"net.minecraftforge.gradle.MinecraftDependency"}) Closure var2);

        default public MinecraftDependency dep(Object value, Action<? super MinecraftDependency> action) {
            return this.dep(value, Closures.action(this, action));
        }

        default public MinecraftDependency dep(Object value) {
            return this.dep(value, Closures.empty(this));
        }

        default public MinecraftDependency dep(Provider<?> value, @DelegatesTo(value=MinecraftDependency.class, strategy=1) @ClosureParams(value=SimpleType.class, options={"net.minecraftforge.gradle.MinecraftDependency"}) Closure closure) {
            return this.dep(value.get(), closure);
        }

        default public MinecraftDependency dep(Provider<?> value, Action<? super MinecraftDependency> action) {
            return this.dep(value, Closures.action(this, action));
        }

        default public MinecraftDependency dep(Provider<?> value) {
            return this.dep(value, Closures.empty(this));
        }

        default public MinecraftDependency dep(ProviderConvertible<?> value, @DelegatesTo(value=MinecraftDependency.class, strategy=1) @ClosureParams(value=SimpleType.class, options={"net.minecraftforge.gradle.MinecraftDependency"}) Closure closure) {
            return this.dep(value.asProvider(), closure);
        }

        default public MinecraftDependency dep(ProviderConvertible<?> value, Action<? super MinecraftDependency> action) {
            return this.dep(value, Closures.action(this, action));
        }

        default public MinecraftDependency dep(ProviderConvertible<?> value) {
            return this.dep(value, Closures.empty(this));
        }
    }
}

