/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import net.minecraftforge.gradle.ForgeGradlePlugin;
import net.minecraftforge.gradle.MinecraftExtension;
import net.minecraftforge.gradle.Util;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.file.Directory;
import org.gradle.api.problems.Problem;
import org.gradle.api.problems.ProblemGroup;
import org.gradle.api.problems.ProblemId;
import org.gradle.api.problems.ProblemReporter;
import org.gradle.api.problems.ProblemSpec;
import org.gradle.api.problems.Problems;
import org.gradle.api.problems.Severity;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.jetbrains.annotations.UnknownNullability;

record ForgeGradleProblems(Problems problems, Predicate<String> properties) implements Problems
{
    private static final ProblemGroup GROUP = ProblemGroup.create((String)"forgegradle", (String)"ForgeGradle");
    private static final String HELP_MESSAGE = "Consult the documentation or ask for help on the Forge Forums, GitHub, or Discord server.";

    ForgeGradleProblems(Problems problems, ProviderFactory providers) {
        this(problems, (String property) -> ForgeGradleProblems.hasProperty(providers, property));
    }

    ForgeGradleProblems(Callable<? extends @UnknownNullability Problems> problems, Callable<? extends @UnknownNullability ProviderFactory> providers) {
        this(ForgeGradleProblems.unwrapProblems(problems), ForgeGradleProblems.unwrapProperties(providers));
    }

    public ProblemReporter getReporter() {
        return this.problems.getReporter();
    }

    private static Problems unwrapProblems(Callable<? extends @UnknownNullability Problems> supplier) {
        return Util.tryElse(supplier, EmptyReporter.AS_PROBLEMS);
    }

    private static Predicate<String> unwrapProperties(Callable<? extends @UnknownNullability ProviderFactory> supplier) {
        return Util.tryElse(() -> {
            ProviderFactory providers = Objects.requireNonNull((ProviderFactory)supplier.call());
            return property -> ForgeGradleProblems.hasProperty(providers, property);
        }, Boolean::getBoolean);
    }

    private static boolean hasProperty(ProviderFactory providers, String property) {
        return Util.isTrue((Provider<? extends String>)providers.gradleProperty(property)) || Util.isTrue((Provider<? extends String>)providers.systemProperty(property));
    }

    private static ProblemId id(String name, String displayName) {
        return ProblemId.create((String)name, (String)displayName, (ProblemGroup)GROUP);
    }

    RuntimeException illegalPluginTarget(Exception e) {
        return this.getReporter().throwing((Throwable)e, ForgeGradleProblems.id("invalid-plugin-target", "Invalid plugin target"), spec -> spec.details("Attempted to apply the ForgeGradle plugin to an invalid target.\nForgeGradle can only be applied on the project, the settings, or Gradle.").severity(Severity.ERROR).stackLocation().solution("Use a valid plugin target (Project, Settings, Gradle)").solution(HELP_MESSAGE));
    }

    RuntimeException missingMappings(Throwable throwable) {
        return this.getReporter().throwing(throwable, ProblemId.create((String)"missing-mappings", (String)"Missing Minecraft mappings", (ProblemGroup)GROUP), spec -> spec.details("Attempted to consume Minecraft mappings, but none were declared.\nMinecraft dependencies cannot be resolved without mappings.").severity(Severity.ERROR).stackLocation().solution("Declare mappings in your buildscript in the minecraft {} closure, such as `mappings channel: 'official', version: '1.21.5'`.").solution("Move the minecraft {} closure above the dependencies {} closure in your buildscript.").solution(HELP_MESSAGE));
    }

    RuntimeException nullMappingsParam(String name) {
        return this.getReporter().throwing((Throwable)new IllegalArgumentException("Mappings %s cannot be null".formatted(name)), ForgeGradleProblems.id("null-mappings-param", "Null mappings parameter"), spec -> spec.details("Attempted to create a Mappings object, but the %s parameter was null.\nThe parameters for the Mappings object are not null.".formatted(name)).severity(Severity.ERROR).stackLocation().solution("Do not pass in any null values to the mappings constructor or MinecraftExtension#mappings.").solution(HELP_MESSAGE));
    }

    void reportOverriddenMappings(MinecraftExtension.Mappings original, MinecraftExtension.Mappings replacement) {
        if (!this.properties.test("net.minecraftforge.gradle.warnings.overriddenMappings")) {
            return;
        }
        String comparison = "Old: (channel: %s, version: %s), New: (channel: %s, version: %s)".formatted(original.channel(), original.version(), replacement.channel(), replacement.version());
        ForgeGradlePlugin.LOGGER.warn("WARNING: Overriding previously declared mappings! {}", (Object)comparison);
        this.getReporter().report(ForgeGradleProblems.id("multiple-mappings", "Multiple mappings declared"), spec -> spec.details("Mappings are being set, even though they have already been declared.\nThis will cause the current mappings to be overridden, which may lead to unexpected behavior.\n" + comparison).severity(Severity.WARNING).stackLocation().solution("Declare mappings only once in your buildscript.").solution("Do not attempt to re-declare mappings in a loop or closure. Instead, evaluate the channel and version you want, then declare mappings using them."));
    }

    void reportMissingMinecraftDependency() {
        if (!this.properties.test("net.minecraftforge.gradle.warnings.missingMinecraftDependency")) {
            return;
        }
        ForgeGradlePlugin.LOGGER.error("ERROR: No Minecraft dependency declared! Disabling ForgeGradle. See Problems report for details.");
        this.getReporter().report(ForgeGradleProblems.id("missing-dependency", "Missing Minecraft dependency"), spec -> spec.details("ForgeGradle was applied, but no Minecraft dependency was declared.\nForgeGradle will now be disabled and stop all further registrations.").severity(Severity.ERROR).stackLocation().solution("Declare a Minecraft dependency in your build.gradle file, such as `implementation minecraft.dep('net.minecraftforge:forge:1.21.5-55.0.3')`").solution("Ensure that your Minecraft dependency is declared using the `minecraft.dep(...)` method.").solution("Ensure that your buildscript with your dependencies is being loaded correctly.").solution("Do not apply ForgeGradle if you are not planning on developing for Minecraft.").solution(HELP_MESSAGE));
    }

    RuntimeException invalidMinecraftDependencyType(Dependency dependency) {
        return this.getReporter().throwing((Throwable)new IllegalArgumentException("Minecraft dependency is not a module dependency"), ForgeGradleProblems.id("unsupported-minecraft-dependency-type", "Non-module dependency used as Minecraft dependency"), spec -> spec.details("Attempted to use a non-module (or internal module) dependency as a Minecraft dependency.\nThe Minecraft dependency must be an external module dependency, as it is resolved from the Minecraft Maven.\nThis means that it cannot be substituted with file or project dependencies.\nExpected: (implementation of) %s, Actual: '%s\nDependency: '%s'".formatted(ExternalModuleDependency.class.getName(), dependency.getClass().getName(), ForgeGradleProblems.depToString(dependency))).severity(Severity.ERROR).stackLocation().solution("Declare a module dependency instead.").solution(HELP_MESSAGE));
    }

    @Deprecated(forRemoval=true)
    void reportMissingMetadata(Throwable throwable) {
        this.getReporter().report(ForgeGradleProblems.id("missing-metadata", "Failed to extract metadata"), spec -> spec.details("ForgeGradle failed to locate or extract the metadata generated for the Minecraft dependency.\nThis is expected if the Minecraft Maven has not yet been synced.\nIf you are seeing this after your first project sync, please report this as it might be a ForgeGradle bug.").severity(Severity.WARNING).withException(throwable).stackLocation().solution("Re-run the synchronization for your Gradle project.").solution("Manually run the syncMinecraftMaven task if necessary.").solution(HELP_MESSAGE));
    }

    RuntimeException multipleMinecraftDependencies(Dependency current, Dependency replacement) {
        return this.getReporter().throwing((Throwable)new IllegalArgumentException("Cannot have more than one Minecraft dependency"), ForgeGradleProblems.id("multiple-minecraft-dependencies", "Multiple Minecraft dependencies declared"), spec -> spec.details("Attempted to use multiple Minecraft dependencies. Only one can be declared\nCurrent: %s, Replacement: '%s'".formatted(ForgeGradleProblems.depToString(current), ForgeGradleProblems.depToString(replacement))).severity(Severity.ERROR).stackLocation().solution("Declare only one Minecraft dependency using `minecraft.dep(...)`.").solution(HELP_MESSAGE));
    }

    RuntimeException changingMinecraftDependency(Dependency dependency) {
        return this.getReporter().throwing((Throwable)new IllegalArgumentException("Minecraft dependency cannot be changing"), ForgeGradleProblems.id("changing-minecraft-dependency", "Minecraft dependency marked as changing"), spec -> spec.details("Attempted to use a Minecraft dependency that was marked as changing.\nThis is currently unsupported.\nDependency: %s".formatted(ForgeGradleProblems.depToString(dependency))).severity(Severity.ERROR).solution("Do not mark the Minecraft dependency as changing.").solution(HELP_MESSAGE));
    }

    private static String depToString(Dependency dependency) {
        String string;
        String group = dependency.getGroup();
        String version = dependency.getVersion();
        String reason = dependency.getReason();
        Object[] objectArray = new Object[6];
        objectArray[0] = dependency.getClass().getName();
        objectArray[1] = group != null ? group + ":" : "";
        objectArray[2] = dependency.getName();
        objectArray[3] = version != null ? ":" + version : "";
        Object object = objectArray[4] = reason != null ? " (" + reason + ")" : "";
        if (dependency instanceof FileCollectionDependency) {
            FileCollectionDependency files = (FileCollectionDependency)dependency;
            Object[] objectArray2 = new Object[1];
            objectArray2[0] = String.join((CharSequence)", ", files.getFiles().getFiles().stream().map(File::getAbsolutePath).map(CharSequence.class::cast)::iterator);
            string = " [%s]".formatted(objectArray2);
        } else {
            string = "";
        }
        objectArray[5] = string;
        return "(%s) %s%s%s%s%s".formatted(objectArray);
    }

    void reportMcMavenNotDeclared() {
        this.getReporter().report(ForgeGradleProblems.id("minecraft-maven-not-declared", "Minecraft Maven not declared"), spec -> spec.details("ForgeGradle was configured to sync the Minecraft Maven, but it was not declared as a repository!\nThis will result in a \"cannot resolve dependency\" error.").severity(Severity.ERROR).solution("Declare the Miencraft Maven (`minecraft.maven`) in your project/settings repositories.").solution(HELP_MESSAGE));
    }

    void reportMcLibsMavenNotDeclared() {
        this.getReporter().report(ForgeGradleProblems.id("minecraft-libs-maven-not-declared", "Minecraft Libraries maven not declared"), spec -> spec.details("ForgeGradle was configured to sync the Minecraft Maven, but the Minecraft Libraries maven was not declared!\nThe generated Minecraft artifact has dependencies from libraries that may only exist on there.\nThis may result in a \"cannot resolve dependency\" error.").severity(Severity.WARNING).solution("Declare the Minecraft Libs maven (`fg.minecraftLibsMaven`) in your project/settings repositories.").solution(HELP_MESSAGE));
    }

    void reportForgeMavenNotDeclared() {
        this.getReporter().report(ForgeGradleProblems.id("forge-maven-not-declared", "Forge maven not declared"), spec -> spec.details("ForgeGradle was configured to sync the Minecraft Maven, but the Forge maven was not declared!\nThe generated Minecraft artifact has dependencies from libraries that may only exist on there.\nThis may result in a \"cannot resolve dependency\" error.").severity(Severity.WARNING).solution("Declare the Forge maven (`fg.forgeMaven`) in your project/settings repositories.").solution(HELP_MESSAGE));
    }

    void reportMcMavenNotFound(Throwable e) {
        this.getReporter().report(ForgeGradleProblems.id("minecraft-maven-not-found", "Minecraft Maven not found"), spec -> spec.details("Attempted to sync the Minecraft Maven, but the Minecraft Mavenizer tool was not found!").withException(e).severity(Severity.ERROR).solution("Ensure that the Forge Maven (`fg.forgeMaven`) exists in your project/settings repositories.").solution("If you are using a custom tool, ensure that you added your repository and it is up and running.").solution(HELP_MESSAGE));
    }

    RuntimeException invalidDeobfDependencyType(Dependency dependency) {
        return this.getReporter().throwing((Throwable)new IllegalArgumentException("Non-module dependencies are not currently supported"), ForgeGradleProblems.id("unsupported-dependency-type", "Non-module dependency used as Minecraft/deobf dependency"), spec -> spec.details("Attempted to use a non-module dependency as a deobf dependency, which is currently unsupported.\nSupport for file dependencies will come at a later time. Project dependencies are not supported.\nExpected: (implementation of) %s, Actual: '%s\nDependency: '%s'".formatted(ExternalModuleDependency.class.getName(), dependency.getClass().getName(), dependency.toString())).severity(Severity.ERROR).stackLocation().solution("Declare a module dependency instead.").solution(HELP_MESSAGE));
    }

    RuntimeException accessTransformerFailed(RuntimeException e, File inJar, File atFile) {
        return this.getReporter().throwing((Throwable)e, ForgeGradleProblems.id("access-transformer-failed", "Access transformer failed"), spec -> spec.details("The access transformer failed to apply the transformations.\nThis could potentially be caused by an invalid access transformer configuration.\nInput Jar: %s\nAccessTransformer Config: %s".formatted(inJar, atFile)).severity(Severity.ERROR).stackLocation().fileLocation(atFile.getAbsolutePath()).solution("Check your access transformer configuration file and ensure it is valid.").solution(HELP_MESSAGE));
    }

    Transformer<Directory, Directory> ensureDirectory() {
        return dir -> {
            try {
                Files.createDirectories(dir.getAsFile().toPath(), new FileAttribute[0]);
                return dir;
            }
            catch (IOException e) {
                throw this.getReporter().throwing((Throwable)e, ForgeGradleProblems.id("cannot-ensure-directory", "Failed to create directory"), spec -> spec.details("Failed to create a directory required for ForgeGradle to function.\nDirectory: %s".formatted(dir.getAsFile().getAbsolutePath())).severity(Severity.ERROR).stackLocation().solution("Ensure that the you have write access to the directory that needs to be created.").solution(HELP_MESSAGE));
            }
        };
    }

    static interface EmptyReporter
    extends ProblemReporter {
        public static final EmptyReporter INSTANCE = new EmptyReporter(){};
        public static final Problems AS_PROBLEMS = () -> INSTANCE;

        default public Problem create(ProblemId problemId, Action<? super ProblemSpec> action) {
            return new Problem(){};
        }

        default public void report(ProblemId problemId, Action<? super ProblemSpec> spec) {
        }

        default public void report(Problem problem) {
        }

        default public void report(Collection<? extends Problem> problems) {
        }

        default public RuntimeException throwing(Throwable exception, ProblemId problemId, Action<? super ProblemSpec> spec) {
            return this.toRTE(exception);
        }

        default public RuntimeException throwing(Throwable exception, Problem problem) {
            return this.toRTE(exception);
        }

        default public RuntimeException throwing(Throwable exception, Collection<? extends Problem> problems) {
            return this.toRTE(exception);
        }

        private RuntimeException toRTE(Throwable exception) {
            RuntimeException rte;
            return exception instanceof RuntimeException ? (rte = (RuntimeException)exception) : new RuntimeException(exception);
        }
    }
}

