/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev.tasks.shim;

import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import net.minecraftforge.forgedev.legacy.tasks.CleanProperties;
import net.minecraftforge.forgedev.tasks.SingleFileOutput;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.jvm.toolchain.JavaLanguageVersion;

public abstract class ShimConfig
extends DefaultTask
implements SingleFileOutput {
    public static final String DEFAULT_FILE_NAME = "bootstrap-shim.properties";

    @Input
    public abstract Property<String> getMainClass();

    @Input
    public abstract Property<JavaLanguageVersion> getJavaVersion();

    @Input
    public abstract ListProperty<String> getArgs();

    @Override
    @OutputFile
    public abstract RegularFileProperty getOutput();

    @Inject
    public abstract ProjectLayout getLayout();

    @Inject
    public ShimConfig() {
        Object fileName = DEFAULT_FILE_NAME;
        if (!this.getName().equals("serverShimConfig")) {
            fileName = this.getName() + ".properties";
        }
        this.getOutput().convention(this.getLayout().getBuildDirectory().file("libs/" + (String)fileName));
        if (this.getProject().getPluginManager().hasPlugin("java")) {
            this.getJavaVersion().convention((Provider)((JavaPluginExtension)this.getProject().getExtensions().findByType(JavaPluginExtension.class)).getToolchain().getLanguageVersion());
        }
    }

    @TaskAction
    protected void exec() throws IOException {
        CleanProperties cfg = new CleanProperties();
        cfg.put("Main-Class", this.getMainClass().get());
        cfg.put("Java-Version", ((JavaLanguageVersion)this.getJavaVersion().get()).toString());
        cfg.put("Arguments", String.join((CharSequence)" ", (Iterable)this.getArgs().get()));
        cfg.store((File)this.getOutput().getAsFile().get());
    }
}

