/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev.tasks.shim;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraftforge.forgedev.ForgeDevTask;
import net.minecraftforge.forgedev.legacy.tasks.Util;
import net.minecraftforge.forgedev.legacy.values.MavenInfo;
import net.minecraftforge.forgedev.legacy.values.MinimalResolvedArtifact;
import net.minecraftforge.forgedev.tasks.SingleFileOutput;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;

public abstract class ShimClasspath
extends DefaultTask
implements ForgeDevTask,
SingleFileOutput {
    @InputFiles
    public abstract ConfigurableFileCollection getInput();

    @Input
    public abstract ListProperty<MinimalResolvedArtifact> getLibraries();

    @InputFile
    @Optional
    public abstract RegularFileProperty getServerBundle();

    @Override
    @OutputFile
    public abstract RegularFileProperty getOutput();

    public ShimClasspath() {
        this.getOutput().convention(this.getDefaultOutputFile("list"));
    }

    public void libraries(Configuration config) {
        this.getInput().from(new Object[]{config});
        this.getLibraries().addAll(MinimalResolvedArtifact.from(this.getProject(), config));
    }

    public void library(TaskProvider<? extends AbstractArchiveTask> task) {
        this.library(MinimalResolvedArtifact.from(this.getProject(), task));
    }

    public void library(TaskProvider<? extends SingleFileOutput> task, String classifier) {
        this.library(MinimalResolvedArtifact.from(MavenInfo.from(this.getProject(), classifier), (Provider<RegularFile>)task.flatMap(rec$ -> ((SingleFileOutput)rec$).getOutput())));
    }

    public void library(Provider<MinimalResolvedArtifact> info) {
        this.getInput().from(new Object[]{info.map(MinimalResolvedArtifact::file)});
        this.getLibraries().add(info);
    }

    @TaskAction
    public void run() throws IOException {
        TreeMap<CallSite, Object> entries = new TreeMap<CallSite, Object>();
        for (MinimalResolvedArtifact lib : (List)this.getLibraries().get()) {
            MavenInfo.ArtifactInfo info = lib.info().art();
            String key = info.group() + ":" + info.name();
            if (info.classifier() != null) {
                key = key + ":" + info.classifier();
            }
            entries.put((CallSite)((Object)key), Util.sha256(lib.file()) + "\t" + lib.info().name() + "\t" + lib.info().path());
        }
        File bundle = (File)this.getServerBundle().map(RegularFile::getAsFile).getOrNull();
        if (bundle != null) {
            try (ZipFile zip = new ZipFile(bundle);){
                ZipEntry entry = zip.getEntry("META-INF/libraries.list");
                if (entry == null) {
                    throw new IllegalStateException("Server Jar does not have bundle list: " + bundle.getAbsolutePath());
                }
                try (BufferedReader buf = new BufferedReader(new InputStreamReader(zip.getInputStream(entry)));){
                    String line;
                    while ((line = buf.readLine()) != null) {
                        String[] tabs = line.split("\t");
                        MavenInfo.ArtifactInfo info = MavenInfo.from(tabs[1]).art();
                        String key = info.group() + ":" + info.name();
                        if (info.classifier() != null) {
                            key = key + ":" + info.classifier();
                        }
                        entries.putIfAbsent((CallSite)((Object)key), line);
                    }
                }
            }
        }
        File output = (File)this.getOutput().getAsFile().get();
        Files.writeString(output.toPath(), (CharSequence)String.join((CharSequence)"\n", entries.values()), StandardCharsets.UTF_8, new OpenOption[0]);
    }
}

