/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev.tasks.installer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import net.minecraftforge.forgedev.legacy.tasks.Util;
import net.minecraftforge.forgedev.legacy.values.LibraryInfo;
import net.minecraftforge.forgedev.legacy.values.MinimalResolvedArtifact;
import net.minecraftforge.forgedev.tasks.installer.Installer;
import net.minecraftforge.forgedev.tasks.installer.Tool;
import net.minecraftforge.forgedev.tasks.installer.steps.Extract;
import net.minecraftforge.forgedev.tasks.installer.steps.ExtractBundle;
import net.minecraftforge.forgedev.tasks.installer.steps.Step;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;

public abstract class InstallerJson
extends DefaultTask {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    private final Set<Provider<LibraryInfo>> extraLibraries = new LinkedHashSet<Provider<LibraryInfo>>();

    @Inject
    protected abstract ProviderFactory getProviders();

    @Inject
    protected abstract ObjectFactory getObjects();

    @OutputFile
    public abstract RegularFileProperty getOutput();

    @InputFiles
    public abstract ConfigurableFileCollection getInput();

    @InputFile
    @Optional
    public abstract RegularFileProperty getIcon();

    @Input
    public abstract Property<String> getLauncherJsonName();

    @Input
    public abstract Property<String> getLogo();

    @Input
    public abstract Property<String> getMirrors();

    @Input
    public abstract Property<String> getWelcome();

    @Input
    public abstract Property<String> getProfileName();

    @Input
    public abstract Property<String> getProfileVersion();

    @Input
    public abstract Property<String> getExecutablePath();

    @Input
    public abstract Property<String> getMinecraft();

    @Input
    public abstract Property<String> getMinecraftServerPath();

    @Input
    public abstract Property<Boolean> getHideExtract();

    @Input
    public abstract Property<Boolean> getHideClient();

    @Input
    public abstract Property<Boolean> getHideServer();

    @Input
    @Optional
    public abstract MapProperty<String, Data> getData();

    @Input
    @Optional
    public abstract ListProperty<Step> getSteps();

    @Inject
    public InstallerJson() {
        this.getOutput().convention(this.getProject().getLayout().getBuildDirectory().file("libs/install_profile.json"));
        this.getLauncherJsonName().convention((Object)"/version.json");
        this.getLogo().convention((Object)"/big_logo.png");
        this.getMirrors().convention((Object)"https://files.minecraftforge.net/mirrors-2.0.json");
        this.getWelcome().convention((Object)("Welcome to the " + Util.capitalize(this.getProject().getName()) + " installer."));
        this.getMinecraftServerPath().convention((Object)"{LIBRARY_DIR}/net/minecraft/server/{MINECRAFT_VERSION}/server-{MINECRAFT_VERSION}-bundled.jar");
        this.getProfileName().convention((Object)this.getProject().getName());
        this.getHideExtract().convention((Object)true);
        this.getHideClient().convention((Object)false);
        this.getHideServer().convention((Object)false);
    }

    public void executable(TaskProvider<? extends AbstractArchiveTask> task) {
        Provider<MinimalResolvedArtifact> info = MinimalResolvedArtifact.from(this.getProject(), task);
        this.getExecutablePath().set(info.map(i -> i.info().name()));
    }

    public void library(Provider<MinimalResolvedArtifact> info, Action<LibraryInfo> action) {
        this.getInput().from(new Object[]{info.map(MinimalResolvedArtifact::file)});
        this.extraLibraries.add((Provider<LibraryInfo>)info.map(LibraryInfo::from).map(LibraryInfo.apply(action)));
    }

    private <R extends Step> R step(Class<R> cls, Tool tool, Action<? super R> action) {
        Step ret = (Step)this.getObjects().newInstance(cls, new Object[]{tool});
        this.getInput().from(new Object[]{tool.getArtifacts().stream().map(MinimalResolvedArtifact::file).toList()});
        action.execute((Object)ret);
        return (R)ret;
    }

    public Step step(Tool tool, Action<? super Step> action) {
        return this.step(Step.class, tool, action);
    }

    public Extract extract(Tool tool, Action<? super Extract> action) {
        return this.step(Extract.class, tool, action);
    }

    public ExtractBundle extractBundle(Tool tool, Action<? super ExtractBundle> action) {
        return this.step(ExtractBundle.class, tool, action);
    }

    public void data(String key, String client, String server) {
        this.getData().put((Object)key, (Object)new Data(client, server));
    }

    public void data(String key, RegularFileProperty client, RegularFileProperty server) {
        this.getData().put((Object)key, client.zip((Provider)server, (l, r) -> new Data("'" + Util.sha1(((RegularFile)client.get()).getAsFile()) + "'", "'" + Util.sha1(((RegularFile)server.get()).getAsFile()) + "'")));
    }

    @TaskAction
    protected void exec() throws IOException {
        ArrayList<LibraryInfo> libraries = new ArrayList<LibraryInfo>();
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        json.put("_comment", Installer.JSON_COMMENT);
        json.put("spec", 1);
        if (((Boolean)this.getHideExtract().getOrElse((Object)false)).booleanValue()) {
            json.put("hideExtract", true);
        }
        if (((Boolean)this.getHideClient().getOrElse((Object)false)).booleanValue()) {
            json.put("hideClient", true);
        }
        if (((Boolean)this.getHideServer().getOrElse((Object)false)).booleanValue()) {
            json.put("hideServer", true);
        }
        json.put("profile", this.getProfileName().get());
        json.put("version", this.getProfileVersion().get());
        json.put("path", this.getExecutablePath().get());
        json.put("minecraft", this.getMinecraft().get());
        json.put("serverJarPath", this.getMinecraftServerPath().get());
        if (this.getData().isPresent() && !((Map)this.getData().get()).isEmpty()) {
            json.put("data", this.getData().get());
        }
        if (this.getSteps().isPresent() && !((List)this.getSteps().get()).isEmpty()) {
            ArrayList processors = new ArrayList();
            json.put("processors", processors);
            for (Step step : (List)this.getSteps().get()) {
                LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
                if (!step.sides.isEmpty()) {
                    data.put("sides", step.sides);
                }
                Tool tool = step.getTool();
                data.put("jar", tool.getJar());
                if (!tool.getArtifacts().isEmpty()) {
                    ArrayList<String> classpath = new ArrayList<String>();
                    for (LibraryInfo info : LibraryInfo.from(tool.getArtifacts()).values()) {
                        libraries.add(info);
                        if (tool.getJar().equals(info.name())) continue;
                        classpath.add(info.name());
                    }
                    data.put("classpath", classpath);
                }
                data.put("args", step.getArgs());
                if (!step.getOutputs().isEmpty()) {
                    data.put("outputs", step.getOutputs());
                }
                processors.add(data);
            }
        }
        for (Provider<LibraryInfo> library : this.extraLibraries) {
            LibraryInfo info = (LibraryInfo)library.get();
            libraries.add(info);
        }
        HashSet seen = new HashSet();
        libraries.sort(Comparator.comparing(LibraryInfo::name));
        libraries.removeIf(l -> !seen.add(l.name()));
        json.put("libraries", libraries);
        RegularFile icon = (RegularFile)this.getIcon().getOrNull();
        if (icon != null) {
            byte[] data = Files.readAllBytes(icon.getAsFile().toPath());
            String base64 = Base64.getEncoder().encodeToString(data);
            json.put("icon", "data:image/png;base64," + base64);
        }
        json.put("json", this.getLauncherJsonName().get());
        json.put("logo", this.getLogo().get());
        if (!((String)this.getMirrors().get()).isEmpty()) {
            json.put("mirrorList", this.getMirrors().get());
        }
        json.put("welcome", this.getWelcome().get());
        Path output = ((RegularFile)this.getOutput().get()).getAsFile().toPath();
        String jsonData = GSON.toJson(json);
        Files.writeString(output, (CharSequence)jsonData, new OpenOption[0]);
    }

    public record Data(String client, String server) implements Serializable
    {
    }
}

