/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev.tasks.installer;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.minecraftforge.forgedev.legacy.tasks.DownloadDependency;
import net.minecraftforge.forgedev.legacy.values.LibraryInfo;
import net.minecraftforge.forgedev.legacy.values.MinimalResolvedArtifact;
import net.minecraftforge.forgedev.tasks.installer.Installer;
import net.minecraftforge.forgedev.tasks.installer.InstallerJar;
import net.minecraftforge.util.download.DownloadUtils;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public abstract class InstallerJarConfig
extends DefaultTask {
    private final Provider<Installer> installer;
    private final TaskProvider<DownloadDependency> base;
    private final Map<Provider<String>, Action<LibraryInfo>> actions = new IdentityHashMap<Provider<String>, Action<LibraryInfo>>();

    @InputFiles
    public abstract ConfigurableFileCollection getInput();

    @Input
    public abstract Property<Boolean> getDev();

    @Input
    public abstract Property<Boolean> getOffline();

    @Input
    public abstract ListProperty<MinimalResolvedArtifact> getLibraries();

    @Inject
    protected abstract ArchiveOperations getArchiveOperations();

    @Inject
    public InstallerJarConfig(Provider<Installer> installer, TaskProvider<DownloadDependency> base) {
        this.installer = installer;
        this.base = base;
        this.getDev().convention(installer.flatMap(Installer::getDev));
        this.getOffline().convention(installer.flatMap(Installer::getOffline));
    }

    @TaskAction
    protected void exec() {
        ((Installer)this.installer.get()).jar((Action<? super InstallerJar>)((Action)task -> task.from(this.getArchiveOperations().zipTree((Object)this.base.map(DownloadDependency::getOutput)), cfg -> {
            cfg.exclude(new String[]{"META-INF/MANIFEST.MF"});
            cfg.setDuplicatesStrategy(DuplicatesStrategy.EXCLUDE);
        })));
        if (!((Boolean)this.getOffline().get()).booleanValue() && !((Boolean)this.getDev().get()).booleanValue()) {
            return;
        }
        HashMap<String, Action<LibraryInfo>> actions = new HashMap<String, Action<LibraryInfo>>();
        for (Map.Entry<Provider<String>, Action<LibraryInfo>> entry : this.actions.entrySet()) {
            actions.put((String)entry.getKey().get(), entry.getValue());
        }
        HashSet<String> seen = new HashSet<String>();
        for (MinimalResolvedArtifact artifact : (List)this.getLibraries().get()) {
            LibraryInfo info = LibraryInfo.from(artifact);
            Action action = (Action)actions.get(artifact.info().name());
            if (action != null) {
                action.execute((Object)info);
            }
            if (!seen.add(info.downloads().artifact().path)) continue;
            this.pack(artifact, info);
        }
    }

    @ApiStatus.Internal
    public void libraries(Configuration config) {
        this.getInput().from(new Object[]{config});
        this.getLibraries().addAll(MinimalResolvedArtifact.from(this.getProject(), config));
    }

    @ApiStatus.Internal
    public void library(Provider<MinimalResolvedArtifact> info, Action<LibraryInfo> action) {
        this.getInput().from(new Object[]{info.map(MinimalResolvedArtifact::file)});
        this.getLibraries().add(info);
        this.actions.put((Provider<String>)info.map(artifact -> artifact.info().name()), action);
    }

    private void pack(MinimalResolvedArtifact resolved, LibraryInfo info) {
        boolean pack;
        LibraryInfo.Downloads.ArtifactInfo artifact = info.downloads().artifact();
        boolean bl = pack = (Boolean)this.getOffline().get() != false || artifact.url.isEmpty();
        if (!pack) {
            try {
                String remote = DownloadUtils.downloadString((String)(artifact.url + ".sha1"));
                pack = !artifact.sha1.equals(remote);
            }
            catch (FileNotFoundException e) {
                pack = !artifact.url.startsWith("https://libraries.minecraft.net/");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (!pack) {
            return;
        }
        ((Installer)this.installer.get()).getJar().configure(task -> task.from(resolved.file(), spec -> {
            spec.rename(name -> {
                this.getLogger().lifecycle("Adding: " + artifact.path);
                return "maven/" + artifact.path;
            });
            spec.setDuplicatesStrategy(DuplicatesStrategy.EXCLUDE);
        }));
    }
}

