/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev.tasks.checks;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import javax.inject.Inject;
import net.minecraftforge.forgedev.LegacyMCPExtension;
import net.minecraftforge.forgedev.LegacyPatcherExtension;
import net.minecraftforge.forgedev.legacy.tasks.Util;
import net.minecraftforge.forgedev.tasks.checks.Check;
import net.minecraftforge.forgedev.tasks.checks.CheckATs;
import net.minecraftforge.forgedev.tasks.checks.CheckExecs;
import net.minecraftforge.forgedev.tasks.checks.CheckPatches;
import net.minecraftforge.forgedev.tasks.checks.CheckSAS;
import net.minecraftforge.forgedev.tasks.checks.CheckTask;
import net.minecraftforge.forgedev.tasks.installertools.ExtractInheritance;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Jar;

public abstract class Checks {
    private final TaskContainer tasks;
    private final LegacyMCPExtension mcp;
    private final LegacyPatcherExtension patcher;
    private final TaskProvider<Task> checkAndFix;
    private TaskProvider<ExtractInheritance> extractInheritance;
    private Check<CheckATs> ats;
    private Check<CheckExecs> execs;
    private Check<CheckSAS> sas;
    private Check<CheckPatches> patches;

    @Inject
    public abstract ObjectFactory getObjects();

    @Inject
    public Checks(Project project) {
        this.tasks = project.getTasks();
        this.mcp = (LegacyMCPExtension)project.getExtensions().getByType(LegacyMCPExtension.class);
        this.patcher = (LegacyPatcherExtension)project.getExtensions().getByType(LegacyPatcherExtension.class);
        this.checkAndFix = this.tasks.register("checkAndFix", task -> task.setGroup("verification"));
    }

    public TaskProvider<Task> getFix() {
        return this.checkAndFix;
    }

    public void fix(Action<? super Task> action) {
        this.checkAndFix.configure(action);
    }

    private TaskProvider<ExtractInheritance> getExtractInheritance() {
        if (this.extractInheritance == null) {
            this.extractInheritance = this.tasks.register("extractInheritance", ExtractInheritance.class, task -> {
                task.getAdditionalArgs().add((Object)"--annotations");
                task.getInput().set(this.mcp.getFiles().getJoinedSearge());
                task.getLibraries().from(new Object[]{this.mcp.getFiles().getLibraryList().map(libraries -> {
                    try {
                        return Files.readAllLines(libraries.getAsFile().toPath()).stream().map(line -> line.substring(3)).map(File::new).toList();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                })});
            });
        }
        return this.extractInheritance;
    }

    public <T extends CheckTask> Check<T> check(String taskName, Class<T> clazz) {
        return this.check(taskName, clazz, Util.noop());
    }

    public <T extends CheckTask> Check<T> check(String taskName, Class<T> clazz, Action<? super T> action) {
        taskName = StringGroovyMethods.capitalize((CharSequence)taskName);
        TaskProvider check = this.tasks.register("check" + taskName, clazz, task -> {
            action.execute((Object)task);
            task.getFix().set((Object)false);
        });
        this.tasks.named("check", task -> task.dependsOn(new Object[]{check}));
        TaskProvider fix = this.tasks.register("checkAndFix" + taskName, clazz, task -> {
            action.execute((Object)task);
            task.getFix().set((Object)true);
        });
        this.checkAndFix.configure(task -> task.dependsOn(new Object[]{fix}));
        Check ret = (Check)this.getObjects().newInstance(Check.class, new Object[]{check, fix});
        return ret;
    }

    public Check<CheckATs> getAts() {
        if (this.ats == null) {
            Provider inheritance = this.getExtractInheritance().flatMap(ExtractInheritance::getOutput);
            this.ats = this.check("Ats", CheckATs.class, task -> {
                task.getAts().from(new Object[]{this.patcher.getAccessTransformers()});
                task.getInheritance().set(inheritance);
            });
        }
        return this.ats;
    }

    public Check<CheckATs> ats() {
        return this.ats(Util.noop());
    }

    public Check<CheckATs> ats(Action<CheckATs> action) {
        Check<CheckATs> ret = this.getAts();
        ret.check(action);
        ret.fix(action);
        return ret;
    }

    public Check<CheckExecs> getExecs() {
        if (this.execs == null) {
            this.execs = this.check("Execs", CheckExecs.class, task -> {
                task.getExcs().from(new Object[]{this.patcher.getExcs()});
                task.getBinary().set(this.tasks.named("name", Jar.class).flatMap(AbstractArchiveTask::getArchiveFile));
            });
        }
        return this.execs;
    }

    public Check<CheckExecs> execs() {
        return this.execs(Util.noop());
    }

    public Check<CheckExecs> execs(Action<CheckExecs> action) {
        Check<CheckExecs> ret = this.getExecs();
        ret.check(action);
        ret.fix(action);
        return ret;
    }

    public Check<CheckSAS> getSas() {
        if (this.sas == null) {
            Provider inheritance = this.getExtractInheritance().flatMap(ExtractInheritance::getOutput);
            this.sas = this.check("Sas", CheckSAS.class, task -> {
                task.getInheritance().set(inheritance);
                task.getSass().from(new Object[]{this.patcher.getSideAnnotationStrippers()});
            });
        }
        return this.sas;
    }

    public Check<CheckSAS> sas(Action<CheckSAS> action) {
        Check<CheckSAS> ret = this.getSas();
        ret.check(action);
        ret.fix(action);
        return ret;
    }

    public Check<CheckPatches> getPatches() {
        if (this.patches == null) {
            this.patches = this.check("Patches", CheckPatches.class);
        }
        return this.patches;
    }

    public Check<CheckPatches> patches() {
        return this.patches(Util.noop());
    }

    public Check<CheckPatches> patches(Action<CheckPatches> action) {
        Check<CheckPatches> ret = this.getPatches();
        ret.check(action);
        ret.fix(action);
        return ret;
    }
}

