/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev.tasks.checks;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.VerificationTask;

public abstract class CheckTask
extends DefaultTask
implements VerificationTask {
    private final Property<Boolean> ignoreFailures = this.getObjects().property(Boolean.class).convention((Object)false);

    @Input
    public abstract Property<Boolean> getFix();

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    public CheckTask() {
        this.setGroup("verification");
    }

    public boolean getIgnoreFailures() {
        return (Boolean)this.ignoreFailures.getOrElse((Object)false);
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures.set((Object)ignoreFailures);
    }

    @TaskAction
    protected void run() throws Exception {
        String name = this.getName();
        Logger logger = this.getLogger();
        Boolean doFix = (Boolean)this.getFix().get();
        Reporter reporter = (Reporter)this.getObjects().newInstance(Reporter.class, new Object[0]);
        this.check(reporter, doFix);
        if (!reporter.messages.isEmpty()) {
            if (!doFix.booleanValue()) {
                logger.error("Check task '{}' found errors:\n{}", (Object)name, (Object)String.join((CharSequence)"\n", reporter.messages));
                if (!this.getIgnoreFailures()) {
                    throw new IllegalArgumentException(reporter.messages.size() + " errors were found");
                }
            } else {
                if (logger.isEnabled(LogLevel.DEBUG)) {
                    logger.warn("Check task '{}' found {} errors and fixed {}:\n{}", new Object[]{name, reporter.messages.size(), reporter.fixed.size(), String.join((CharSequence)"\n", reporter.fixed)});
                } else {
                    logger.warn("Check task '{}' found {} errors and fixed {}.", new Object[]{name, reporter.messages.size(), reporter.fixed.size()});
                }
                if (!reporter.notFixed.isEmpty()) {
                    logger.error("{} errors could not be fixed:\n{}", (Object)reporter.notFixed.size(), (Object)String.join((CharSequence)"\n", reporter.notFixed));
                    if (!this.getIgnoreFailures()) {
                        throw new IllegalArgumentException(reporter.notFixed.size() + " errors which cannot be fixed were found!");
                    }
                }
            }
        }
    }

    protected abstract void check(Reporter var1, boolean var2) throws Exception;

    public static abstract class Reporter {
        public final List<String> messages = new ArrayList<String>();
        public final List<String> fixed = new ArrayList<String>();
        public final List<String> notFixed = new ArrayList<String>();

        public void report(String message) {
            this.report(message, true);
        }

        public void report(String message, boolean canBeFixed) {
            this.messages.add(message);
            (canBeFixed ? this.fixed : this.notFixed).add(message);
        }
    }
}

