/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev.tasks.checks;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.inject.Inject;
import net.minecraftforge.forgedev.legacy.tasks.InheritanceData;
import net.minecraftforge.forgedev.legacy.tasks.InheritanceDataAnnotatable;
import net.minecraftforge.forgedev.tasks.checks.CheckTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;

public abstract class CheckSAS
extends CheckTask {
    @InputFile
    public abstract RegularFileProperty getInheritance();

    @InputFiles
    public abstract ConfigurableFileCollection getSass();

    @Input
    public abstract Property<String> getAnnotation();

    @Inject
    public CheckSAS() {
        this.getAnnotation().convention((Object)"Lnet/minecraftforge/api/distmarker/OnlyIn;");
    }

    @Override
    public void check(CheckTask.Reporter reporter, boolean fix) throws IOException {
        Map<String, InheritanceData> inheritance = InheritanceData.parse((File)this.getInheritance().getAsFile().get());
        for (File file : this.getSass().getFiles()) {
            ArrayList<Object> lines = new ArrayList<Object>();
            for (String line : Files.readAllLines(file.toPath(), StandardCharsets.UTF_8)) {
                if (!line.isEmpty() && line.charAt(0) == '\t') {
                    return;
                }
                int idx = line.indexOf(35);
                if (idx == 0 || line.isEmpty()) {
                    lines.add(line);
                    return;
                }
                Line parsed = Line.of(line);
                InheritanceData clsInh = inheritance.get(parsed.cls);
                if (clsInh == null) {
                    reporter.report("Invalid: " + line);
                    continue;
                }
                if (parsed.name.isEmpty()) {
                    ArrayList<CallSite> toAdd = new ArrayList<CallSite>();
                    boolean sided = this.isSided(clsInh);
                    if (clsInh.methods() != null) {
                        for (Map.Entry<String, InheritanceData.Method> entry : clsInh.methods().entrySet()) {
                            String key = entry.getKey();
                            if (this.isSided(entry.getValue())) {
                                sided = true;
                                toAdd.add((CallSite)((Object)("\t" + parsed.cls + " " + key.replaceAll(" ", ""))));
                            }
                            if (!sided) continue;
                            for (String child : this.findChildMethods(inheritance, parsed.cls, key)) {
                                lines.add("\t" + child);
                                this.getLogger().lifecycle(line + " -- " + child);
                            }
                        }
                    }
                    if (sided) {
                        lines.add(parsed.cls + (String)(parsed.comment == null ? "" : " " + String.valueOf(parsed)));
                        Collections.sort(toAdd);
                        lines.addAll(toAdd);
                        continue;
                    }
                    reporter.report("Invalid: " + line);
                    continue;
                }
                if (parsed.desc.isEmpty()) {
                    reporter.report("Invalid: " + line);
                    continue;
                }
                String key = parsed.name + " " + parsed.desc;
                if (clsInh.methods() == null || !this.isSided(clsInh.methods().get(key))) {
                    reporter.report("Invalid: " + line);
                    continue;
                }
                lines.add(parsed.cls + " " + parsed.name + parsed.desc + (String)(parsed.comment == null ? "" : " " + parsed.comment));
                for (String child : this.findChildMethods(inheritance, parsed.cls, key)) {
                    lines.add("\t" + child);
                    this.getLogger().lifecycle(line + " -- " + child);
                }
            }
            if (!fix) continue;
            Files.writeString(file.toPath(), (CharSequence)String.join((CharSequence)"\n", lines), StandardCharsets.UTF_8, new OpenOption[0]);
        }
    }

    private boolean isSided(InheritanceDataAnnotatable annotatable) {
        if (annotatable == null) {
            return false;
        }
        String desc = (String)this.getAnnotation().get();
        for (InheritanceData.Annotation ann : annotatable.annotations()) {
            if (!desc.equals(ann.desc())) continue;
            return true;
        }
        return false;
    }

    private Set<String> findChildMethods(Map<String, InheritanceData> json, String cls, String desc) {
        TreeSet<String> ret = new TreeSet<String>();
        for (InheritanceData value : json.values()) {
            InheritanceData.Method mtd;
            if (value.methods() == null || (mtd = value.methods().get(desc)) == null || !cls.equals(mtd.override()) || this.isSided(mtd)) continue;
            ret.add(value.name() + " " + desc.replace(" ", ""));
        }
        return ret;
    }

    private record Line(String cls, String name, String desc, String comment) {
        private static Line of(String line) {
            int idx = line.indexOf(35);
            String comment = null;
            if (idx != -1) {
                comment = line.substring(idx);
                line = line.substring(0, idx - 1);
            }
            String[] pts = line.trim().replace("(", " (").split(" ");
            String cls = pts[0].replace('.', '/');
            return new Line(cls, pts.length > 1 ? pts[1] : "", pts.length > 2 ? pts[2] : "", comment);
        }
    }
}

