/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev.tasks.checks;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraftforge.forgedev.tasks.checks.CheckTask;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Optional;

public abstract class CheckPatches
extends CheckTask {
    private static final Pattern HUNK_START_PATTERN = Pattern.compile("^@@ -[0-9,]* \\+[0-9,_]* @@$");
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("^[+\\-]\\s*$");
    private static final Pattern IMPORT_PATTERN = Pattern.compile("^[+\\-]\\s*import.*");
    private static final Pattern FIELD_PATTERN = Pattern.compile("^[+\\-][\\s]*((public|protected|private)[\\s]*)?(static[\\s]*)?(final)?([^=;]*)(=.*)?;\\s*$");
    private static final Pattern METHOD_PATTERN = Pattern.compile("^[+\\-][\\s]*((public|protected|private)[\\s]*)?(static[\\s]*)?(final)?([^(]*)[(]([^)]*)?[)]\\s*[{]\\s*$");
    private static final Pattern CLASS_PATTERN = Pattern.compile("^[+\\-][\\s]*((public|protected|private)[\\s]*)?(static[\\s]*)?(final[\\s]*)?(class|interface)([^{]*)[{]\\s*$");

    @InputDirectory
    abstract DirectoryProperty getPatchDir();

    @Input
    @Optional
    abstract ListProperty<String> getPatchesWithS2SArtifact();

    @Override
    public void check(CheckTask.Reporter reporter, boolean fix) throws IOException {
        Path dir = ((File)this.getPatchDir().getAsFile().get()).toPath();
        List s2sBugged = (List)this.getPatchesWithS2SArtifact().get();
        try (Stream<Path> stream = Files.walk(dir, new FileVisitOption[0]);){
            for (Path path : stream.toList()) {
                if (!Files.isRegularFile(path, new LinkOption[0])) {
                    return;
                }
                String relativeName = dir.relativize(path).toString();
                this.verifyPatch(path, reporter, fix, relativeName, s2sBugged.contains(relativeName.replace('\\', '/')));
            }
        }
    }

    private static boolean accessChange(String previous, String current) {
        return !previous.equals(current);
    }

    void verifyPatch(Path patch, CheckTask.Reporter reporter, boolean fix, String patchPath, boolean hasS2SArtifact) throws IOException {
        int i;
        int oldFixedErrors = reporter.fixed.size();
        List<String> lines = Files.readAllLines(patch);
        int hunksStart = 0;
        boolean onlyWhiteSpace = false;
        ArrayList<CallSite> newLines = new ArrayList<CallSite>();
        newLines.add((CallSite)((Object)(lines.get(0) + "\n")));
        newLines.add((CallSite)((Object)(lines.get(1) + "\n")));
        for (i = 2; i < lines.size(); ++i) {
            String currTrim;
            String nextTrim;
            String nextLine;
            String line = lines.get(i);
            newLines.add((CallSite)((Object)(line + "\n")));
            if (HUNK_START_PATTERN.matcher(line).find()) {
                if (onlyWhiteSpace) {
                    if (!hasS2SArtifact) {
                        reporter.report("Patch contains only white space hunk starting at line " + (hunksStart + 1) + ", file: " + patchPath);
                    }
                    int toRemove = i - hunksStart;
                    while (toRemove-- > 0) {
                        newLines.remove(newLines.size() - 1);
                    }
                }
                hunksStart = i;
                onlyWhiteSpace = true;
                continue;
            }
            if (!line.startsWith("+") && !line.startsWith("-")) continue;
            boolean prefixChange = false;
            String prevLine = lines.get(i - 1);
            if (line.charAt(0) == '+' && prevLine.charAt(0) == '-') {
                String currTrim2;
                String prevTrim = prevLine.substring(1).replaceAll("\\s", "");
                if (prevTrim.equals(currTrim2 = line.substring(1).replaceAll("\\s", ""))) {
                    prefixChange = true;
                }
                if (this.check(FIELD_PATTERN.matcher(prevLine), FIELD_PATTERN.matcher(line))) {
                    reporter.report("Patch contains access changes or final removal at line " + (i + 1) + ", file: " + patchPath, false);
                }
                if (this.check(METHOD_PATTERN.matcher(prevLine), METHOD_PATTERN.matcher(line))) {
                    reporter.report("Patch contains access changes or final removal at line " + (i + 1) + ", file: " + patchPath, false);
                }
                if (this.check(CLASS_PATTERN.matcher(prevLine), CLASS_PATTERN.matcher(line))) {
                    reporter.report("Patch contains access changes or final removal at line " + (i + 1) + ", file: " + patchPath, false);
                }
            }
            if (line.charAt(0) == '-' && i + 1 < lines.size() && (nextLine = lines.get(i + 1)).charAt(0) == '+' && (nextTrim = nextLine.substring(1).replaceAll("\\s", "")).equals(currTrim = line.substring(1).replaceAll("\\s", ""))) {
                prefixChange = true;
            }
            boolean isWhiteSpaceChange = WHITESPACE_PATTERN.matcher(line).find();
            if (!prefixChange && !isWhiteSpaceChange) {
                onlyWhiteSpace = hasS2SArtifact && IMPORT_PATTERN.matcher(line).find();
            } else if (isWhiteSpaceChange) {
                boolean nextLineChange;
                boolean prevLineChange = prevLine.startsWith("+") || prevLine.startsWith("-");
                String nextLine2 = i + 1 < lines.size() ? lines.get(i + 1) : null;
                boolean bl = nextLineChange = nextLine2 != null && (nextLine2.startsWith("+") || nextLine2.startsWith("-"));
                if (!prevLineChange && !nextLineChange) {
                    reporter.report("Patch contains white space change in valid hunk at line " + (i + 1) + ", file: " + patchPath + "\n" + prevLine + "\n" + line + "\n" + nextLine2, false);
                }
            }
            if (line.contains("\t")) {
                reporter.report("Patch contains tabs on line " + (i + 1) + ", file: " + patchPath);
                line = line.replaceAll("\t", "    ");
                newLines.remove(newLines.size() - 1);
                newLines.add((CallSite)((Object)(line + "\n")));
            }
            if (!IMPORT_PATTERN.matcher(line).find() || hasS2SArtifact) continue;
            reporter.report("Patch contains import change on line " + (i + 1) + ", file: " + patchPath, false);
        }
        if (onlyWhiteSpace) {
            if (!hasS2SArtifact) {
                reporter.report("Patch contains only white space hunk starting at line " + (hunksStart + 1) + ", file: " + patchPath);
            }
            int toRemove = i - hunksStart;
            while (toRemove-- > 0) {
                newLines.remove(newLines.size() - 1);
            }
        }
        if (reporter.fixed.size() > oldFixedErrors && fix || hasS2SArtifact) {
            if (newLines.size() <= 2) {
                this.getLogger().lifecycle("Patch is now empty removing, file: {}", new Object[]{patchPath});
                Files.delete(patch);
            } else {
                if (!hasS2SArtifact) {
                    this.getLogger().lifecycle("*** Updating patch file. Please run setup then genPatches again. ***");
                }
                Files.writeString(patch, (CharSequence)String.join((CharSequence)"", newLines), StandardCharsets.UTF_8, new OpenOption[0]);
            }
        }
    }

    private boolean check(Matcher pMatcher, Matcher cMatcher) {
        return pMatcher.find() && cMatcher.find() && pMatcher.group(6).equals(cMatcher.group(6)) && pMatcher.group(5).equals(cMatcher.group(5)) && pMatcher.group(3).equals(cMatcher.group(3)) && (CheckPatches.accessChange(pMatcher.group(2), cMatcher.group(2)) || !pMatcher.group(4).equals(cMatcher.group(4)));
    }
}

