/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev.tasks.checks;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.minecraftforge.forgedev.tasks.checks.CheckTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public abstract class CheckExecs
extends CheckTask {
    @InputFile
    abstract RegularFileProperty getBinary();

    @InputFiles
    abstract ConfigurableFileCollection getExcs();

    @Override
    protected void check(CheckTask.Reporter reporter, boolean fix) throws Exception {
        Set<String> known = this.collectKnown();
        for (File file : this.getExcs().getFiles()) {
            ArrayList<String> lines = new ArrayList<String>();
            for (String line : Files.readAllLines(file.toPath(), StandardCharsets.UTF_8)) {
                int idx = line.indexOf(35);
                if (idx == 0 || line.isEmpty()) continue;
                if (idx != -1) {
                    line = line.substring(0, idx - 1);
                }
                if (!line.contains("=")) {
                    reporter.report("Invalid: " + line);
                    continue;
                }
                String[] pts = line.split("=", 2);
                if (!known.contains(pts[0])) {
                    reporter.report("Unknown: " + line);
                    continue;
                }
                String desc = pts[0].split("\\.", 2)[1];
                idx = desc.indexOf(40);
                if (idx == -1) {
                    reporter.report("Invalid: " + line);
                    return;
                }
                desc = desc.substring(idx);
                String exception = pts[1];
                String args = "";
                idx = exception.indexOf(124);
                if (idx != -1) {
                    args = exception.substring(idx + 1);
                    exception = exception.substring(0, idx);
                }
                if (args.split(",").length != Type.getArgumentTypes((String)desc).length) {
                    reporter.report("Invalid: " + line);
                    continue;
                }
                lines.add(line);
            }
            if (!fix) continue;
            Collections.sort(lines);
            Files.writeString(file.toPath(), (CharSequence)String.join((CharSequence)"\n", lines), StandardCharsets.UTF_8, new OpenOption[0]);
        }
    }

    private Set<String> collectKnown() throws IOException {
        HashSet<String> ret = new HashSet<String>();
        File jar = (File)this.getBinary().getAsFile().get();
        try (ZipInputStream zin = new ZipInputStream(new FileInputStream(jar));){
            ZipEntry entry;
            while ((entry = zin.getNextEntry()) != null) {
                if (!entry.getName().equals(".class")) continue;
                ClassReader reader = new ClassReader((InputStream)zin);
                reader.accept(CheckExecs.visitor(ret::add), 7);
            }
        }
        return ret;
    }

    private static ClassVisitor visitor(final Consumer<String> known) {
        return new ClassVisitor(589824){
            private String cls;

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                this.cls = name;
            }

            public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                known.accept(this.cls + "." + name + descriptor);
                return super.visitMethod(access, name, descriptor, signature, exceptions);
            }
        };
    }
}

