/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev.tasks.checks;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.ToIntFunction;
import net.minecraftforge.forgedev.legacy.tasks.InheritanceData;
import net.minecraftforge.forgedev.tasks.checks.ATFile;
import net.minecraftforge.forgedev.tasks.checks.CheckTask;
import net.minecraftforge.srgutils.IMappingFile;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;

public abstract class CheckATs
extends CheckTask {
    @InputFile
    public abstract RegularFileProperty getInheritance();

    @InputFiles
    public abstract ConfigurableFileCollection getAts();

    @InputFile
    @Optional
    public abstract RegularFileProperty getMappings();

    @Override
    protected void check(CheckTask.Reporter reporter, boolean fix) throws Exception {
        Map<String, InheritanceData> inheritance = InheritanceData.parse(((RegularFile)this.getInheritance().get()).getAsFile());
        for (File at : this.getAts().getFiles()) {
            ATFile parsed = this.process(at, reporter, inheritance);
            if (!fix) continue;
            IMappingFile mappings = IMappingFile.load((File)((File)this.getMappings().getAsFile().get()));
            List<String> lines = this.joinBack(parsed, inheritance, mappings);
            Files.writeString(at.toPath(), (CharSequence)String.join((CharSequence)"\n", lines), StandardCharsets.UTF_8, new OpenOption[0]);
        }
    }

    protected ATFile process(File file, CheckTask.Reporter reporter, Map<String, InheritanceData> inheritance) throws IOException {
        ATFile ret = ATFile.parse(this.getObjects(), file);
        for (ATFile.Entry entry : ret.errors) {
            for (String string : entry.errors) {
                reporter.report(string, false);
            }
        }
        TreeMap<String, Object> constructorGroups = new TreeMap<String, Object>();
        HashSet<String> toRemove = new HashSet<String>();
        Iterator<Map.Entry<String, ATFile.Entry>> itr = ret.getEntries().entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<String, ATFile.Entry> entry = itr.next();
            String key = entry.getKey();
            ATFile.Entry entry2 = entry.getValue();
            if (entry2 == null) continue;
            for (String error : entry2.errors) {
                reporter.report(error, false);
            }
            String binaryName = entry2.cls.replace('.', '/');
            InheritanceData jcls = inheritance.get(binaryName);
            if (jcls == null) {
                itr.remove();
                reporter.report("Invalid Entry, Missing class: " + key);
                continue;
            }
            ATFile.Group group = entry2.asGroup();
            if (group != null) {
                if ("*".equals(entry2.desc)) {
                    if (jcls.fields() == null || jcls.fields().isEmpty()) {
                        itr.remove();
                        reporter.report("Invalid group, class has no fields: " + key);
                        continue;
                    }
                    this.handleGroup(reporter, ret, entry2.cls, toRemove, group, jcls.fields(), InheritanceData.Field::access);
                    continue;
                }
                if ("*()".equals(entry2.desc)) {
                    if (jcls.methods() == null || jcls.methods().isEmpty()) {
                        itr.remove();
                        reporter.report("Invalid group, class has no methods: " + key);
                        continue;
                    }
                    this.handleGroup(reporter, ret, entry2.cls, toRemove, group, jcls.methods(), InheritanceData.Method::access);
                    continue;
                }
                if (!"<init>".equals(entry2.desc)) continue;
                constructorGroups.put(binaryName, group);
                continue;
            }
            if (entry2.desc.isEmpty()) {
                if (CheckATs.strength(jcls.access()) <= entry2.strength() || entry2.isForced()) continue;
                itr.remove();
                reporter.report("Invalid Narrowing: " + key);
                continue;
            }
            if (!entry2.desc.contains("(")) {
                if (jcls.fields() == null || !jcls.fields().containsKey(entry2.desc)) {
                    itr.remove();
                    reporter.report("Invalid: " + key);
                    continue;
                }
                InheritanceData.Field field = jcls.fields().get(entry2.desc);
                if (CheckATs.strength(field.access()) <= entry2.strength() || entry2.isForced()) continue;
                itr.remove();
                reporter.report("Invalid Narrowing: " + key);
                continue;
            }
            String string = entry2.desc.replace("(", " (");
            if (jcls.methods() == null || !jcls.methods().containsKey(string)) {
                itr.remove();
                reporter.report("Invalid: $key");
                continue;
            }
            InheritanceData.Method value = jcls.methods().get(string);
            if (CheckATs.strength(value.access()) <= entry2.strength() || entry2.isForced()) continue;
            itr.remove();
            reporter.report("Invalid Narrowing: " + key);
        }
        for (Map.Entry entry : inheritance.entrySet()) {
            String tcls = (String)entry.getKey();
            InheritanceData value = (InheritanceData)entry.getValue();
            if (value.methods() == null || value.methods().isEmpty() || (value.access() & 0x400) != 0) continue;
            String parent = tcls;
            while (parent != null) {
                InheritanceData iparent;
                ATFile.Group group = (ATFile.Group)constructorGroups.get(parent);
                if (group != null) {
                    for (Map.Entry entry3 : value.methods().entrySet()) {
                        if (!((String)entry3.getKey()).startsWith("<init>")) continue;
                        String child = tcls.replace('/', '.') + " " + ((String)entry3.getKey()).replace(" ", "");
                        if (CheckATs.strength(((InheritanceData.Method)entry3.getValue()).access()) < 3) {
                            if (ret.getEntries().containsKey(child)) {
                                toRemove.add(child);
                            } else if (!group.existing.contains(child)) {
                                reporter.report("Missing group entry: " + child);
                            }
                            group.children.add(child);
                            continue;
                        }
                        if (!ret.getEntries().containsKey(child)) continue;
                        toRemove.add(child);
                        reporter.report("Found invalid group entry: " + child);
                    }
                }
                parent = (iparent = inheritance.get(parent)) == null ? null : iparent.superName();
            }
        }
        for (ATFile.Group group : constructorGroups.values()) {
            for (String existing : group.existing) {
                if (group.children.contains(existing)) continue;
                reporter.report("Found invalid group entry: " + existing);
            }
        }
        for (String string : toRemove) {
            ret.getEntries().remove(string);
        }
        return ret;
    }

    private <M> void handleGroup(CheckTask.Reporter reporter, ATFile ret, String cls, Set<String> toRemove, ATFile.Group group, Map<String, M> members, ToIntFunction<M> toAccess) {
        for (Map.Entry<String, M> entry : members.entrySet()) {
            String ikey = entry.getKey();
            if (ikey.startsWith("<clinit>") || ikey.startsWith("lambda$")) continue;
            String key = cls + " " + ikey.replace(" ", "");
            if (CheckATs.strength(toAccess.applyAsInt(entry.getValue())) < group.strength()) {
                toRemove.add(key);
                if (!group.existing.contains(key)) {
                    reporter.report("Missing group entry: " + key);
                }
                group.children.add(key);
                continue;
            }
            if (!ret.getEntries().containsKey(key)) continue;
            toRemove.add(key);
            reporter.report("Found ungrouped group entry: " + key);
        }
        for (String existing : group.existing) {
            if (group.children.contains(existing)) continue;
            reporter.report("Found extra group entry: " + existing);
        }
    }

    private static int strength(int access) {
        if ((access & 1) != 0) {
            return 3;
        }
        if ((access & 4) != 0) {
            return 2;
        }
        if ((access & 2) != 0) {
            return 0;
        }
        return 1;
    }

    private List<String> joinBack(ATFile at, Map<String, InheritanceData> inheritance, IMappingFile mappings) {
        ArrayList<String> data = new ArrayList<String>();
        for (Map.Entry<String, ATFile.Entry> entry : at.getEntries().entrySet()) {
            String key = entry.getKey();
            ATFile.Entry value = entry.getValue();
            ATFile.Group group = value.asGroup();
            if (group == null) {
                CheckATs.add(data, value.modifier + " " + value.key, CheckATs.remapComment(mappings, inheritance, value));
                continue;
            }
            CheckATs.add(data, "#group " + value.modifier + " " + key, group.comment);
            for (String child : group.children) {
                ATFile.Entry childEntry = (ATFile.Entry)this.getObjects().newInstance(ATFile.Entry.class, new Object[]{value.modifier + " " + child});
                CheckATs.add(data, value.modifier + " " + child, CheckATs.remapComment(mappings, inheritance, childEntry));
            }
            data.add("#endgroup");
        }
        return data;
    }

    private static void add(List<String> lst, String line, String comment) {
        if (comment != null) {
            lst.add((line + " " + comment).trim());
        } else {
            lst.add(line.trim());
        }
    }

    private static String remapComment(IMappingFile mappings, Map<String, InheritanceData> inheritance, ATFile.Entry entry) {
        String mappedName;
        if (entry.desc == null || entry.desc.isEmpty()) {
            return null;
        }
        String comment = entry.comment != null ? entry.comment.substring(1).trim() : null;
        InheritanceData jsonCls = inheritance.get(entry.cls.replace('.', '/'));
        IMappingFile.IClass mapCls = mappings.getClass(jsonCls.name());
        if (mapCls == null) {
            return entry.comment;
        }
        int idx = entry.desc.indexOf(40);
        String string = mappedName = idx == -1 ? mapCls.remapField(entry.desc) : mapCls.remapMethod(entry.desc.substring(0, idx), entry.desc.substring(idx));
        if (mappedName == null || mappedName.isEmpty()) {
            return entry.comment;
        }
        if ("<init>".equals(mappedName)) {
            mappedName = "constructor";
        }
        if (comment == null) {
            return "# " + mappedName;
        }
        if (comment.startsWith(mappedName)) {
            return "# " + comment;
        }
        if (comment.indexOf(32) != -1) {
            ArrayList<String> split = new ArrayList<String>(List.of(comment.split(" - ")));
            if (split.get(0).indexOf(32) != -1) {
                return "# " + mappedName + " - " + comment;
            }
            split.remove(0);
            return "# " + mappedName + " - " + String.join((CharSequence)" - ", split);
        }
        return "# " + mappedName;
    }
}

