/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev.tasks.checks;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.inject.Inject;
import org.gradle.api.model.ObjectFactory;
import org.jspecify.annotations.Nullable;

public abstract class ATFile {
    private Map<String, Entry> entries;
    protected List<Entry> errors;

    @Inject
    public ATFile(Map<String, Entry> entries, List<Entry> errors) {
        this.entries = entries;
        this.errors = errors;
    }

    public Map<String, Entry> getEntries() {
        return this.entries;
    }

    static ATFile parse(ObjectFactory objects, File file) throws IOException {
        List<String> lines = Files.readAllLines(file.toPath(), StandardCharsets.UTF_8);
        return ATFile.parse(objects, lines);
    }

    static ATFile parse(ObjectFactory objects, List<String> lines) {
        TreeMap<String, Group> entries = new TreeMap<String, Group>();
        ArrayList<Group> errors = new ArrayList<Group>();
        Entry group = null;
        for (String line : lines) {
            Entry old;
            Entry entry;
            if (line.isEmpty()) continue;
            if (line.startsWith("#group ")) {
                entry = (Group)objects.newInstance(Group.class, new Object[]{line.substring(7)});
                if (!(entry.desc.equals("*") || entry.desc.equals("*()") || entry.desc.equals("<init>"))) {
                    entry.errors.add("Invalid group: " + line);
                }
                group = entry;
                old = entries.put(entry.key, (Group)entry);
                if (old == null) continue;
                entry.errors.add("Duplicate group: " + line);
                continue;
            }
            if (group != null) {
                if (line.startsWith("#endgroup")) {
                    group = null;
                    continue;
                }
                entry = (Entry)objects.newInstance(Entry.class, new Object[]{line});
                group.existing.add(entry.key);
                continue;
            }
            if (line.startsWith("#endgroup")) {
                entry = (Entry)objects.newInstance(Entry.class, new Object[]{line});
                entry.errors.add("Invalid group ending: " + line);
                errors.add((Group)entry);
                continue;
            }
            if (line.startsWith("#") || (old = (Entry)entries.put(entry.key, (Group)(entry = (Entry)objects.newInstance(Entry.class, new Object[]{line})))) == null) continue;
            entry.errors.add("Duplicate entry: " + line);
        }
        return (ATFile)objects.newInstance(ATFile.class, new Object[]{entries, errors});
    }

    public static abstract class Group
    extends Entry {
        public final Set<String> existing = new LinkedHashSet<String>();
        public final Set<String> children = new TreeSet<String>();

        @Inject
        public Group(String line) {
            super(line);
        }

        @Override
        public @Nullable Group asGroup() {
            return this;
        }
    }

    public static abstract class Entry {
        public final String line;
        public final String key;
        public final String modifier;
        public final String cls;
        public final String desc;
        public final @Nullable String comment;
        final List<String> errors = new ArrayList<String>();

        @Inject
        public Entry(String line) {
            this.line = line;
            int idx = line.indexOf(35);
            if (idx == -1) {
                this.comment = null;
            } else {
                this.comment = line.substring(idx);
                line = line.substring(0, idx - 1);
            }
            String[] data = (line.trim() + "     ").split(" ", -1);
            this.modifier = data[0];
            this.cls = data[1].replace('/', '.');
            this.desc = data[2];
            this.key = this.desc.isEmpty() ? this.cls : this.cls + " " + this.desc;
        }

        public @Nullable Group asGroup() {
            return null;
        }

        public int strength() {
            if (this.modifier.endsWith("-f") || this.modifier.endsWith("+f")) {
                return 4;
            }
            return switch (this.modifier.toLowerCase(Locale.ENGLISH)) {
                case "public" -> 3;
                case "protected" -> 2;
                case "default" -> 1;
                case "private" -> 0;
                default -> -1;
            };
        }

        public boolean isForced() {
            return this.comment != null && this.comment.startsWith("#force ");
        }
    }
}

