/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev.tasks;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.minecraftforge.srgutils.MinecraftVersion;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.TaskAction;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public abstract class ValidateDeprecations
extends DefaultTask {
    @InputFile
    public abstract RegularFileProperty getInput();

    @Input
    public abstract Property<String> getMcVersion();

    @TaskAction
    protected void exec() throws IOException {
        MinecraftVersion mcVer = MinecraftVersion.from((String)((String)this.getMcVersion().get()));
        ArrayList<String[]> errors = new ArrayList<String[]>();
        try (ZipInputStream zin = new ZipInputStream(new FileInputStream((File)this.getInput().getAsFile().get()));){
            ZipEntry ze;
            while ((ze = zin.getNextEntry()) != null) {
                if (!ze.getName().endsWith(".class")) continue;
                ClassNode classNode = new ClassNode();
                new ClassReader((InputStream)zin).accept((ClassVisitor)classNode, 0);
                ValidateDeprecations.processNode(mcVer, errors, classNode);
            }
        }
        if (!errors.isEmpty()) {
            for (String[] error : errors) {
                this.getLogger().error("Deprecated {} is marked for removal in {} but is not yet removed", (Object)error[0], (Object)error[1]);
            }
            throw new IllegalStateException("Found deprecated members marked for removal but not yet removed in " + String.valueOf(mcVer) + "; see log for details");
        }
    }

    private static void processNode(MinecraftVersion mcVer, List<String[]> errors, ClassNode node) {
        ValidateDeprecations.processAnnotations(node.visibleAnnotations, mcVer, errors, "class " + node.name);
        if (node.fields != null) {
            for (FieldNode field : node.fields) {
                ValidateDeprecations.processAnnotations(field.visibleAnnotations, mcVer, errors, "field " + node.name + "#" + field.name);
            }
        }
        if (node.methods != null) {
            for (MethodNode method : node.methods) {
                ValidateDeprecations.processAnnotations(method.visibleAnnotations, mcVer, errors, "method " + node.name + "#" + method.name + method.desc);
            }
        }
    }

    private static void processAnnotations(List<AnnotationNode> annotations, MinecraftVersion mcVer, List<String[]> errors, String marker) {
        if (annotations == null) {
            return;
        }
        for (AnnotationNode annotation : annotations) {
            ValidateDeprecations.processAnnotations(annotation, mcVer, errors, marker);
        }
    }

    private static void processAnnotations(AnnotationNode annotation, MinecraftVersion mcVer, List<String[]> errors, String marker) {
        List values = annotation.values;
        if (values == null) {
            return;
        }
        int forRemoval = values.indexOf("forRemoval");
        int since = values.indexOf("since");
        if ("Ljava/lang/Deprecated;".equals(annotation.desc) && forRemoval != -1 && since != -1 && values.size() >= 4 && ((Boolean)values.get(forRemoval + 1)).booleanValue()) {
            MinecraftVersion oldVersion = MinecraftVersion.from((String)values.get(since + 1).toString());
            int[] split = ValidateDeprecations.splitDots(oldVersion.toString());
            if (split.length < 2) {
                return;
            }
            MinecraftVersion removeVersion = MinecraftVersion.from((String)(split[0] + "." + (split[1] + 1)));
            if (removeVersion.compareTo(mcVer) <= 0) {
                errors.add(new String[]{marker, removeVersion.toString()});
            }
        }
    }

    private static int[] splitDots(String version) {
        String[] pts = version.split("\\.");
        int[] values = new int[pts.length];
        for (int x = 0; x < pts.length; ++x) {
            values[x] = Integer.parseInt(pts[x]);
        }
        return values;
    }
}

