/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev.tasks;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.inject.Inject;
import net.minecraftforge.forgedev.tasks.SingleFileOutput;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public abstract class MethodCallFinder
extends DefaultTask
implements SingleFileOutput {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    @InputFile
    public abstract RegularFileProperty getJar();

    @Input
    public abstract Property<Boolean> getAllowEmpty();

    @Input
    public abstract SetProperty<String> getBlacklist();

    @Input
    public abstract Property<MethodReference> getTarget();

    @Override
    @Internal
    public abstract RegularFileProperty getOutput();

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    public MethodCallFinder() {
        this.getOutput().convention(this.getProject().getLayout().getBuildDirectory().file(this.getName() + "/output.json"));
        this.getAllowEmpty().convention((Object)false);
    }

    public void blacklist(String cls) {
        this.getBlacklist().add((Object)cls);
    }

    public void invokeVirtual(String name, String desc) {
        this.call(182, name, desc);
    }

    public void invokeSpecial(String name, String desc) {
        this.call(183, name, desc);
    }

    public void invokeStatic(String name, String desc) {
        this.call(184, name, desc);
    }

    public void invokeInterface(String name, String desc) {
        this.call(185, name, desc);
    }

    private void call(int opcode, String name, String desc) {
        this.getTarget().set((Object)new MethodReference(opcode, name, desc));
    }

    @TaskAction
    public void exec() throws IOException {
        File output = (File)this.getOutput().getAsFile().get();
        Files.deleteIfExists(output.toPath());
        TreeMap data = new TreeMap(Comparator.naturalOrder());
        Set blacklist = (Set)this.getBlacklist().get();
        MethodReference target = (MethodReference)this.getTarget().get();
        Boolean allowEmpty = (Boolean)this.getAllowEmpty().get();
        try (ZipInputStream zin = new ZipInputStream(new FileInputStream((File)this.getJar().getAsFile().get()));){
            Object ze;
            while ((ze = zin.getNextEntry()) != null) {
                if (!((ZipEntry)ze).getName().endsWith(".class")) continue;
                ClassNode classNode = new ClassNode();
                new ClassReader((InputStream)zin).accept((ClassVisitor)classNode, 0);
                if (blacklist.contains(classNode.name) || classNode.methods == null) continue;
                block6: for (MethodNode methodNode : classNode.methods) {
                    if (!allowEmpty.booleanValue() && (methodNode.access & 0x1000) != 0) continue;
                    for (AbstractInsnNode insn : methodNode.instructions) {
                        if (insn.getOpcode() != target.opcode || !(insn instanceof MethodInsnNode)) continue;
                        MethodInsnNode mtd = (MethodInsnNode)insn;
                        if (!mtd.name.equals(target.name) || !mtd.desc.equals(target.desc)) continue;
                        List list = data.computeIfAbsent(classNode.name, k -> new ArrayList());
                        if ((methodNode.access & 0x1000) != 0) continue block6;
                        list.add(methodNode.name + methodNode.desc);
                        continue block6;
                    }
                }
            }
        }
        ArrayList ret = new ArrayList();
        for (Map.Entry entry : data.entrySet()) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("class", entry.getKey());
            map.put("methods", entry.getValue());
            ret.add(map);
        }
        if (ret.isEmpty()) {
            throw new RuntimeException("Failed to find any targets, please ensure that method names and descriptors are correct.");
        }
        StringWriter string = new StringWriter();
        JsonWriter jsonWriter = GSON.newJsonWriter((Writer)string);
        jsonWriter.setIndent("    ");
        GSON.toJson(ret, ret.getClass(), jsonWriter);
        Files.writeString(output.toPath(), (CharSequence)string.toString(), StandardCharsets.UTF_8, new OpenOption[0]);
    }

    public record MethodReference(int opcode, String name, String desc) implements Serializable
    {
    }
}

