/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev.legacy.values;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraftforge.forgedev.legacy.tasks.Util;
import net.minecraftforge.forgedev.legacy.values.MavenInfo;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;

public record MinimalResolvedArtifact(MavenInfo info, File file) implements Serializable
{
    private static Provider<MinimalResolvedArtifact> from(Project project, ProjectDependency projectDependency, FileCollection files) {
        MavenInfo info = MavenInfo.from(projectDependency);
        Property ret = project.getObjects().property(MinimalResolvedArtifact.class).value(project.provider(() -> ((FileCollection)files).getSingleFile()).map(file -> new MinimalResolvedArtifact(info, (File)file)));
        return (Provider)Util.finalize(project, ret);
    }

    public static Provider<MinimalResolvedArtifact> from(Project project, TaskProvider<? extends AbstractArchiveTask> task) {
        Property ret = project.getObjects().property(MinimalResolvedArtifact.class).value(MavenInfo.from(project, task).zip(task.flatMap(AbstractArchiveTask::getArchiveFile).map(RegularFile::getAsFile), MinimalResolvedArtifact::new));
        return (Provider)Util.finalize(project, ret);
    }

    public static MinimalResolvedArtifact from(Project project, ResolvedArtifactResult artifact) {
        MavenInfo info = MavenInfo.from(project, artifact);
        return new MinimalResolvedArtifact(info, artifact.getFile());
    }

    public static Provider<List<MinimalResolvedArtifact>> from(Project project, Configuration configuration) {
        ListProperty ret = project.getObjects().listProperty(MinimalResolvedArtifact.class);
        ret.addAll(configuration.getIncoming().getArtifacts().getResolvedArtifacts().map(MinimalResolvedArtifact.transform(project)));
        return (Provider)Util.finalize(project, ret);
    }

    private static Transformer<List<MinimalResolvedArtifact>, Set<ResolvedArtifactResult>> transform(Project project) {
        return results -> {
            ArrayList<MinimalResolvedArtifact> artifacts = new ArrayList<MinimalResolvedArtifact>(results.size());
            for (ResolvedArtifactResult artifact : results) {
                artifacts.add(MinimalResolvedArtifact.from(project, artifact));
            }
            return artifacts;
        };
    }

    public static Provider<MinimalResolvedArtifact> single(Project project, String artifact) {
        return MinimalResolvedArtifact.from(project, artifact, false).map(l -> (MinimalResolvedArtifact)l.get(0));
    }

    public static Provider<MinimalResolvedArtifact> from(MavenInfo info, Provider<RegularFile> file) {
        return file.map(f -> new MinimalResolvedArtifact(info, f.getAsFile()));
    }

    public static Provider<List<MinimalResolvedArtifact>> from(Project project, String artifact) {
        return MinimalResolvedArtifact.from(project, artifact, true);
    }

    public static Provider<List<MinimalResolvedArtifact>> from(Project project, String artifact, boolean transitive) {
        ListProperty ret = project.getObjects().listProperty(MinimalResolvedArtifact.class);
        Configuration c = project.getConfigurations().detachedConfiguration(new Dependency[]{project.getDependencies().create((Object)artifact)});
        c.setTransitive(transitive);
        ret.set(c.getIncoming().getArtifacts().getResolvedArtifacts().map(MinimalResolvedArtifact.transform(project)));
        return (Provider)Util.finalize(project, ret);
    }

    private static void from(Project project, ProjectDependency projectDependency, ListProperty<MinimalResolvedArtifact> ret) {
        ConfigurationContainer configurations = project.getConfigurations();
        Project subproject = project.project(projectDependency.getPath());
        Configuration singleFile = configurations.detachedConfiguration(new Dependency[]{projectDependency});
        singleFile.setTransitive(false);
        ret.add(MinimalResolvedArtifact.from(subproject, projectDependency, (FileCollection)singleFile));
        Configuration transitive = configurations.detachedConfiguration(new Dependency[]{projectDependency});
        for (Dependency d : transitive.getAllDependencies()) {
            if (d.equals(projectDependency)) continue;
            if (d instanceof ProjectDependency) {
                ProjectDependency nestedProjectDependency = (ProjectDependency)d;
                MinimalResolvedArtifact.from(project, nestedProjectDependency, ret);
                continue;
            }
            Configuration c = configurations.detachedConfiguration(new Dependency[]{d});
            c.setTransitive(false);
            for (ResolvedArtifactResult artifact : (Set)c.getIncoming().getArtifacts().getResolvedArtifacts().get()) {
                ret.add((Object)MinimalResolvedArtifact.from(project, artifact));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof MinimalResolvedArtifact)) return false;
        MinimalResolvedArtifact that = (MinimalResolvedArtifact)obj;
        if (!Objects.equals(this.info.name(), that.info.name())) return false;
        return true;
    }
}

