/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev.legacy.values;

import java.io.Serializable;
import java.text.MessageFormat;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactIdentifier;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.jetbrains.annotations.Nullable;

public record MavenInfo(String key, String name, String path, ArtifactInfo art) implements Serializable,
Comparable<MavenInfo>
{
    @Override
    public int compareTo(MavenInfo that) {
        return this.key.compareTo(that.key);
    }

    public static MavenInfo from(String gav) {
        String[] parts = gav.split(":");
        String group = parts[0];
        String name = parts[1];
        String version = parts[2];
        String classifier = null;
        String extension = null;
        if (parts.length > 3) {
            classifier = parts[3];
            int idx = classifier.indexOf(64);
            if (idx != -1) {
                classifier = classifier.substring(0, idx);
                extension = classifier.substring(idx + 1);
            }
        } else {
            int idx = version.indexOf(64);
            if (idx != -1) {
                extension = version.substring(idx + 1);
                version = version.substring(0, idx);
            }
        }
        return MavenInfo.from(group, name, version, classifier, extension);
    }

    public static MavenInfo from(String artGroup, String artName, String artVersion, @Nullable String artClassifier, @Nullable String artExtension) {
        if (artExtension == null) {
            artExtension = "jar";
        }
        String key = artGroup + ":" + artName;
        String name = key + ":" + artVersion;
        Object path = MessageFormat.format("{0}/{1}/{2}/{1}-{2}", artGroup.replace('.', '/'), artName, artVersion);
        if (artClassifier != null) {
            name = name + ":" + artClassifier;
            path = (String)path + "-" + artClassifier;
        }
        if (!"jar".equals(artExtension)) {
            name = name + "@" + artExtension;
        }
        path = (String)path + "." + artExtension;
        return new MavenInfo(key, name, (String)path, new ArtifactInfo(artGroup, artName, artVersion, artClassifier, artExtension));
    }

    public static MavenInfo from(Project project, ResolvedArtifactResult dependency) {
        String extension;
        String classifier;
        String version;
        String name;
        String group;
        ComponentArtifactIdentifier component = dependency.getId();
        if (component instanceof ModuleComponentArtifactIdentifier) {
            ModuleComponentArtifactIdentifier moduleId = (ModuleComponentArtifactIdentifier)component;
            group = moduleId.getComponentIdentifier().getGroup();
            name = moduleId.getComponentIdentifier().getModule();
            version = moduleId.getComponentIdentifier().getVersion();
            if (moduleId instanceof DefaultModuleComponentArtifactIdentifier) {
                DefaultModuleComponentArtifactIdentifier defaultId = (DefaultModuleComponentArtifactIdentifier)moduleId;
                classifier = defaultId.getName().getClassifier();
                extension = defaultId.getName().getExtension();
            } else {
                classifier = null;
                extension = null;
            }
        } else {
            ComponentIdentifier defaultId = component.getComponentIdentifier();
            if (defaultId instanceof ProjectComponentIdentifier) {
                ProjectComponentIdentifier projectId = (ProjectComponentIdentifier)defaultId;
                Project p = project.findProject(projectId.getProjectPath());
                if (p == null) {
                    throw new IllegalArgumentException("Cannot get maven info for a project dependency that has no project: " + String.valueOf(projectId));
                }
                group = p.getGroup().toString();
                name = p.getName();
                version = p.getVersion().toString();
                classifier = null;
                extension = null;
            } else {
                throw new IllegalArgumentException("Cannot get maven info for a local/unknown dependency:" + String.valueOf(component) + " (" + String.valueOf(component.getClass()) + ")");
            }
        }
        return MavenInfo.from(group, name, version, classifier, extension);
    }

    public static MavenInfo from(Project project) {
        return MavenInfo.from(project, (String)null);
    }

    public static MavenInfo from(ProjectDependency project) {
        return MavenInfo.from(project.getGroup(), project.getName(), project.getVersion(), null, null);
    }

    public static MavenInfo from(Project project, String classifier) {
        return MavenInfo.from(project.getGroup().toString(), project.getName(), project.getVersion().toString(), classifier, null);
    }

    public static Provider<MavenInfo> from(Project project, TaskProvider<? extends AbstractArchiveTask> task) {
        Property ret = project.getObjects().property(MavenInfo.class).value(project.getProviders().zip(task.flatMap(AbstractArchiveTask::getArchiveClassifier), task.flatMap(AbstractArchiveTask::getArchiveExtension), (classifier, extension) -> MavenInfo.from(project.getGroup().toString(), project.getName(), project.getVersion().toString(), classifier, extension)));
        ret.disallowChanges();
        ret.finalizeValueOnRead();
        if (project.getState().getExecuted()) {
            ret.finalizeValue();
        }
        return ret;
    }

    public record ArtifactInfo(String group, String name, String version, @Nullable String classifier, String extension) implements Serializable
    {
    }
}

